/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal.session.manager;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.oauth.client.persistence.model.OAuthClientEntry;
import com.liferay.oauth.client.persistence.service.OAuthClientEntryLocalService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.openid.connect.configuration.OpenIdConnectConfiguration;
import com.liferay.portal.security.sso.openid.connect.internal.AuthorizationServerMetadataResolver;
import com.liferay.portal.security.sso.openid.connect.internal.util.OpenIdConnectTokenRequestUtil;
import com.liferay.portal.security.sso.openid.connect.persistence.model.OpenIdConnectSession;
import com.liferay.portal.security.sso.openid.connect.persistence.service.OpenIdConnectSessionLocalService;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import java.util.Date;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import net.minidev.json.JSONObject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.sso.openid.connect.configuration.OpenIdConnectConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, service={OfflineOpenIdConnectSessionManager.class})
public class OfflineOpenIdConnectSessionManager {
    private static final Log _log = LogFactoryUtil.getLog(OfflineOpenIdConnectSessionManager.class);
    @Reference
    private AuthorizationServerMetadataResolver _authorizationServerMetadataResolver;
    private volatile BundleContext _bundleContext;
    @Reference
    private ClusterMasterExecutor _clusterMasterExecutor;
    @Reference
    private CounterLocalService _counterLocalService;
    @Reference
    private DestinationFactory _destinationFactory;
    private ServiceRegistration<Destination> _destinationServiceRegistration;
    @Reference
    private MessageBus _messageBus;
    private ServiceRegistration<MessageListener> _messageListenerServiceRegistration;
    @Reference
    private OAuthClientEntryLocalService _oAuthClientEntryLocalService;
    @Reference
    private OpenIdConnectSessionLocalService _openIdConnectSessionLocalService;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    private volatile long _tokenRefreshOffsetMillis = 60000L;
    private volatile int _tokenRefreshScheduledInterval = 480;
    private TokensRefreshMessageListener _tokensRefreshMessageListener;
    @Reference
    private TriggerFactory _triggerFactory;

    public boolean isOpenIdConnectSession(HttpSession httpSession) {
        if (httpSession == null) {
            return false;
        }
        Long openIdConnectSessionId = (Long)httpSession.getAttribute("OPEN_ID_CONNECT_SESSION_ID");
        return openIdConnectSessionId != null;
    }

    public boolean isOpenIdConnectSessionExpired(HttpSession httpSession) {
        Long openIdConnectSessionId = (Long)httpSession.getAttribute("OPEN_ID_CONNECT_SESSION_ID");
        if (openIdConnectSessionId == null) {
            return true;
        }
        OpenIdConnectSession openIdConnectSession = this._openIdConnectSessionLocalService.fetchOpenIdConnectSession(openIdConnectSessionId.longValue());
        if (openIdConnectSession == null) {
            return true;
        }
        Date accessTokenExpirationDate = openIdConnectSession.getAccessTokenExpirationDate();
        long currentTime = System.currentTimeMillis();
        if (currentTime > accessTokenExpirationDate.getTime() - this._tokenRefreshOffsetMillis) {
            Message message = new Message();
            message.put("openIdConnectSessionId", (Object)openIdConnectSessionId);
            if (!this._clusterMasterExecutor.isEnabled() || this._clusterMasterExecutor.isMaster()) {
                this._messageBus.sendMessage("liferay/openid_connect_token_refresh", message);
            } else {
                this._executeOnMaster(message);
            }
        }
        return false;
    }

    public long startOpenIdConnectSession(String authServerWellKnownURI, String clientId, OIDCTokens oidcTokens, long userId) {
        OpenIdConnectSession openIdConnectSession = this._openIdConnectSessionLocalService.fetchOpenIdConnectSession(userId, authServerWellKnownURI, clientId);
        if (openIdConnectSession == null) {
            openIdConnectSession = this._openIdConnectSessionLocalService.createOpenIdConnectSession(this._counterLocalService.increment(OpenIdConnectSession.class.getName()));
        }
        this._updateOpenIdConnectSession(oidcTokens.getAccessToken(), authServerWellKnownURI, clientId, oidcTokens.getIDTokenString(), oidcTokens.getRefreshToken(), openIdConnectSession, userId);
        return openIdConnectSession.getOpenIdConnectSessionId();
    }

    @Modified
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) throws Exception {
        this._bundleContext = bundleContext;
        OpenIdConnectConfiguration openIdConnectConfiguration = (OpenIdConnectConfiguration)ConfigurableUtil.createConfigurable(OpenIdConnectConfiguration.class, properties);
        if (openIdConnectConfiguration.tokenRefreshOffset() < 30) {
            throw new IllegalArgumentException("Token refresh offset needs to be at least 30 seconds");
        }
        this._tokenRefreshOffsetMillis = (long)openIdConnectConfiguration.tokenRefreshOffset() * 1000L;
        this._tokenRefreshScheduledInterval = openIdConnectConfiguration.tokenRefreshScheduledInterval();
        if (!openIdConnectConfiguration.enabled()) {
            this.deactivate();
            return;
        }
        this._registerServices(bundleContext);
        if (this._tokenRefreshScheduledInterval < 30) {
            this._unscheduleJob();
        } else {
            this._scheduleJob();
        }
    }

    @Deactivate
    protected void deactivate() {
        this._unscheduleJob();
        this._unregisterServices();
    }

    private void _executeOnMaster(Message message) {
        block2: {
            try {
                this._clusterMasterExecutor.executeOnMaster(new MethodHandler(MessageBusUtil.class.getDeclaredMethod("sendMessage", String.class, Message.class), new Object[]{"liferay/openid_connect_token_refresh", message}));
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)exception);
            }
        }
    }

    private AccessToken _extendOpenIdConnectSession(OpenIdConnectSession openIdConnectSession) {
        if (Validator.isNull((String)openIdConnectSession.getRefreshToken())) {
            this._openIdConnectSessionLocalService.deleteOpenIdConnectSession(openIdConnectSession);
            return null;
        }
        RefreshToken refreshToken = new RefreshToken(openIdConnectSession.getRefreshToken());
        OAuthClientEntry oAuthClientEntry = this._oAuthClientEntryLocalService.fetchOAuthClientEntry(openIdConnectSession.getCompanyId(), openIdConnectSession.getAuthServerWellKnownURI(), openIdConnectSession.getClientId());
        if (oAuthClientEntry == null) {
            this._openIdConnectSessionLocalService.deleteOpenIdConnectSession(openIdConnectSession);
            return null;
        }
        try {
            OIDCTokens oidcTokens = OpenIdConnectTokenRequestUtil.request(OIDCClientInformation.parse((JSONObject)JSONObjectUtils.parse((String)oAuthClientEntry.getInfoJSON())), this._authorizationServerMetadataResolver.resolveOIDCProviderMetadata(openIdConnectSession.getAuthServerWellKnownURI()), refreshToken, oAuthClientEntry.getTokenRequestParametersJSON());
            this._updateOpenIdConnectSession(oidcTokens.getAccessToken(), openIdConnectSession, oidcTokens.getRefreshToken());
            return oidcTokens.getAccessToken();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            this._openIdConnectSessionLocalService.deleteOpenIdConnectSession(openIdConnectSession);
            return null;
        }
    }

    private void _registerServices(BundleContext bundleContext) {
        if (this._messageListenerServiceRegistration != null) {
            return;
        }
        DestinationConfiguration destinationConfiguration = DestinationConfiguration.createSerialDestinationConfiguration((String)"liferay/openid_connect_token_refresh");
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        HashMapDictionary dictionary = HashMapDictionaryBuilder.put((Object)"destination.name", (Object)destination.getName()).build();
        this._destinationServiceRegistration = bundleContext.registerService(Destination.class, (Object)destination, (Dictionary)dictionary);
        this._messageListenerServiceRegistration = bundleContext.registerService(MessageListener.class, (Object)new TokenRefreshMessageListener(), (Dictionary)dictionary);
    }

    private void _scheduleJob() {
        SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl(TokensRefreshMessageListener.class.getName(), this._triggerFactory.createTrigger(TokensRefreshMessageListener.class.getName(), "com.liferay.portal.security.sso.openid.connect", null, null, this._tokenRefreshScheduledInterval, TimeUnit.SECOND));
        this._tokensRefreshMessageListener = new TokensRefreshMessageListener();
        this._schedulerEngineHelper.register((MessageListener)this._tokensRefreshMessageListener, (SchedulerEntry)schedulerEntry, "liferay/scheduler_dispatch");
    }

    private void _unregisterServices() {
        if (this._messageListenerServiceRegistration != null) {
            this._messageListenerServiceRegistration.unregister();
            this._messageListenerServiceRegistration = null;
        }
        if (this._destinationServiceRegistration != null) {
            Destination destination = (Destination)this._bundleContext.getService(this._destinationServiceRegistration.getReference());
            destination.destroy();
            this._destinationServiceRegistration.unregister();
            this._destinationServiceRegistration = null;
        }
    }

    private void _unscheduleJob() {
        if (this._tokensRefreshMessageListener != null) {
            this._schedulerEngineHelper.unregister((MessageListener)this._tokensRefreshMessageListener);
            this._tokensRefreshMessageListener = null;
        }
    }

    private void _updateOpenIdConnectSession(AccessToken accessToken, OpenIdConnectSession openIdConnectSession, RefreshToken refreshToken) {
        openIdConnectSession.setAccessToken(accessToken.toJSONString());
        if (refreshToken != null) {
            openIdConnectSession.setRefreshToken(refreshToken.toString());
        }
        long currentTime = System.currentTimeMillis();
        openIdConnectSession.setModifiedDate(new Date(currentTime));
        if (accessToken.getLifetime() > 0L) {
            openIdConnectSession.setAccessTokenExpirationDate(new Date(currentTime + accessToken.getLifetime() * 1000L));
        } else {
            openIdConnectSession.setAccessTokenExpirationDate(new Date(currentTime + 3600000L));
        }
        this._openIdConnectSessionLocalService.updateOpenIdConnectSession(openIdConnectSession);
    }

    private void _updateOpenIdConnectSession(AccessToken accessToken, String authServerWellKnownURI, String clientId, String idTokenString, RefreshToken refreshToken, OpenIdConnectSession openIdConnectSession, long userId) {
        openIdConnectSession.setUserId(userId);
        openIdConnectSession.setAuthServerWellKnownURI(authServerWellKnownURI);
        openIdConnectSession.setClientId(clientId);
        openIdConnectSession.setIdToken(idTokenString);
        this._updateOpenIdConnectSession(accessToken, openIdConnectSession, refreshToken);
    }

    private class TokensRefreshMessageListener
    extends BaseMessageListener {
        private TokensRefreshMessageListener() {
        }

        protected void doReceive(Message message) throws Exception {
            List openIdConnectSessions = OfflineOpenIdConnectSessionManager.this._openIdConnectSessionLocalService.getAccessTokenExpirationDateOpenIdConnectSessions(new Date(System.currentTimeMillis() + OfflineOpenIdConnectSessionManager.this._tokenRefreshOffsetMillis), -1, -1);
            for (OpenIdConnectSession openIdConnectSession : openIdConnectSessions) {
                OfflineOpenIdConnectSessionManager.this._extendOpenIdConnectSession(openIdConnectSession);
            }
        }
    }

    private class TokenRefreshMessageListener
    extends BaseMessageListener {
        private TokenRefreshMessageListener() {
        }

        protected void doReceive(Message message) throws Exception {
            Long openIdConnectSessionId = message.getLong("openIdConnectSessionId");
            if (openIdConnectSessionId == null || openIdConnectSessionId < 1L) {
                return;
            }
            OpenIdConnectSession openIdConnectSession = OfflineOpenIdConnectSessionManager.this._openIdConnectSessionLocalService.fetchOpenIdConnectSession(openIdConnectSessionId.longValue());
            if (openIdConnectSession == null) {
                return;
            }
            Date modifiedDate = openIdConnectSession.getModifiedDate();
            if (System.currentTimeMillis() <= modifiedDate.getTime() + OfflineOpenIdConnectSessionManager.this._tokenRefreshOffsetMillis) {
                return;
            }
            OfflineOpenIdConnectSessionManager.this._extendOpenIdConnectSession(openIdConnectSession);
        }
    }
}

