/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal.servlet.filter.auto.login;

import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnect;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectAuthenticationHandler;
import com.liferay.portal.security.sso.openid.connect.internal.exception.StrangersNotAllowedException;
import com.liferay.portal.security.sso.openid.connect.internal.session.manager.OfflineOpenIdConnectSessionManager;
import com.liferay.portal.servlet.filters.autologin.AutoLoginFilter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.sso.openid.connect.configuration.OpenIdConnectConfiguration"}, immediate=true, property={"after-filter=Virtual Host Filter", "servlet-context-name=", "servlet-filter-name=SSO OpenId Connect Auto Login Filter", "url-pattern=/c/portal/login/openidconnect"}, service={Filter.class, OpenIdConnectAutoLoginFilter.class})
public class OpenIdConnectAutoLoginFilter
extends AutoLoginFilter {
    private static final Log _log = LogFactoryUtil.getLog(OpenIdConnectAutoLoginFilter.class);
    @Reference
    private OfflineOpenIdConnectSessionManager _offlineOpenIdConnectSessionManager;
    @Reference
    private OpenIdConnect _openIdConnect;
    @Reference
    private OpenIdConnectAuthenticationHandler _openIdConnectAuthenticationHandler;
    @Reference
    private Portal _portal;

    public boolean isFilterEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this._openIdConnect.isEnabled(this._portal.getCompanyId(httpServletRequest));
    }

    protected Log getLog() {
        return _log;
    }

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            return;
        }
        if (this._offlineOpenIdConnectSessionManager.isOpenIdConnectSession(httpSession)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"User is already authenticated");
            }
            return;
        }
        String actionURL = (String)httpSession.getAttribute("OPEN_ID_CONNECT_ACTION_URL");
        try {
            this._openIdConnectAuthenticationHandler.processAuthenticationResponse(httpServletRequest, httpServletResponse, userId -> this._autoLoginUser(httpServletRequest, httpServletResponse, (Long)userId));
        }
        catch (UserEmailAddressException.MustNotUseCompanyMx | StrangersNotAllowedException exception) {
            Class<?> clazz = exception.getClass();
            actionURL = HttpComponentsUtil.addParameter((String)actionURL, (String)"error", (String)clazz.getSimpleName());
            httpServletResponse.sendRedirect(actionURL);
        }
        catch (Exception exception) {
            this._portal.sendError(exception, httpServletRequest, httpServletResponse);
        }
        if (httpServletResponse.isCommitted()) {
            return;
        }
        if (actionURL != null) {
            httpServletResponse.sendRedirect(actionURL);
            return;
        }
        this.processFilter(OpenIdConnectAutoLoginFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
    }

    private void _autoLoginUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Long userId) throws Exception {
        HttpSession httpSession = httpServletRequest.getSession();
        httpSession.setAttribute("OPEN_ID_CONNECT_AUTHENTICATING_USER_ID", (Object)userId);
        super.processFilter(httpServletRequest, httpServletResponse, (servletRequest, servletResponse) -> {
            long authenticatedUserId = this._getRemoteUserId(servletRequest);
            if (authenticatedUserId == userId) {
                return;
            }
            throw new ServletException("Expected user " + userId + " to be authenticated");
        });
    }

    private long _getRemoteUserId(ServletRequest servletRequest) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        return GetterUtil.getLong((String)httpServletRequest.getRemoteUser());
    }
}

