/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal.servlet.filter;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BaseFilter;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnect;
import com.liferay.portal.security.sso.openid.connect.internal.session.manager.OfflineOpenIdConnectSessionManager;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"servlet-context-name=", "servlet-filter-name=OpenId Connect Session Validation Filter", "url-pattern=/*"}, service={Filter.class})
public class OpenIdConnectSessionValidationFilter
extends BaseFilter {
    private static final Log _log = LogFactoryUtil.getLog(OpenIdConnectSessionValidationFilter.class);
    @Reference
    private OfflineOpenIdConnectSessionManager _offlineOpenIdConnectSessionManager;
    @Reference
    private OpenIdConnect _openIdConnect;
    @Reference
    private Portal _portal;

    public boolean isFilterEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this._openIdConnect.isEnabled(this._portal.getCompanyId(httpServletRequest));
    }

    protected Log getLog() {
        return _log;
    }

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (this._offlineOpenIdConnectSessionManager.isOpenIdConnectSession(httpSession) && this._offlineOpenIdConnectSessionManager.isOpenIdConnectSessionExpired(httpSession)) {
            httpSession.invalidate();
            httpServletResponse.sendRedirect(this._portal.getHomeURL(httpServletRequest));
            return;
        }
        this.processFilter(OpenIdConnectSessionValidationFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
    }
}

