/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal.auto.login;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnect;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AutoLogin.class})
public class OpenIdConnectAutoLogin
extends BaseAutoLogin {
    @Reference
    private OpenIdConnect _openIdConnect;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    protected String[] doLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!this._openIdConnect.isEnabled(this._portal.getCompanyId(httpServletRequest))) {
            return null;
        }
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            return null;
        }
        Long userId = (Long)httpSession.getAttribute("OPEN_ID_CONNECT_AUTHENTICATING_USER_ID");
        if (userId != null) {
            httpSession.removeAttribute("OPEN_ID_CONNECT_AUTHENTICATING_USER_ID");
            User user = this._userLocalService.getUserById(userId.longValue());
            String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
            return credentials;
        }
        return null;
    }
}

