/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal.util;

import com.liferay.portal.vulcan.util.TransformUtil;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.net.URI;
import java.util.Collection;
import java.util.function.BiConsumer;
import net.minidev.json.JSONObject;

public class OpenIdConnectRequestParametersUtil {
    public static void consumeCustomRequestParameters(BiConsumer<String, String[]> biConsumer, JSONObject requestParametersJSONObject) throws ParseException {
        if (!requestParametersJSONObject.containsKey((Object)"custom_request_parameters")) {
            return;
        }
        JSONObject customRequestParametersJSONObject = JSONObjectUtils.getJSONObject((JSONObject)requestParametersJSONObject, (String)"custom_request_parameters");
        for (String key : customRequestParametersJSONObject.keySet()) {
            biConsumer.accept(key, JSONObjectUtils.getStringArray((JSONObject)customRequestParametersJSONObject, (String)key));
        }
    }

    public static URI[] getResourceURIs(JSONObject requestParametersJSONObject) throws ParseException {
        if (!requestParametersJSONObject.containsKey((Object)"resource")) {
            return new URI[0];
        }
        return (URI[])TransformUtil.transformToArray((Collection)JSONObjectUtils.getStringList((JSONObject)requestParametersJSONObject, (String)"resource"), resource -> URI.create(resource), URI.class);
    }

    public static ResponseType getResponseType(JSONObject requestParametersJSONObject) throws ParseException {
        return ResponseType.parse((String)JSONObjectUtils.getString((JSONObject)requestParametersJSONObject, (String)"response_type"));
    }

    public static Scope getScope(JSONObject requestParametersJSONObject) throws ParseException {
        return Scope.parse((String)JSONObjectUtils.getString((JSONObject)requestParametersJSONObject, (String)"scope"));
    }
}

