/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal.session.manager;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.oauth.client.persistence.model.OAuthClientEntry;
import com.liferay.oauth.client.persistence.service.OAuthClientEntryLocalService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.openid.connect.configuration.OpenIdConnectConfiguration;
import com.liferay.portal.security.sso.openid.connect.internal.AuthorizationServerMetadataResolver;
import com.liferay.portal.security.sso.openid.connect.internal.util.OpenIdConnectTokenRequestUtil;
import com.liferay.portal.security.sso.openid.connect.persistence.model.OpenIdConnectSession;
import com.liferay.portal.security.sso.openid.connect.persistence.service.OpenIdConnectSessionLocalService;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import net.minidev.json.JSONObject;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.sso.openid.connect.configuration.OpenIdConnectConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, service={OfflineOpenIdConnectSessionManager.class})
public class OfflineOpenIdConnectSessionManager {
    @Reference
    private AuthorizationServerMetadataResolver _authorizationServerMetadataResolver;
    @Reference
    private ClusterExecutor _clusterExecutor;
    @Reference
    private CounterLocalService _counterLocalService;
    @Reference
    private LockManager _lockManager;
    @Reference
    private OAuthClientEntryLocalService _oAuthClientEntryLocalService;
    private volatile OpenIdConnectMessageListener _openIdConnectMessageListener;
    @Reference
    private OpenIdConnectSessionLocalService _openIdConnectSessionLocalService;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    private volatile long _tokenRefreshOffsetMillis = 60000L;
    private volatile int _tokenRefreshScheduledInterval = 480;
    @Reference
    private TriggerFactory _triggerFactory;

    public boolean isOpenIdConnectSession(HttpSession httpSession) {
        if (httpSession == null) {
            return false;
        }
        Long openIdConnectSessionId = (Long)httpSession.getAttribute("OPEN_ID_CONNECT_SESSION_ID");
        return openIdConnectSessionId != null;
    }

    public boolean isOpenIdConnectSessionExpired(HttpSession httpSession) {
        Lock lock;
        Long openIdConnectSessionId = (Long)httpSession.getAttribute("OPEN_ID_CONNECT_SESSION_ID");
        if (openIdConnectSessionId == null) {
            return true;
        }
        OpenIdConnectSession openIdConnectSession = this._openIdConnectSessionLocalService.fetchOpenIdConnectSession(openIdConnectSessionId.longValue());
        if (openIdConnectSession == null) {
            return true;
        }
        Date accessTokenExpirationDate = openIdConnectSession.getAccessTokenExpirationDate();
        long currentTime = System.currentTimeMillis();
        if (currentTime <= accessTokenExpirationDate.getTime() - this._tokenRefreshOffsetMillis) {
            return false;
        }
        String key = String.valueOf(openIdConnectSessionId);
        String lockOwner = this._generateLockOwner();
        if (!lockOwner.equals((lock = this._lockManager.lock(OpenIdConnectSession.class.getSimpleName(), key, lockOwner)).getOwner())) {
            return false;
        }
        AccessToken accessToken = this._extendOpenIdConnectSession(openIdConnectSession);
        this._lockManager.unlock(OpenIdConnectSession.class.getSimpleName(), key, lockOwner);
        return accessToken == null;
    }

    public long startOpenIdConnectSession(String authServerWellKnownURI, String clientId, OIDCTokens oidcTokens, long userId) {
        OpenIdConnectSession openIdConnectSession = this._openIdConnectSessionLocalService.fetchOpenIdConnectSession(userId, authServerWellKnownURI, clientId);
        if (openIdConnectSession == null) {
            openIdConnectSession = this._openIdConnectSessionLocalService.createOpenIdConnectSession(this._counterLocalService.increment(OpenIdConnectSession.class.getName()));
        }
        this._updateOpenIdConnectSession(oidcTokens.getAccessToken(), authServerWellKnownURI, clientId, oidcTokens.getIDTokenString(), oidcTokens.getRefreshToken(), openIdConnectSession, userId);
        return openIdConnectSession.getOpenIdConnectSessionId();
    }

    @Modified
    protected void activate(Map<String, Object> properties) throws Exception {
        OpenIdConnectConfiguration openIdConnectConfiguration = (OpenIdConnectConfiguration)ConfigurableUtil.createConfigurable(OpenIdConnectConfiguration.class, properties);
        if (openIdConnectConfiguration.tokenRefreshOffset() < 30) {
            throw new IllegalArgumentException("Token refresh offset needs to be at least 30 seconds");
        }
        this._tokenRefreshOffsetMillis = (long)openIdConnectConfiguration.tokenRefreshOffset() * 1000L;
        this._tokenRefreshScheduledInterval = openIdConnectConfiguration.tokenRefreshScheduledInterval();
        if (!openIdConnectConfiguration.enabled() || this._tokenRefreshScheduledInterval < 30) {
            if (this._openIdConnectMessageListener != null) {
                this._schedulerEngineHelper.unregister((MessageListener)this._openIdConnectMessageListener);
                this._openIdConnectMessageListener = null;
            }
            return;
        }
        this._openIdConnectMessageListener = new OpenIdConnectMessageListener(this._lockManager);
        Trigger trigger = this._triggerFactory.createTrigger(OpenIdConnectMessageListener.class.getName(), "com.liferay.portal.security.sso.openid.connect", null, null, this._tokenRefreshScheduledInterval, TimeUnit.SECOND);
        SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl(OpenIdConnectMessageListener.class.getName(), trigger);
        this._schedulerEngineHelper.register((MessageListener)this._openIdConnectMessageListener, (SchedulerEntry)schedulerEntry, "liferay/scheduler_dispatch");
    }

    @Deactivate
    protected void deactivate() {
        if (this._openIdConnectMessageListener != null) {
            this._schedulerEngineHelper.unregister((MessageListener)this._openIdConnectMessageListener);
        }
    }

    private AccessToken _extendOpenIdConnectSession(OpenIdConnectSession openIdConnectSession) {
        if (Validator.isNull((String)openIdConnectSession.getRefreshToken())) {
            this._openIdConnectSessionLocalService.deleteOpenIdConnectSession(openIdConnectSession);
            return null;
        }
        RefreshToken refreshToken = new RefreshToken(openIdConnectSession.getRefreshToken());
        OAuthClientEntry oAuthClientEntry = this._oAuthClientEntryLocalService.fetchOAuthClientEntry(openIdConnectSession.getCompanyId(), openIdConnectSession.getAuthServerWellKnownURI(), openIdConnectSession.getClientId());
        if (oAuthClientEntry == null) {
            this._openIdConnectSessionLocalService.deleteOpenIdConnectSession(openIdConnectSession);
            return null;
        }
        try {
            OIDCTokens oidcTokens = OpenIdConnectTokenRequestUtil.request(OIDCClientInformation.parse((JSONObject)JSONObjectUtils.parse((String)oAuthClientEntry.getInfoJSON())), this._authorizationServerMetadataResolver.resolveOIDCProviderMetadata(openIdConnectSession.getAuthServerWellKnownURI()), refreshToken, oAuthClientEntry.getTokenRequestParametersJSON());
            this._updateOpenIdConnectSession(oidcTokens.getAccessToken(), openIdConnectSession, oidcTokens.getRefreshToken());
            return oidcTokens.getAccessToken();
        }
        catch (Exception exception) {
            this._openIdConnectSessionLocalService.deleteOpenIdConnectSession(openIdConnectSession);
            return null;
        }
    }

    private String _generateLockOwner() {
        ClusterNode clusterNode = this._clusterExecutor.getLocalClusterNode();
        Thread currentThread = Thread.currentThread();
        if (clusterNode != null) {
            return clusterNode.getClusterNodeId() + currentThread.getName();
        }
        return currentThread.getName();
    }

    private void _updateOpenIdConnectSession(AccessToken accessToken, OpenIdConnectSession openIdConnectSession, RefreshToken refreshToken) {
        openIdConnectSession.setAccessToken(accessToken.toJSONString());
        if (refreshToken != null) {
            openIdConnectSession.setRefreshToken(refreshToken.toString());
        }
        long currentTime = System.currentTimeMillis();
        openIdConnectSession.setModifiedDate(new Date(currentTime));
        if (accessToken.getLifetime() > 0L) {
            openIdConnectSession.setAccessTokenExpirationDate(new Date(currentTime + accessToken.getLifetime() * 1000L));
        } else {
            openIdConnectSession.setAccessTokenExpirationDate(new Date(currentTime + 3600000L));
        }
        this._openIdConnectSessionLocalService.updateOpenIdConnectSession(openIdConnectSession);
    }

    private void _updateOpenIdConnectSession(AccessToken accessToken, String authServerWellKnownURI, String clientId, String idTokenString, RefreshToken refreshToken, OpenIdConnectSession openIdConnectSession, long userId) {
        openIdConnectSession.setUserId(userId);
        openIdConnectSession.setAuthServerWellKnownURI(authServerWellKnownURI);
        openIdConnectSession.setClientId(clientId);
        openIdConnectSession.setIdToken(idTokenString);
        this._updateOpenIdConnectSession(accessToken, openIdConnectSession, refreshToken);
    }

    private class OpenIdConnectMessageListener
    extends BaseMessageListener {
        private final LockManager _lockManager;

        public OpenIdConnectMessageListener(LockManager lockManager) {
            this._lockManager = lockManager;
        }

        protected void doReceive(Message message) throws Exception {
            List openIdConnectSessions = OfflineOpenIdConnectSessionManager.this._openIdConnectSessionLocalService.getAccessTokenExpirationDateOpenIdConnectSessions(new Date(System.currentTimeMillis() + OfflineOpenIdConnectSessionManager.this._tokenRefreshOffsetMillis), -1, -1);
            for (OpenIdConnectSession openIdConnectSession : openIdConnectSessions) {
                Lock lock;
                String key = String.valueOf(openIdConnectSession.getOpenIdConnectSessionId());
                String lockOwner = OfflineOpenIdConnectSessionManager.this._generateLockOwner();
                if (!lockOwner.equals((lock = this._lockManager.lock(OpenIdConnectSession.class.getSimpleName(), key, lockOwner)).getOwner())) continue;
                OfflineOpenIdConnectSessionManager.this._extendOpenIdConnectSession(openIdConnectSession);
                this._lockManager.unlock(OpenIdConnectSession.class.getSimpleName(), key, lockOwner);
            }
        }
    }
}

