/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectServiceException;
import com.liferay.portal.security.sso.openid.connect.internal.OpenIdConnectUserInfoProcessor;
import com.liferay.portal.security.sso.openid.connect.internal.exception.StrangersNotAllowedException;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.util.Locale;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={OpenIdConnectUserInfoProcessor.class})
public class OpenIdConnectUserInfoProcessorImpl
implements OpenIdConnectUserInfoProcessor {
    private static final Log _log = LogFactoryUtil.getLog(OpenIdConnectUserInfoProcessorImpl.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private Props _props;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public long processUserInfo(UserInfo userInfo, long companyId, String issuer, String mainPath, String portalURL) throws PortalException {
        String emailAddress = userInfo.getEmailAddress();
        User user = this._userLocalService.fetchUserByEmailAddress(companyId, emailAddress);
        if (user != null) {
            return user.getUserId();
        }
        this._checkAddUser(companyId, emailAddress);
        String firstName = userInfo.getGivenName();
        String lastName = userInfo.getFamilyName();
        if (Validator.isNull((String)firstName) || Validator.isNull((String)lastName) || Validator.isNull((String)emailAddress)) {
            throw new OpenIdConnectServiceException.UserMappingException(StringBundler.concat((String[])new String[]{"Unable to map OpenId Connect user to the portal, missing ", "or invalid profile information: {emailAddresss=", emailAddress, ", firstName=", firstName, ", lastName=", lastName, "}"}));
        }
        long creatorUserId = 0L;
        boolean autoPassword = true;
        String password1 = null;
        String password2 = null;
        boolean autoScreenName = true;
        String screenName = "";
        Company company = this._companyLocalService.getCompany(companyId);
        Locale locale = company.getLocale();
        long prefixId = 0L;
        long suffixId = 0L;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = this._getRoleIds(companyId, issuer);
        long[] userGroupIds = null;
        boolean sendEmail = false;
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setPathMain(mainPath);
        serviceContext.setPortalURL(portalURL);
        user = this._userLocalService.addUser(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, locale, firstName, userInfo.getMiddleName(), lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
        user = this._userLocalService.updatePasswordReset(user.getUserId(), false);
        return user.getUserId();
    }

    private void _checkAddUser(long companyId, String emailAddress) throws PortalException {
        Company company = this._companyLocalService.getCompany(companyId);
        if (!company.isStrangers()) {
            throw new StrangersNotAllowedException(companyId);
        }
        if (!company.isStrangersWithMx() && company.hasCompanyMx(emailAddress)) {
            throw new UserEmailAddressException.MustNotUseCompanyMx(emailAddress);
        }
    }

    private long[] _getRoleIds(long companyId, String issuer) {
        if (Validator.isNull((String)issuer) || !Objects.equals(issuer, this._props.get("open.id.connect.user.info.processor.impl.issuer"))) {
            return null;
        }
        String roleName = this._props.get("open.id.connect.user.info.processor.impl.regular.role");
        if (Validator.isNull((String)roleName)) {
            return null;
        }
        Role role = this._roleLocalService.fetchRole(companyId, roleName);
        if (role == null) {
            return null;
        }
        if (role.getType() == 1) {
            return new long[]{role.getRoleId()};
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Role " + roleName + " is not a regular role"));
        }
        return null;
    }
}

