/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectFlowState;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectSession;
import com.liferay.portal.security.sso.openid.connect.persistence.service.OpenIdConnectSessionLocalServiceUtil;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.Nonce;
import java.io.Serializable;
import net.minidev.json.JSONObject;

public class OpenIdConnectSessionImpl
implements OpenIdConnectSession,
Serializable {
    private static final long _LOGIN_TIME = System.currentTimeMillis();
    private static final Log _log = LogFactoryUtil.getLog(OpenIdConnectSessionImpl.class);
    private final long _loginUserId;
    private final Nonce _nonce;
    private OpenIdConnectFlowState _openIdConnectFlowState = OpenIdConnectFlowState.PORTAL_AUTH_COMPLETE;
    private final long _openIdConnectSessionId;
    private final String _openIdProviderName;
    private final State _state;

    public OpenIdConnectSessionImpl(long openIdConnectSessionId, String openIdProviderName, Nonce nonce, State state, long userId) {
        this._openIdConnectSessionId = openIdConnectSessionId;
        this._openIdProviderName = openIdProviderName;
        this._nonce = nonce;
        this._state = state;
        this._loginUserId = userId;
    }

    public String getAccessTokenValue() {
        com.liferay.portal.security.sso.openid.connect.persistence.model.OpenIdConnectSession openIdConnectSession = OpenIdConnectSessionLocalServiceUtil.fetchOpenIdConnectSession((long)this._openIdConnectSessionId);
        if (openIdConnectSession == null) {
            return null;
        }
        try {
            AccessToken accessToken = AccessToken.parse((JSONObject)JSONObjectUtils.parse((String)openIdConnectSession.getAccessToken()));
            return accessToken.getValue();
        }
        catch (ParseException parseException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)parseException);
            }
            return null;
        }
    }

    public long getLoginTime() {
        return _LOGIN_TIME;
    }

    public long getLoginUserId() {
        return this._loginUserId;
    }

    public String getNonceValue() {
        return this._nonce.getValue();
    }

    public OpenIdConnectFlowState getOpenIdConnectFlowState() {
        return this._openIdConnectFlowState;
    }

    public String getOpenIdProviderName() {
        return this._openIdProviderName;
    }

    public String getRefreshTokenValue() {
        com.liferay.portal.security.sso.openid.connect.persistence.model.OpenIdConnectSession openIdConnectSession = OpenIdConnectSessionLocalServiceUtil.fetchOpenIdConnectSession((long)this._openIdConnectSessionId);
        if (openIdConnectSession == null) {
            return null;
        }
        return openIdConnectSession.getRefreshToken();
    }

    public String getStateValue() {
        return this._state.getValue();
    }

    public void setOpenIdConnectFlowState(OpenIdConnectFlowState openIdConnectFlowState) {
        this._openIdConnectFlowState = openIdConnectFlowState;
    }
}

