/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectServiceException;
import com.liferay.portal.security.sso.openid.connect.internal.OpenIdConnectMetadataFactory;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.time.StopWatch;

public class OpenIdConnectMetadataFactoryImpl
implements OpenIdConnectMetadataFactory {
    private static final Log _log = LogFactoryUtil.getLog(OpenIdConnectMetadataFactoryImpl.class);
    private final long _cacheInMilliseconds;
    private final URL _discoveryEndPointURL;
    private long _lastRefreshTimestamp;
    private OIDCClientMetadata _oidcClientMetadata;
    private OIDCProviderMetadata _oidcProviderMetadata;
    private final String _providerName;

    public OpenIdConnectMetadataFactoryImpl(String providerName, String[] idTokenSigningAlgValues, String issuerURL, String[] subjectTypes, String jwksURL, String authorizationEndPointURL, String tokenEndPointURL, String userInfoEndPointURL) throws OpenIdConnectServiceException.ProviderException {
        this._providerName = providerName;
        this._cacheInMilliseconds = 0L;
        this._discoveryEndPointURL = null;
        try {
            ArrayList<SubjectType> subjectTypesList = new ArrayList<SubjectType>();
            for (String subjectType : subjectTypes) {
                subjectTypesList.add(SubjectType.parse((String)subjectType));
            }
            this._oidcProviderMetadata = new OIDCProviderMetadata(new Issuer(issuerURL), subjectTypesList, new URI(jwksURL));
            this._oidcProviderMetadata.setAuthorizationEndpointURI(new URI(authorizationEndPointURL));
            ArrayList<JWSAlgorithm> jwsAlgorithms = new ArrayList<JWSAlgorithm>();
            for (String idTokenSigningAlgValue : idTokenSigningAlgValues) {
                jwsAlgorithms.add(JWSAlgorithm.parse((String)idTokenSigningAlgValue));
            }
            this._oidcProviderMetadata.setIDTokenJWSAlgs(jwsAlgorithms);
            this._oidcProviderMetadata.setTokenEndpointURI(new URI(tokenEndPointURL));
            this._oidcProviderMetadata.setUserInfoEndpointURI(new URI(userInfoEndPointURL));
            this.refreshClientMetadata(this._oidcProviderMetadata);
        }
        catch (ParseException pe) {
            throw new OpenIdConnectServiceException.ProviderException("Invalid subject types for OpenId Connect provider " + this._providerName, (Throwable)pe);
        }
        catch (URISyntaxException urise) {
            throw new OpenIdConnectServiceException.ProviderException("Invalid URLs for OpenId Connect provider " + this._providerName, (Throwable)urise);
        }
    }

    public OpenIdConnectMetadataFactoryImpl(String providerName, URL discoveryEndPointURL) {
        this(providerName, discoveryEndPointURL, 0L);
    }

    public OpenIdConnectMetadataFactoryImpl(String providerName, URL discoveryEndPointURL, long cacheInMilliseconds) {
        this._providerName = providerName;
        this._discoveryEndPointURL = discoveryEndPointURL;
        this._cacheInMilliseconds = cacheInMilliseconds;
    }

    @Override
    public OIDCClientMetadata getOIDCClientMetadata() {
        return this._oidcClientMetadata;
    }

    @Override
    public OIDCProviderMetadata getOIDCProviderMetadata() throws OpenIdConnectServiceException.ProviderException {
        long currentTime = System.currentTimeMillis();
        if (this.needsRefresh(currentTime)) {
            this.refresh(currentTime);
        }
        return this._oidcProviderMetadata;
    }

    protected boolean needsRefresh(long time) {
        if (this._oidcProviderMetadata == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Refreshing new OpenId Connect provider " + this._providerName));
            }
            return true;
        }
        long elapsedTime = time - this._lastRefreshTimestamp;
        if (this._cacheInMilliseconds > 0L && elapsedTime > this._cacheInMilliseconds) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Refreshing stale OpenId Connect provider " + this._providerName));
            }
            return true;
        }
        return false;
    }

    protected synchronized void refresh(long time) throws OpenIdConnectServiceException.ProviderException {
        if (this.needsRefresh(time)) {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            try {
                HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.GET, this._discoveryEndPointURL);
                HTTPResponse httpResponse = httpRequest.send();
                JSONObject jsonObject = httpResponse.getContentAsJSONObject();
                this._oidcProviderMetadata = OIDCProviderMetadata.parse((JSONObject)jsonObject);
                this.refreshClientMetadata(this._oidcProviderMetadata);
                this._lastRefreshTimestamp = time;
            }
            catch (ParseException | IOException e) {
                try {
                    throw new OpenIdConnectServiceException.ProviderException("Unable to get OpenId Connect provider metadata for " + this._providerName, e);
                }
                catch (Throwable throwable) {
                    stopWatch.stop();
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)StringBundler.concat((Object[])new Object[]{"Getting OpenId Connect provider metadata from ", this._discoveryEndPointURL, " took ", stopWatch.getTime(), "ms"}));
                    }
                    throw throwable;
                }
            }
            stopWatch.stop();
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Getting OpenId Connect provider metadata from ", this._discoveryEndPointURL, " took ", stopWatch.getTime(), "ms"}));
            }
        }
    }

    protected synchronized void refreshClientMetadata(OIDCProviderMetadata oidcProviderMetadata) {
        List jwsAlgorithms;
        this._oidcClientMetadata = new OIDCClientMetadata();
        List jweAlgorithms = oidcProviderMetadata.getIDTokenJWEAlgs();
        if (ListUtil.isNotEmpty((List)jweAlgorithms)) {
            this._oidcClientMetadata.setIDTokenJWEAlg((JWEAlgorithm)jweAlgorithms.get(0));
        }
        if (ListUtil.isNotEmpty((List)(jwsAlgorithms = oidcProviderMetadata.getIDTokenJWSAlgs()))) {
            this._oidcClientMetadata.setIDTokenJWSAlg((JWSAlgorithm)jwsAlgorithms.get(0));
        }
        this._oidcClientMetadata.setJWKSetURI(oidcProviderMetadata.getJWKSetURI());
    }
}

