/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal.service.filter;

import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BaseFilter;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnect;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectFlowState;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectServiceException;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectServiceHandler;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectSession;
import com.liferay.portal.security.sso.openid.connect.internal.exception.StrangersNotAllowedException;
import com.liferay.portal.security.sso.openid.connect.provider.OpenIdConnectSessionProvider;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.sso.openid.connect.configuration.OpenIdConnectConfiguration"}, immediate=true, property={"before-filter=Auto Login Filter", "servlet-context-name=", "servlet-filter-name=SSO OpenId Connect Filter", "url-pattern=/c/portal/login/openidconnect"}, service={Filter.class, OpenIdConnectFilter.class})
public class OpenIdConnectFilter
extends BaseFilter {
    private static final Log _log = LogFactoryUtil.getLog(OpenIdConnectFilter.class);
    @Reference
    private Http _http;
    @Reference
    private OpenIdConnect _openIdConnect;
    @Reference
    private OpenIdConnectServiceHandler _openIdConnectServiceHandler;
    @Reference
    private OpenIdConnectSessionProvider _openIdConnectSessionProvider;
    @Reference
    private Portal _portal;

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        long companyId = this._portal.getCompanyId(request);
        return this._openIdConnect.isEnabled(companyId);
    }

    protected Log getLog() {
        return _log;
    }

    protected void processAuthenticationResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            return;
        }
        try {
            OpenIdConnectSession openIdConnectSession = this._openIdConnectSessionProvider.getOpenIdConnectSession(httpSession);
            if (openIdConnectSession == null) {
                return;
            }
            OpenIdConnectFlowState openIdConnectFlowState = openIdConnectSession.getOpenIdConnectFlowState();
            if (OpenIdConnectFlowState.INITIALIZED.equals((Object)openIdConnectFlowState)) {
                throw new OpenIdConnectServiceException.AuthenticationException("OpenId Connect authentication flow not started");
            }
            if (OpenIdConnectFlowState.AUTH_COMPLETE.equals((Object)openIdConnectFlowState) || OpenIdConnectFlowState.PORTAL_AUTH_COMPLETE.equals((Object)openIdConnectFlowState)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"User has already been logged in");
                }
            } else {
                this._openIdConnectServiceHandler.processAuthenticationResponse(httpServletRequest, httpServletResponse);
                String actionURL = (String)httpSession.getAttribute("OPEN_ID_CONNECT_ACTION_URL");
                if (actionURL != null) {
                    httpServletResponse.sendRedirect(actionURL);
                }
            }
        }
        catch (UserEmailAddressException.MustNotUseCompanyMx | StrangersNotAllowedException e) {
            Class<?> clazz = e.getClass();
            httpSession.removeAttribute("OPEN_ID_CONNECT_SESSION");
            this.sendError(clazz.getSimpleName(), httpServletRequest, httpServletResponse);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to process OpenID Connect authentication response: " + e.getMessage()), (Throwable)e);
            httpSession.removeAttribute("OPEN_ID_CONNECT_SESSION");
            this._portal.sendError(e, httpServletRequest, httpServletResponse);
        }
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        this.processAuthenticationResponse(request, response);
        this.processFilter(OpenIdConnectFilter.class.getName(), request, response, filterChain);
    }

    protected void sendError(String error, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        String actionURL = (String)session.getAttribute("OPEN_ID_CONNECT_ACTION_URL");
        if (actionURL == null) {
            return;
        }
        actionURL = this._http.addParameter(actionURL, "error", error);
        response.sendRedirect(actionURL);
    }
}

