/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectFlowState;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectProvider;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectProviderRegistry;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectServiceException;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectServiceHandler;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectSession;
import com.liferay.portal.security.sso.openid.connect.internal.OpenIdConnectSessionImpl;
import com.liferay.portal.security.sso.openid.connect.internal.OpenIdConnectUserInfoProcessor;
import com.liferay.portal.security.sso.openid.connect.internal.provider.OpenIdConnectSessionProviderImpl;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.Header;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Date;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.minidev.json.JSONObject;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={OpenIdConnectServiceHandler.class})
public class OpenIdConnectServiceHandlerImpl
implements OpenIdConnectServiceHandler {
    private static final Log _log = LogFactoryUtil.getLog(OpenIdConnectServiceHandlerImpl.class);
    @Reference
    private OpenIdConnectProviderRegistry<OIDCClientMetadata, OIDCProviderMetadata> _openIdConnectProviderRegistry;
    @Reference
    private OpenIdConnectSessionProviderImpl _openIdConnectSessionProviderImpl;
    @Reference
    private OpenIdConnectUserInfoProcessor _openIdConnectUserInfoProcessor;
    @Reference
    private Portal _portal;

    public boolean hasValidOpenIdConnectSession(HttpSession httpSession) throws OpenIdConnectServiceException.NoOpenIdConnectSessionException {
        OpenIdConnectSessionImpl openIdConnectSessionImpl = this.getOpenIdConnectSessionImpl(httpSession);
        if (!this.hasValidAccessToken(openIdConnectSessionImpl)) {
            try {
                return this.refreshAuthToken(openIdConnectSessionImpl);
            }
            catch (OpenIdConnectServiceException openIdConnectServiceException) {
                _log.error((Object)("Unable to refresh auth token: " + openIdConnectServiceException.getMessage()), (Throwable)openIdConnectServiceException);
                return false;
            }
        }
        return true;
    }

    public void processAuthenticationResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        AuthenticationSuccessResponse authenticationSuccessResponse = this.getAuthenticationSuccessResponse(httpServletRequest);
        HttpSession httpSession = httpServletRequest.getSession();
        OpenIdConnectSessionImpl openIdConnectSessionImpl = this.getOpenIdConnectSessionImpl(httpSession);
        if (!OpenIdConnectFlowState.AUTH_REQUESTED.equals((Object)openIdConnectSessionImpl.getOpenIdConnectFlowState())) {
            throw new OpenIdConnectServiceException.AuthenticationException(StringBundler.concat((Object[])new Object[]{"OpenId Connect login flow is not in the ", OpenIdConnectFlowState.AUTH_REQUESTED, " state: ", openIdConnectSessionImpl.getOpenIdConnectFlowState()}));
        }
        this.validateState(openIdConnectSessionImpl.getState(), authenticationSuccessResponse.getState());
        OpenIdConnectProvider openIdConnectProvider = this._openIdConnectProviderRegistry.findOpenIdConnectProvider(openIdConnectSessionImpl.getOpenIdProviderName());
        OIDCProviderMetadata oidcProviderMetadata = (OIDCProviderMetadata)openIdConnectProvider.getOIDCProviderMetadata();
        OIDCClientInformation oidcClientInformation = this.getOIDCClientInformation((OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata>)openIdConnectProvider);
        URI redirectURI = this.getLoginRedirectURI(httpServletRequest);
        Tokens tokens = this.requestIdToken(authenticationSuccessResponse, oidcClientInformation, oidcProviderMetadata, redirectURI, openIdConnectSessionImpl.getNonce(), openIdConnectProvider.geTokenConnectionTimeout());
        this.updateSessionTokens(openIdConnectSessionImpl, tokens, System.currentTimeMillis());
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
        this.processUserInfo(this._portal.getCompanyId(httpServletRequest), openIdConnectSessionImpl, oidcProviderMetadata, serviceContext.getPathMain(), serviceContext.getPortalURL());
        openIdConnectSessionImpl.setOpenIdConnectFlowState(OpenIdConnectFlowState.AUTH_COMPLETE);
        OpenIdConnectSessionProviderImpl.setOpenIdConnectSession(httpSession, openIdConnectSessionImpl);
    }

    public void requestAuthentication(String openIdConnectProviderName, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        OpenIdConnectProvider openIdConnectProvider = this._openIdConnectProviderRegistry.findOpenIdConnectProvider(openIdConnectProviderName);
        HttpSession httpSession = httpServletRequest.getSession();
        OpenIdConnectSessionImpl openIdConnectSessionImpl = this.getOpenIdConnectSessionImpl(httpSession, openIdConnectProviderName);
        if (openIdConnectSessionImpl == null) {
            openIdConnectSessionImpl = new OpenIdConnectSessionImpl(openIdConnectProviderName, new Nonce(), new State());
        }
        URI authenticationRequestURI = this.getAuthenticationRequestURI(this.getLoginRedirectURI(httpServletRequest), (OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata>)openIdConnectProvider, openIdConnectSessionImpl.getNonce(), openIdConnectSessionImpl.getState(), Scope.parse((String)openIdConnectProvider.getScopes()));
        try {
            httpServletResponse.sendRedirect(authenticationRequestURI.toString());
            openIdConnectSessionImpl.setOpenIdConnectFlowState(OpenIdConnectFlowState.AUTH_REQUESTED);
            OpenIdConnectSessionProviderImpl.setOpenIdConnectSession(httpSession, openIdConnectSessionImpl);
        }
        catch (IOException ioException) {
            throw new SystemException(StringBundler.concat((String[])new String[]{"Unable to send user to OpenId Connect service ", authenticationRequestURI.toString(), ": ", ioException.getMessage()}), (Throwable)ioException);
        }
    }

    protected URI getAuthenticationRequestURI(URI loginRedirectURI, OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata> openIdConnectProvider, Nonce nonce, State state, Scope scope) throws OpenIdConnectServiceException.ProviderException {
        OIDCProviderMetadata oidcProviderMetadata = (OIDCProviderMetadata)openIdConnectProvider.getOIDCProviderMetadata();
        OIDCClientInformation oidcClientInformation = this.getOIDCClientInformation(openIdConnectProvider);
        ResponseType responseType = new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE});
        AuthenticationRequest authenticationRequest = new AuthenticationRequest(oidcProviderMetadata.getAuthorizationEndpointURI(), responseType, scope, oidcClientInformation.getID(), loginRedirectURI, state, nonce);
        return authenticationRequest.toURI();
    }

    protected AuthenticationSuccessResponse getAuthenticationSuccessResponse(HttpServletRequest httpServletRequest) throws OpenIdConnectServiceException.AuthenticationException {
        StringBuffer requestURL = httpServletRequest.getRequestURL();
        if (Validator.isNotNull((String)httpServletRequest.getQueryString())) {
            requestURL.append("?");
            requestURL.append(httpServletRequest.getQueryString());
        }
        try {
            URI requestURI = new URI(requestURL.toString());
            AuthenticationResponse authenticationResponse = AuthenticationResponseParser.parse((URI)requestURI);
            if (authenticationResponse instanceof AuthenticationErrorResponse) {
                AuthenticationErrorResponse authenticationErrorResponse = (AuthenticationErrorResponse)authenticationResponse;
                ErrorObject errorObject = authenticationErrorResponse.getErrorObject();
                JSONObject jsonObject = errorObject.toJSONObject();
                throw new OpenIdConnectServiceException.AuthenticationException(jsonObject.toString());
            }
            return (AuthenticationSuccessResponse)authenticationResponse;
        }
        catch (com.nimbusds.oauth2.sdk.ParseException | URISyntaxException exception) {
            throw new OpenIdConnectServiceException.AuthenticationException(StringBundler.concat((String[])new String[]{"Unable to process response from ", requestURL.toString(), ": ", exception.getMessage()}), exception);
        }
    }

    protected URI getLoginRedirectURI(HttpServletRequest httpServletRequest) {
        try {
            StringBundler sb = new StringBundler(3);
            sb.append(this._portal.getPortalURL(httpServletRequest));
            sb.append(this._portal.getPathContext());
            sb.append("/c/portal/login/openidconnect");
            return new URI(sb.toString());
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new SystemException("Unable to generate OpenId Connect login redirect URI: " + uriSyntaxException.getMessage(), (Throwable)uriSyntaxException);
        }
    }

    protected OIDCClientInformation getOIDCClientInformation(OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata> openIdConnectProvider) {
        ClientID clientID = new ClientID(openIdConnectProvider.getClientId());
        Secret secret = new Secret(openIdConnectProvider.getClientSecret());
        return new OIDCClientInformation(clientID, new Date(), (OIDCClientMetadata)openIdConnectProvider.getOIDCClientMetadata(), secret);
    }

    protected OpenIdConnectSessionImpl getOpenIdConnectSessionImpl(HttpSession httpSession) throws OpenIdConnectServiceException.NoOpenIdConnectSessionException {
        OpenIdConnectSessionImpl openIdConnectSessionImpl = this.getOpenIdConnectSessionImpl(httpSession, null);
        if (openIdConnectSessionImpl == null) {
            throw new OpenIdConnectServiceException.NoOpenIdConnectSessionException("HTTP session does contain an OpenId Connect session");
        }
        return openIdConnectSessionImpl;
    }

    protected OpenIdConnectSessionImpl getOpenIdConnectSessionImpl(HttpSession httpSession, String expectedProviderName) {
        OpenIdConnectSession openIdConnectSessionObject = this._openIdConnectSessionProviderImpl.getOpenIdConnectSession(httpSession);
        if (openIdConnectSessionObject instanceof OpenIdConnectSessionImpl) {
            OpenIdConnectSessionImpl openIdConnectSessionImpl = (OpenIdConnectSessionImpl)openIdConnectSessionObject;
            if (Validator.isNull((String)expectedProviderName) || expectedProviderName.equals(openIdConnectSessionImpl.getOpenIdProviderName())) {
                return openIdConnectSessionImpl;
            }
        }
        return null;
    }

    protected boolean hasValidAccessToken(OpenIdConnectSessionImpl openIdConnectSessionImpl) {
        AccessToken accessToken = openIdConnectSessionImpl.getAccessToken();
        if (accessToken == null) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        long lifetime = accessToken.getLifetime() * 1000L;
        long loginTime = openIdConnectSessionImpl.getLoginTime();
        return currentTime - loginTime < lifetime;
    }

    protected void processUserInfo(long companyId, OpenIdConnectSessionImpl openIdConnectSessionImpl, OIDCProviderMetadata oidcProviderMetadata, String mainPath, String portalURL) throws PortalException {
        UserInfo userInfo = this.requestUserInfo(openIdConnectSessionImpl.getAccessToken(), oidcProviderMetadata);
        long userId = this._openIdConnectUserInfoProcessor.processUserInfo(userInfo, companyId, mainPath, portalURL);
        openIdConnectSessionImpl.setLoginUserId(userId);
        openIdConnectSessionImpl.setUserInfoJSONObject(userInfo.toJSONObject());
    }

    protected boolean refreshAuthToken(OpenIdConnectSessionImpl openIdConnectSessionImpl) throws OpenIdConnectServiceException {
        RefreshToken refreshToken;
        if (this.hasValidAccessToken(openIdConnectSessionImpl)) {
            return true;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)"User session auth token is invalid, attempting to use refresh token to obtain a valid auth token");
        }
        if ((refreshToken = openIdConnectSessionImpl.getRefreshToken()) == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Unable to refresh auth token because no refresh token is supplied");
            }
            return false;
        }
        String openIdConnectProviderName = openIdConnectSessionImpl.getOpenIdProviderName();
        OpenIdConnectProvider openIdConnectProvider = this._openIdConnectProviderRegistry.findOpenIdConnectProvider(openIdConnectProviderName);
        OIDCProviderMetadata oidcProviderMetadata = (OIDCProviderMetadata)openIdConnectProvider.getOIDCProviderMetadata();
        Tokens tokens = this.requestRefreshToken(refreshToken, this.getOIDCClientInformation((OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata>)openIdConnectProvider), oidcProviderMetadata, openIdConnectSessionImpl.getNonce(), openIdConnectProvider.geTokenConnectionTimeout());
        this.updateSessionTokens(openIdConnectSessionImpl, tokens, System.currentTimeMillis());
        return true;
    }

    protected Tokens requestIdToken(AuthenticationSuccessResponse authenticationSuccessResponse, OIDCClientInformation oidcClientInformation, OIDCProviderMetadata oidcProviderMetadata, URI redirectURI, Nonce nonce, int tokenConnectionTimeout) throws OpenIdConnectServiceException.TokenException {
        AuthorizationCodeGrant authorizationCodeGrant = new AuthorizationCodeGrant(authenticationSuccessResponse.getAuthorizationCode(), redirectURI);
        return this.requestTokens(oidcClientInformation, oidcProviderMetadata, nonce, (AuthorizationGrant)authorizationCodeGrant, tokenConnectionTimeout);
    }

    protected Tokens requestRefreshToken(RefreshToken refreshToken, OIDCClientInformation oidcClientInformation, OIDCProviderMetadata oidcProviderMetadata, Nonce nonce, int tokenConnectionTimeout) throws OpenIdConnectServiceException {
        RefreshTokenGrant refreshTokenGrant = new RefreshTokenGrant(refreshToken);
        return this.requestTokens(oidcClientInformation, oidcProviderMetadata, nonce, (AuthorizationGrant)refreshTokenGrant, tokenConnectionTimeout);
    }

    protected Tokens requestTokens(OIDCClientInformation oidcClientInformation, OIDCProviderMetadata oidcProviderMetadata, Nonce nonce, AuthorizationGrant authorizationCodeGrant, int tokenConnectionTimeout) throws OpenIdConnectServiceException.TokenException {
        ClientSecretBasic clientAuthentication = new ClientSecretBasic(oidcClientInformation.getID(), oidcClientInformation.getSecret());
        URI tokenEndpoint = oidcProviderMetadata.getTokenEndpointURI();
        TokenRequest tokenRequest = new TokenRequest(tokenEndpoint, (ClientAuthentication)clientAuthentication, authorizationCodeGrant);
        HTTPRequest httpRequest = tokenRequest.toHTTPRequest();
        try {
            HTTPResponse httpResponse = httpRequest.send();
            TokenResponse tokenResponse = OIDCTokenResponseParser.parse((HTTPResponse)httpResponse);
            if (tokenResponse instanceof TokenErrorResponse) {
                TokenErrorResponse tokenErrorResponse = (TokenErrorResponse)tokenResponse;
                ErrorObject errorObject = tokenErrorResponse.getErrorObject();
                JSONObject jsonObject = errorObject.toJSONObject();
                throw new OpenIdConnectServiceException.TokenException(jsonObject.toString());
            }
            OIDCTokenResponse oidcTokenResponse = (OIDCTokenResponse)tokenResponse;
            this.validateToken(oidcClientInformation, nonce, oidcProviderMetadata, oidcTokenResponse, tokenConnectionTimeout);
            return oidcTokenResponse.getTokens();
        }
        catch (IOException ioException) {
            throw new OpenIdConnectServiceException.TokenException(StringBundler.concat((Object[])new Object[]{"Unable to get tokens from ", tokenEndpoint, ": ", ioException.getMessage()}), (Throwable)ioException);
        }
        catch (com.nimbusds.oauth2.sdk.ParseException parseException) {
            throw new OpenIdConnectServiceException.TokenException(StringBundler.concat((Object[])new Object[]{"Unable to parse tokens response from ", tokenEndpoint, ": ", parseException.getMessage()}), (Throwable)parseException);
        }
    }

    protected UserInfo requestUserInfo(AccessToken accessToken, OIDCProviderMetadata oidcProviderMetadata) throws OpenIdConnectServiceException.UserInfoException {
        UserInfoRequest userInfoRequest = new UserInfoRequest(oidcProviderMetadata.getUserInfoEndpointURI(), (BearerAccessToken)accessToken);
        HTTPRequest httpRequest = userInfoRequest.toHTTPRequest();
        httpRequest.setAccept("text/html, image/gif, image/jpeg, */*; q=0.2, */*; q=0.2");
        try {
            HTTPResponse httpResponse = httpRequest.send();
            UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)httpResponse);
            if (userInfoResponse instanceof UserInfoErrorResponse) {
                UserInfoErrorResponse userInfoErrorResponse = (UserInfoErrorResponse)userInfoResponse;
                ErrorObject errorObject = userInfoErrorResponse.getErrorObject();
                JSONObject jsonObject = errorObject.toJSONObject();
                throw new OpenIdConnectServiceException.UserInfoException(jsonObject.toString());
            }
            UserInfoSuccessResponse userInfoSuccessResponse = (UserInfoSuccessResponse)userInfoResponse;
            UserInfo userInfo = userInfoSuccessResponse.getUserInfo();
            if (userInfo != null) {
                return userInfo;
            }
            JWT userInfoJWT = userInfoSuccessResponse.getUserInfoJWT();
            return new UserInfo(userInfoJWT.getJWTClaimsSet());
        }
        catch (IOException ioException) {
            throw new OpenIdConnectServiceException.UserInfoException(StringBundler.concat((Object[])new Object[]{"Unable to get user information from ", oidcProviderMetadata.getUserInfoEndpointURI(), ": ", ioException.getMessage()}), (Throwable)ioException);
        }
        catch (com.nimbusds.oauth2.sdk.ParseException | ParseException exception) {
            throw new OpenIdConnectServiceException.UserInfoException(StringBundler.concat((Object[])new Object[]{"Unable to parse user information response from ", oidcProviderMetadata.getUserInfoEndpointURI(), ": ", exception.getMessage()}), exception);
        }
    }

    protected void updateSessionTokens(OpenIdConnectSessionImpl openIdConnectSessionImpl, Tokens tokens, long loginTime) {
        openIdConnectSessionImpl.setAccessToken(tokens.getAccessToken());
        openIdConnectSessionImpl.setRefreshToken(tokens.getRefreshToken());
        openIdConnectSessionImpl.setLoginTime(loginTime);
    }

    protected void validateState(State requestedState, State state) throws OpenIdConnectServiceException {
        if (!state.equals((Object)requestedState)) {
            throw new OpenIdConnectServiceException.AuthenticationException(StringBundler.concat((String[])new String[]{"Requested value \"", requestedState.getValue(), "\" and approved state \"", state.getValue(), "\" do not match"}));
        }
    }

    protected IDTokenClaimsSet validateToken(OIDCClientInformation oidcClientInformation, Nonce nonce, OIDCProviderMetadata oidcProviderMetadata, OIDCTokenResponse oidcTokenResponse, int tokenConnectionTimeout) throws OpenIdConnectServiceException.TokenException {
        try {
            OIDCTokens oidcTokens = oidcTokenResponse.getOIDCTokens();
            JWT idToken = oidcTokens.getIDToken();
            Header header = idToken.getHeader();
            Algorithm algorithm = header.getAlgorithm();
            URI uri = oidcProviderMetadata.getJWKSetURI();
            String name = algorithm.getName();
            ClientID clientID = oidcClientInformation.getID();
            for (JWSAlgorithm jwsAlgorithm : oidcProviderMetadata.getIDTokenJWSAlgs()) {
                if (!Objects.equals(jwsAlgorithm.getName(), name)) continue;
                IDTokenValidator idTokenValidator = new IDTokenValidator(oidcProviderMetadata.getIssuer(), clientID, JWSAlgorithm.parse((String)name), uri.toURL(), (ResourceRetriever)new DefaultResourceRetriever(tokenConnectionTimeout, tokenConnectionTimeout));
                return idTokenValidator.validate(idToken, nonce);
            }
            throw new OpenIdConnectServiceException.TokenException(StringBundler.concat((String[])new String[]{"Signing algorithm ", name, " rejected by OpenID Connect client: ", clientID.getValue()}));
        }
        catch (JOSEException | BadJOSEException exception) {
            throw new OpenIdConnectServiceException.TokenException("Unable to validate tokens: " + exception.getMessage(), exception);
        }
        catch (MalformedURLException malformedURLException) {
            throw new OpenIdConnectServiceException.TokenException("Invalid JSON web key URL: " + malformedURLException.getMessage(), (Throwable)malformedURLException);
        }
    }
}

