/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal.service.filter;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BaseFilter;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnect;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectServiceHandler;
import com.liferay.portal.security.sso.openid.connect.internal.OpenIdConnectFlowState;
import com.liferay.portal.security.sso.openid.connect.internal.OpenIdConnectSession;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"servlet-context-name=", "servlet-filter-name=OpenId Connect Session Validation Filter", "url-pattern=/*"}, service={Filter.class})
public class OpenIdConnectSessionValidationFilter
extends BaseFilter {
    private static final Log _log = LogFactoryUtil.getLog(OpenIdConnectSessionValidationFilter.class);
    @Reference
    private OpenIdConnect _openIdConnect;
    @Reference
    private OpenIdConnectServiceHandler _openIdConnectServiceHandler;
    @Reference
    private Portal _portal;

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        long companyId = this._portal.getCompanyId(request);
        return this._openIdConnect.isEnabled(companyId);
    }

    protected boolean checkEndSession(HttpSession httpSession) throws Exception {
        boolean endSession = false;
        OpenIdConnectSession openIdConnectSession = (OpenIdConnectSession)httpSession.getAttribute("OPEN_ID_CONNECT_SESSION");
        if (openIdConnectSession == null) {
            return endSession;
        }
        OpenIdConnectFlowState openIdConnectFlowState = openIdConnectSession.getOpenIdConnectFlowState();
        if (!OpenIdConnectFlowState.AUTH_COMPLETE.equals((Object)openIdConnectFlowState) && !OpenIdConnectFlowState.PORTAL_AUTH_COMPLETE.equals((Object)openIdConnectFlowState)) {
            return endSession;
        }
        try {
            if (!this._openIdConnectServiceHandler.hasValidOpenIdConnectSession(httpSession)) {
                endSession = true;
            }
        }
        catch (PortalException pe) {
            _log.error((Object)"Unable to validate OpenId session", (Throwable)pe);
            endSession = true;
        }
        return endSession;
    }

    protected Log getLog() {
        return _log;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null && this.checkEndSession(httpSession)) {
            httpSession.invalidate();
            response.sendRedirect(this._portal.getHomeURL(request));
            return;
        }
        this.processFilter(OpenIdConnectSessionValidationFilter.class.getName(), request, response, filterChain);
    }
}

