/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal.auto.login;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnect;
import com.liferay.portal.security.sso.openid.connect.internal.OpenIdConnectFlowState;
import com.liferay.portal.security.sso.openid.connect.internal.OpenIdConnectSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AutoLogin.class})
public class OpenIdConnectAutoLogin
extends BaseAutoLogin {
    @Reference
    private OpenIdConnect _openIdConnect;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    protected String[] doLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long companyId = this._portal.getCompanyId(request);
        if (!this._openIdConnect.isEnabled(companyId)) {
            return null;
        }
        HttpSession httpSession = request.getSession(false);
        if (httpSession == null) {
            return null;
        }
        OpenIdConnectSession openIdConnectSession = (OpenIdConnectSession)httpSession.getAttribute("OPEN_ID_CONNECT_SESSION");
        if (openIdConnectSession == null) {
            return null;
        }
        OpenIdConnectFlowState openIdConnectFlowState = openIdConnectSession.getOpenIdConnectFlowState();
        if (OpenIdConnectFlowState.AUTH_COMPLETE.equals((Object)openIdConnectFlowState)) {
            long userId = openIdConnectSession.getLoginUserId();
            User user = this._userLocalService.getUserById(userId);
            String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
            openIdConnectSession.setOpenIdConnectFlowState(OpenIdConnectFlowState.PORTAL_AUTH_COMPLETE);
            return credentials;
        }
        return null;
    }
}

