/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectServiceException;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectUserInfoProcessor;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.util.Locale;
import javax.mail.internet.InternetAddress;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={OpenIdConnectUserInfoProcessor.class})
public class OpenIdConnectUserInfoProcessorImpl
implements OpenIdConnectUserInfoProcessor {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public long processUserInfo(UserInfo userInfo, long companyId) throws PortalException {
        String password1;
        String firstName = userInfo.getGivenName();
        String lastName = userInfo.getFamilyName();
        InternetAddress internetAddress = userInfo.getEmail();
        String emailAddress = internetAddress.getAddress();
        User user = this._userLocalService.fetchUserByEmailAddress(companyId, emailAddress);
        if (user != null) {
            return user.getUserId();
        }
        if (Validator.isNull((String)firstName) || Validator.isNull((String)lastName) || Validator.isNull((String)emailAddress)) {
            StringBundler sb = new StringBundler(9);
            sb.append("Unable to map OpenId Connect user to the portal, ");
            sb.append("missing or invalid profile information: ");
            sb.append("{emailAddresss=");
            sb.append(emailAddress);
            sb.append(", firstName=");
            sb.append(firstName);
            sb.append(", lastName=");
            sb.append(lastName);
            sb.append("}");
            throw new OpenIdConnectServiceException.UserMappingException(sb.toString());
        }
        long creatorUserId = 0L;
        boolean autoPassword = false;
        String password2 = password1 = PwdGenerator.getPassword();
        boolean autoScreenName = true;
        String screenName = "";
        long facebookId = 0L;
        Company company = this._companyLocalService.getCompany(companyId);
        Locale locale = company.getLocale();
        String middleName = userInfo.getMiddleName();
        long prefixId = 0L;
        long suffixId = 0L;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = false;
        ServiceContext serviceContext = new ServiceContext();
        user = this._userLocalService.addUser(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, null, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
        user = this._userLocalService.updatePasswordReset(user.getUserId(), false);
        return user.getUserId();
    }
}

