/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectProvider;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectProviderRegistry;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectServiceException;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectServiceHandler;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectUserInfoProcessor;
import com.liferay.portal.security.sso.openid.connect.internal.OpenIdConnectFlowState;
import com.liferay.portal.security.sso.openid.connect.internal.OpenIdConnectSession;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={OpenIdConnectServiceHandler.class})
public class OpenIdConnectServiceHandlerImpl
implements OpenIdConnectServiceHandler {
    private static final Log _log = LogFactoryUtil.getLog(OpenIdConnectServiceHandlerImpl.class);
    @Reference
    private OpenIdConnectProviderRegistry _openIdConnectProviderRegistry;
    @Reference
    private OpenIdConnectUserInfoProcessor _openIdConnectUserInfoProcessor;
    @Reference
    private Portal _portal;

    public boolean hasValidOpenIdConnectSession(HttpSession httpSession) throws OpenIdConnectServiceException.NoOpenIdConnectSessionException {
        OpenIdConnectSession openIdConnectSession = this.getOpenIdConnectSession(httpSession);
        if (!this.hasValidAccessToken(openIdConnectSession)) {
            try {
                return this.refreshAuthToken(openIdConnectSession);
            }
            catch (OpenIdConnectServiceException oicse) {
                _log.error((Object)oicse, (Throwable)oicse);
                return false;
            }
        }
        return true;
    }

    public void processAuthenticationResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        AuthenticationSuccessResponse authenticationSuccessResponse = this.getAuthenticationSuccessResponse(httpServletRequest);
        HttpSession httpSession = httpServletRequest.getSession();
        OpenIdConnectSession openIdConnectSession = this.getOpenIdConnectSession(httpSession);
        if (!OpenIdConnectFlowState.AUTH_REQUESTED.equals((Object)openIdConnectSession.getOpenIdConnectFlowState())) {
            throw new OpenIdConnectServiceException.AuthenticationException(StringBundler.concat((String[])new String[]{"OpenId Connect login flow is not in the ", String.valueOf((Object)OpenIdConnectFlowState.AUTH_REQUESTED), " state: ", String.valueOf((Object)openIdConnectSession.getOpenIdConnectFlowState())}));
        }
        this.validateState(openIdConnectSession.getState(), authenticationSuccessResponse.getState());
        OpenIdConnectProvider openIdConnectProvider = this._openIdConnectProviderRegistry.findOpenIdConnectProvider(openIdConnectSession.getOpenIdProviderName());
        OIDCProviderMetadata oidcProviderMetadata = openIdConnectProvider.getOIDCProviderMetadata();
        OIDCClientInformation oidcClientInformation = this.getOIDCClientInformation(openIdConnectProvider);
        URI redirectURI = this.getLoginRedirectURI(httpServletRequest);
        Tokens tokens = this.requestIdToken(authenticationSuccessResponse, oidcClientInformation, oidcProviderMetadata, redirectURI, openIdConnectSession.getNonce());
        this.updateSessionTokens(openIdConnectSession, tokens, System.currentTimeMillis());
        long companyId = this._portal.getCompanyId(httpServletRequest);
        this.processUserInfo(companyId, openIdConnectSession, oidcProviderMetadata);
        openIdConnectSession.setOpenIdConnectFlowState(OpenIdConnectFlowState.AUTH_COMPLETE);
    }

    public void requestAuthentication(String openIdConnectProviderName, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        OpenIdConnectProvider openIdConnectProvider = this._openIdConnectProviderRegistry.findOpenIdConnectProvider(openIdConnectProviderName);
        State state = new State();
        Nonce nonce = new Nonce();
        OpenIdConnectSession openIdConnectSession = new OpenIdConnectSession(openIdConnectProviderName, nonce, state);
        Scope scope = Scope.parse((String)openIdConnectProvider.getScopes());
        URI loginRedirectURI = this.getLoginRedirectURI(httpServletRequest);
        URI authenticationRequestURI = this.getAuthenticationRequestURI(loginRedirectURI, openIdConnectProvider, state, nonce, scope);
        HttpSession httpSession = httpServletRequest.getSession();
        httpSession.setAttribute("OPEN_ID_CONNECT_SESSION", (Object)openIdConnectSession);
        try {
            httpServletResponse.sendRedirect(authenticationRequestURI.toString());
            openIdConnectSession.setOpenIdConnectFlowState(OpenIdConnectFlowState.AUTH_REQUESTED);
        }
        catch (IOException ioe) {
            throw new SystemException("Unable to send user to OpenId Connect service", (Throwable)ioe);
        }
    }

    protected URI getAuthenticationRequestURI(URI loginRedirectURI, OpenIdConnectProvider openIdConnectProvider, State state, Nonce nonce, Scope scope) throws OpenIdConnectServiceException.ProviderException {
        OIDCProviderMetadata oidcProviderMetadata = openIdConnectProvider.getOIDCProviderMetadata();
        OIDCClientInformation oidcClientInformation = this.getOIDCClientInformation(openIdConnectProvider);
        ResponseType responseType = new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE});
        AuthenticationRequest authenticationRequest = new AuthenticationRequest(oidcProviderMetadata.getAuthorizationEndpointURI(), responseType, scope, oidcClientInformation.getID(), loginRedirectURI, state, nonce);
        return authenticationRequest.toURI();
    }

    protected AuthenticationSuccessResponse getAuthenticationSuccessResponse(HttpServletRequest httpServletRequest) throws OpenIdConnectServiceException.AuthenticationException {
        StringBuffer requestURL = httpServletRequest.getRequestURL();
        if (Validator.isNotNull((String)httpServletRequest.getQueryString())) {
            requestURL.append("?");
            requestURL.append(httpServletRequest.getQueryString());
        }
        try {
            URI requestURI = new URI(requestURL.toString());
            AuthenticationResponse authenticationResponse = AuthenticationResponseParser.parse((URI)requestURI);
            if (authenticationResponse instanceof AuthenticationErrorResponse) {
                AuthenticationErrorResponse authenticationErrorResponse = (AuthenticationErrorResponse)authenticationResponse;
                ErrorObject errorObject = authenticationErrorResponse.getErrorObject();
                throw new OpenIdConnectServiceException.AuthenticationException(errorObject.toString());
            }
            return (AuthenticationSuccessResponse)authenticationResponse;
        }
        catch (ParseException | URISyntaxException e) {
            throw new OpenIdConnectServiceException.AuthenticationException("Unable to process response string: " + requestURL.toString(), e);
        }
    }

    protected URI getLoginRedirectURI(HttpServletRequest httpServletRequest) {
        try {
            StringBundler sb = new StringBundler(2);
            sb.append(this._portal.getPortalURL(httpServletRequest));
            sb.append("/c/portal/login/openidconnect");
            return new URI(sb.toString());
        }
        catch (URISyntaxException urise) {
            throw new SystemException("Unable to generate OpenId Connect login redirect URI", (Throwable)urise);
        }
    }

    protected OIDCClientInformation getOIDCClientInformation(OpenIdConnectProvider openIdConnectProvider) {
        ClientID clientID = new ClientID(openIdConnectProvider.getClientId());
        Secret secret = new Secret(openIdConnectProvider.getClientSecret());
        return new OIDCClientInformation(clientID, new Date(), openIdConnectProvider.getOIDCClientMetadata(), secret);
    }

    protected OpenIdConnectSession getOpenIdConnectSession(HttpSession httpSession) throws OpenIdConnectServiceException.NoOpenIdConnectSessionException {
        OpenIdConnectSession openIdConnectSession = (OpenIdConnectSession)httpSession.getAttribute("OPEN_ID_CONNECT_SESSION");
        if (openIdConnectSession == null) {
            throw new OpenIdConnectServiceException.NoOpenIdConnectSessionException("HTTP session does contain an OpenId Connect session");
        }
        return openIdConnectSession;
    }

    protected boolean hasValidAccessToken(OpenIdConnectSession openIdConnectSession) {
        AccessToken accessToken = openIdConnectSession.getAccessToken();
        if (accessToken == null) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        long lifetime = accessToken.getLifetime() * 1000L;
        long loginTime = openIdConnectSession.getLoginTime();
        return currentTime - loginTime < lifetime;
    }

    protected void processUserInfo(long companyId, OpenIdConnectSession openIdConnectSession, OIDCProviderMetadata oidcProviderMetadata) throws PortalException {
        UserInfo userInfo = this.requestUserInfo(openIdConnectSession.getAccessToken(), oidcProviderMetadata);
        long userId = this._openIdConnectUserInfoProcessor.processUserInfo(userInfo, companyId);
        openIdConnectSession.setLoginUserId(userId);
        openIdConnectSession.setUserInfo(userInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean refreshAuthToken(OpenIdConnectSession openIdConnectSession) throws OpenIdConnectServiceException {
        OpenIdConnectSession openIdConnectSession2 = openIdConnectSession;
        synchronized (openIdConnectSession2) {
            RefreshToken refreshToken;
            if (this.hasValidAccessToken(openIdConnectSession)) {
                return true;
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)"User session auth token is invalid, attempting to use refresh token to obtain a valid auth token");
            }
            if ((refreshToken = openIdConnectSession.getRefreshToken()) == null) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Unable to refresh auth token because no refresh token is supplied");
                }
                return false;
            }
            String openIdConnectProviderName = openIdConnectSession.getOpenIdProviderName();
            OpenIdConnectProvider openIdConnectProvider = this._openIdConnectProviderRegistry.findOpenIdConnectProvider(openIdConnectProviderName);
            OIDCProviderMetadata oidcProviderMetadata = openIdConnectProvider.getOIDCProviderMetadata();
            OIDCClientInformation oidcClientInformation = this.getOIDCClientInformation(openIdConnectProvider);
            Tokens tokens = this.requestRefreshToken(refreshToken, oidcClientInformation, oidcProviderMetadata, openIdConnectSession.getNonce());
            this.updateSessionTokens(openIdConnectSession, tokens, System.currentTimeMillis());
            return true;
        }
    }

    protected Tokens requestIdToken(AuthenticationSuccessResponse authenticationSuccessResponse, OIDCClientInformation oidcClientInformation, OIDCProviderMetadata oidcProviderMetadata, URI redirectURI, Nonce nonce) throws OpenIdConnectServiceException.TokenException {
        AuthorizationCode authorizationCode = authenticationSuccessResponse.getAuthorizationCode();
        AuthorizationCodeGrant authorizationCodeGrant = new AuthorizationCodeGrant(authorizationCode, redirectURI);
        return this.requestTokens(oidcClientInformation, oidcProviderMetadata, nonce, (AuthorizationGrant)authorizationCodeGrant);
    }

    protected Tokens requestRefreshToken(RefreshToken refreshToken, OIDCClientInformation oidcClientInformation, OIDCProviderMetadata oidcProviderMetadata, Nonce nonce) throws OpenIdConnectServiceException {
        RefreshTokenGrant refreshTokenGrant = new RefreshTokenGrant(refreshToken);
        return this.requestTokens(oidcClientInformation, oidcProviderMetadata, nonce, (AuthorizationGrant)refreshTokenGrant);
    }

    protected Tokens requestTokens(OIDCClientInformation oidcClientInformation, OIDCProviderMetadata oidcProviderMetadata, Nonce nonce, AuthorizationGrant authorizationCodeGrant) throws OpenIdConnectServiceException.TokenException {
        ClientSecretBasic clientAuthentication = new ClientSecretBasic(oidcClientInformation.getID(), oidcClientInformation.getSecret());
        URI tokenEndpoint = oidcProviderMetadata.getTokenEndpointURI();
        TokenRequest tokenRequest = new TokenRequest(tokenEndpoint, (ClientAuthentication)clientAuthentication, authorizationCodeGrant);
        HTTPRequest httpRequest = tokenRequest.toHTTPRequest();
        try {
            HTTPResponse httpResponse = httpRequest.send();
            TokenResponse tokenResponse = OIDCTokenResponseParser.parse((HTTPResponse)httpResponse);
            if (tokenResponse instanceof TokenErrorResponse) {
                TokenErrorResponse tokenErrorResponse = (TokenErrorResponse)tokenResponse;
                ErrorObject errorObject = tokenErrorResponse.getErrorObject();
                throw new OpenIdConnectServiceException.TokenException(errorObject.toString());
            }
            OIDCTokenResponse oidcTokenResponse = (OIDCTokenResponse)tokenResponse;
            this.validateToken(oidcClientInformation, nonce, oidcProviderMetadata, oidcTokenResponse);
            return oidcTokenResponse.getTokens();
        }
        catch (IOException ioe) {
            throw new OpenIdConnectServiceException.TokenException("Unable to get tokens", (Throwable)ioe);
        }
        catch (ParseException pe) {
            throw new OpenIdConnectServiceException.TokenException("Unable to parse tokens response", (Throwable)pe);
        }
    }

    protected UserInfo requestUserInfo(AccessToken accessToken, OIDCProviderMetadata oidcProviderMetadata) throws OpenIdConnectServiceException.UserInfoException {
        UserInfoRequest userInfoRequest = new UserInfoRequest(oidcProviderMetadata.getUserInfoEndpointURI(), (BearerAccessToken)accessToken);
        HTTPRequest httpRequest = userInfoRequest.toHTTPRequest();
        try {
            HTTPResponse httpResponse = httpRequest.send();
            UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)httpResponse);
            if (userInfoResponse instanceof UserInfoErrorResponse) {
                UserInfoErrorResponse userInfoErrorResponse = (UserInfoErrorResponse)userInfoResponse;
                ErrorObject errorObject = userInfoErrorResponse.getErrorObject();
                throw new OpenIdConnectServiceException.UserInfoException(errorObject.toString());
            }
            UserInfoSuccessResponse userInfoSuccessResponse = (UserInfoSuccessResponse)userInfoResponse;
            return userInfoSuccessResponse.getUserInfo();
        }
        catch (IOException ioe) {
            throw new OpenIdConnectServiceException.UserInfoException("Unable to get user information", (Throwable)ioe);
        }
        catch (ParseException pe) {
            throw new OpenIdConnectServiceException.UserInfoException("Unable to parse user information response", (Throwable)pe);
        }
    }

    protected void updateSessionTokens(OpenIdConnectSession session, Tokens tokens, long loginTime) {
        session.setAccessToken(tokens.getAccessToken());
        session.setRefreshToken(tokens.getRefreshToken());
        session.setLoginTime(loginTime);
    }

    protected void validateState(State requestedState, State state) throws OpenIdConnectServiceException {
        if (!state.equals((Object)requestedState)) {
            throw new OpenIdConnectServiceException.AuthenticationException(StringBundler.concat((String[])new String[]{"Requested value \"", requestedState.getValue(), "\" and approved state \"", state.getValue(), "\" do not match"}));
        }
    }

    protected IDTokenClaimsSet validateToken(OIDCClientInformation oidcClientInformation, Nonce nonce, OIDCProviderMetadata oidcProviderMetadata, OIDCTokenResponse oidcTokenResponse) throws OpenIdConnectServiceException.TokenException {
        try {
            IDTokenValidator idTokenValidator = IDTokenValidator.create((OIDCProviderMetadata)oidcProviderMetadata, (OIDCClientInformation)oidcClientInformation, null);
            OIDCTokens oidcTokens = oidcTokenResponse.getOIDCTokens();
            return idTokenValidator.validate(oidcTokens.getIDToken(), nonce);
        }
        catch (GeneralException ge) {
            throw new OpenIdConnectServiceException.TokenException("Unable to instantiate token validator", (Throwable)ge);
        }
        catch (JOSEException | BadJOSEException e) {
            throw new OpenIdConnectServiceException.TokenException("Unable to validate tokens", e);
        }
    }
}

