/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectMetadataFactory;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectProvider;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectProviderRegistry;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectServiceException;
import com.liferay.portal.security.sso.openid.connect.internal.OpenIdConnectMetadataFactoryImpl;
import com.liferay.portal.security.sso.openid.connect.internal.configuration.OpenIdConnectProviderConfiguration;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"service.pid=com.liferay.portal.security.sso.openid.connect.internal.configuration.OpenIdConnectProviderConfiguration"}, service={ManagedServiceFactory.class, OpenIdConnectProviderRegistry.class})
public class OpenIdConnectProviderRegistryImpl
implements OpenIdConnectProviderRegistry,
ManagedServiceFactory {
    private final Map<String, OpenIdConnectProvider> _openIdConnectProvidersPerFactory = new ConcurrentHashMap<String, OpenIdConnectProvider>();
    private final Map<String, OpenIdConnectProvider> _openIdConnectProvidersPerName = new ConcurrentHashMap<String, OpenIdConnectProvider>();

    public void deleted(String factoryPid) {
        this.removeOpenConnectIdProvider(factoryPid);
    }

    public OpenIdConnectProvider findOpenIdConnectProvider(String name) throws OpenIdConnectServiceException.ProviderException {
        OpenIdConnectProvider openIdConnectProvider = this.getOpenIdConnectProvider(name);
        if (openIdConnectProvider == null) {
            throw new OpenIdConnectServiceException.ProviderException("Unable to get OpenId Connect provider with name " + name);
        }
        return openIdConnectProvider;
    }

    public String getName() {
        return "OpenId Connect Provider Factory";
    }

    public OpenIdConnectProvider getOpenIdConnectProvider(String name) {
        return this._openIdConnectProvidersPerName.get(name);
    }

    public Collection<String> getOpenIdConnectProviderNames() {
        if (this._openIdConnectProvidersPerName.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(this._openIdConnectProvidersPerName.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String factoryPid, Dictionary<String, ?> properties) throws ConfigurationException {
        OpenIdConnectProviderConfiguration openIdConnectProviderConfiguration = (OpenIdConnectProviderConfiguration)ConfigurableUtil.createConfigurable(OpenIdConnectProviderConfiguration.class, properties);
        Map<String, OpenIdConnectProvider> map = this._openIdConnectProvidersPerFactory;
        synchronized (map) {
            OpenIdConnectProvider openIdConnectProvider = this.createOpenIdConnectProvider(openIdConnectProviderConfiguration);
            this.removeOpenConnectIdProvider(factoryPid);
            this.addOpenConnectIdConnectProvider(factoryPid, openIdConnectProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addOpenConnectIdConnectProvider(String factoryPid, OpenIdConnectProvider openIdConnectProvider) {
        Map<String, OpenIdConnectProvider> map = this._openIdConnectProvidersPerFactory;
        synchronized (map) {
            this._openIdConnectProvidersPerFactory.put(factoryPid, openIdConnectProvider);
            this._openIdConnectProvidersPerName.put(openIdConnectProvider.getName(), openIdConnectProvider);
        }
    }

    protected OpenIdConnectProvider createOpenIdConnectProvider(OpenIdConnectProviderConfiguration openIdConnectProviderConfiguration) throws ConfigurationException {
        OpenIdConnectMetadataFactoryImpl openIdConnectMetadataFactory = null;
        try {
            openIdConnectMetadataFactory = Validator.isNotNull((String)openIdConnectProviderConfiguration.discoveryEndPoint()) ? new OpenIdConnectMetadataFactoryImpl(openIdConnectProviderConfiguration.providerName(), new URL(openIdConnectProviderConfiguration.discoveryEndPoint()), openIdConnectProviderConfiguration.discoveryEndPointCacheInMillis()) : new OpenIdConnectMetadataFactoryImpl(openIdConnectProviderConfiguration.providerName(), openIdConnectProviderConfiguration.issuerURL(), openIdConnectProviderConfiguration.subjectTypes(), openIdConnectProviderConfiguration.jwksURI(), openIdConnectProviderConfiguration.authorizationEndPoint(), openIdConnectProviderConfiguration.tokenEndPoint(), openIdConnectProviderConfiguration.userInfoEndPoint());
        }
        catch (Exception e) {
            throw new ConfigurationException(null, "Unable to instantiate provider metadata factory for " + openIdConnectProviderConfiguration.providerName(), (Throwable)e);
        }
        OpenIdConnectProvider openIdConnectProvider = new OpenIdConnectProvider(openIdConnectProviderConfiguration.providerName(), openIdConnectProviderConfiguration.openIdConnectClientId(), openIdConnectProviderConfiguration.openIdConnectClientSecret(), openIdConnectProviderConfiguration.scopes(), (OpenIdConnectMetadataFactory)openIdConnectMetadataFactory);
        return openIdConnectProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeOpenConnectIdProvider(String factoryPid) {
        Map<String, OpenIdConnectProvider> map = this._openIdConnectProvidersPerFactory;
        synchronized (map) {
            OpenIdConnectProvider openIdConnectProvider = this._openIdConnectProvidersPerFactory.remove(factoryPid);
            if (openIdConnectProvider != null) {
                this._openIdConnectProvidersPerName.remove(openIdConnectProvider.getName());
            }
        }
    }
}

