/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.connect.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectProvider;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectProviderRegistry;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectServiceException;
import com.liferay.portal.security.sso.openid.connect.internal.OpenIdConnectMetadataFactoryImpl;
import com.liferay.portal.security.sso.openid.connect.internal.OpenIdConnectProviderImpl;
import com.liferay.portal.security.sso.openid.connect.internal.configuration.OpenIdConnectProviderConfiguration;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"service.pid=com.liferay.portal.security.sso.openid.connect.internal.configuration.OpenIdConnectProviderConfiguration"}, service={ManagedServiceFactory.class, OpenIdConnectProviderRegistry.class})
public class OpenIdConnectProviderRegistryImpl
implements ManagedServiceFactory,
OpenIdConnectProviderRegistry<OIDCClientMetadata, OIDCProviderMetadata> {
    private final Map<String, OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata>> _openIdConnectProvidersPerFactory = new ConcurrentHashMap<String, OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata>>();
    private final Map<String, OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata>> _openIdConnectProvidersPerName = new ConcurrentHashMap<String, OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata>>();

    public void deleted(String factoryPid) {
        this.removeOpenConnectIdProvider(factoryPid);
    }

    public OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata> findOpenIdConnectProvider(String name) throws OpenIdConnectServiceException.ProviderException {
        OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata> openIdConnectProvider = this.getOpenIdConnectProvider(name);
        if (openIdConnectProvider == null) {
            throw new OpenIdConnectServiceException.ProviderException("Unable to get OpenId Connect provider with name " + name);
        }
        return openIdConnectProvider;
    }

    public String getName() {
        return "OpenId Connect Provider Factory";
    }

    public OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata> getOpenIdConnectProvider(String name) {
        return this._openIdConnectProvidersPerName.get(name);
    }

    public Collection<String> getOpenIdConnectProviderNames() {
        if (this._openIdConnectProvidersPerName.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(this._openIdConnectProvidersPerName.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String factoryPid, Dictionary<String, ?> properties) throws ConfigurationException {
        OpenIdConnectProviderConfiguration openIdConnectProviderConfiguration = (OpenIdConnectProviderConfiguration)ConfigurableUtil.createConfigurable(OpenIdConnectProviderConfiguration.class, properties);
        Map<String, OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata>> map = this._openIdConnectProvidersPerFactory;
        synchronized (map) {
            OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata> openIdConnectProvider = this.createOpenIdConnectProvider(openIdConnectProviderConfiguration);
            this.removeOpenConnectIdProvider(factoryPid);
            this.addOpenConnectIdConnectProvider(factoryPid, openIdConnectProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addOpenConnectIdConnectProvider(String factoryPid, OpenIdConnectProvider openIdConnectProvider) {
        Map<String, OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata>> map = this._openIdConnectProvidersPerFactory;
        synchronized (map) {
            this._openIdConnectProvidersPerFactory.put(factoryPid, (OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata>)openIdConnectProvider);
            this._openIdConnectProvidersPerName.put(openIdConnectProvider.getName(), (OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata>)openIdConnectProvider);
        }
    }

    protected OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata> createOpenIdConnectProvider(OpenIdConnectProviderConfiguration openIdConnectProviderConfiguration) throws ConfigurationException {
        OpenIdConnectMetadataFactoryImpl openIdConnectMetadataFactory = null;
        try {
            openIdConnectMetadataFactory = Validator.isNotNull((String)openIdConnectProviderConfiguration.discoveryEndPoint()) ? new OpenIdConnectMetadataFactoryImpl(openIdConnectProviderConfiguration.providerName(), new URL(openIdConnectProviderConfiguration.discoveryEndPoint()), openIdConnectProviderConfiguration.discoveryEndPointCacheInMillis()) : new OpenIdConnectMetadataFactoryImpl(openIdConnectProviderConfiguration.providerName(), openIdConnectProviderConfiguration.issuerURL(), openIdConnectProviderConfiguration.subjectTypes(), openIdConnectProviderConfiguration.jwksURI(), openIdConnectProviderConfiguration.authorizationEndPoint(), openIdConnectProviderConfiguration.tokenEndPoint(), openIdConnectProviderConfiguration.userInfoEndPoint());
        }
        catch (Exception e) {
            throw new ConfigurationException(null, "Unable to instantiate provider metadata factory for " + openIdConnectProviderConfiguration.providerName(), (Throwable)e);
        }
        OpenIdConnectProviderImpl openIdConnectProvider = new OpenIdConnectProviderImpl(openIdConnectProviderConfiguration.providerName(), openIdConnectProviderConfiguration.openIdConnectClientId(), openIdConnectProviderConfiguration.openIdConnectClientSecret(), openIdConnectProviderConfiguration.scopes(), openIdConnectMetadataFactory);
        return openIdConnectProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeOpenConnectIdProvider(String factoryPid) {
        Map<String, OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata>> map = this._openIdConnectProvidersPerFactory;
        synchronized (map) {
            OpenIdConnectProvider<OIDCClientMetadata, OIDCProviderMetadata> openIdConnectProvider = this._openIdConnectProvidersPerFactory.remove(factoryPid);
            if (openIdConnectProvider != null) {
                this._openIdConnectProvidersPerName.remove(openIdConnectProvider.getName());
            }
        }
    }
}

