/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.google.settings.authentication.web.internal.portlet.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.settings.portlet.action.PortalSettingsFormContributor;
import com.liferay.portal.settings.portlet.action.PortalSettingsParameterUtil;
import java.util.Optional;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={PortalSettingsFormContributor.class})
public class GooglePortalSettingsFormContributor
implements PortalSettingsFormContributor {
    public Optional<String> getDeleteMVCActionCommandNameOptional() {
        return Optional.of("/portal_settings/google_delete");
    }

    public String getParameterNamespace() {
        return "google_";
    }

    public Optional<String> getSaveMVCActionCommandNameOptional() {
        return Optional.of("/portal_settings/google");
    }

    public String getSettingsId() {
        return "com.liferay.portal.security.sso.google.authorization";
    }

    public void validateForm(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException {
        boolean googleEnabled = PortalSettingsParameterUtil.getBoolean((ActionRequest)actionRequest, (PortalSettingsFormContributor)this, (String)"enabled");
        if (!googleEnabled) {
            return;
        }
        String googleClientId = PortalSettingsParameterUtil.getString((ActionRequest)actionRequest, (PortalSettingsFormContributor)this, (String)"clientId");
        String googleClientSecret = PortalSettingsParameterUtil.getString((ActionRequest)actionRequest, (PortalSettingsFormContributor)this, (String)"clientSecret");
        if (Validator.isNull((String)googleClientId)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"googleClientIdInvalid");
        }
        if (Validator.isNull((String)googleClientSecret)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"googleClientSecretInvalid");
        }
    }
}

