/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.google.internal.instance.lifecycle;

import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortalInstanceLifecycleListener.class})
public class AddGoogleExpandoColumnsPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;

    public void portalInstancePreunregistered(Company company) throws Exception {
        long classNameId = this._classNameLocalService.getClassNameId(User.class.getName());
        ExpandoTable expandoTable = this._expandoTableLocalService.fetchTable(company.getCompanyId(), classNameId, "CUSTOM_FIELDS");
        this._expandoColumnLocalService.deleteColumn(expandoTable.getTableId(), "googleAccessToken");
        this._expandoColumnLocalService.deleteColumn(expandoTable.getTableId(), "googleRefreshToken");
        List expandoColumns = this._expandoColumnLocalService.getColumns(expandoTable.getTableId());
        if (expandoColumns.isEmpty()) {
            this._expandoTableLocalService.deleteExpandoTable(expandoTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void portalInstanceRegistered(Company company) throws Exception {
        Long companyId = CompanyThreadLocal.getCompanyId();
        try {
            CompanyThreadLocal.setCompanyId((Long)company.getCompanyId());
            long classNameId = this._classNameLocalService.getClassNameId(User.class.getName());
            ExpandoTable expandoTable = this._expandoTableLocalService.fetchTable(company.getCompanyId(), classNameId, "CUSTOM_FIELDS");
            if (expandoTable == null) {
                expandoTable = this._expandoTableLocalService.addTable(company.getCompanyId(), classNameId, "CUSTOM_FIELDS");
            }
            UnicodeProperties properties = new UnicodeProperties();
            properties.setProperty("hidden", "true");
            properties.setProperty("visible-with-update-permission", "false");
            this.addExpandoColumn(expandoTable, "googleAccessToken", properties);
            this.addExpandoColumn(expandoTable, "googleRefreshToken", properties);
        }
        finally {
            CompanyThreadLocal.setCompanyId((Long)companyId);
        }
    }

    public void portalInstanceUnregistered(Company company) throws Exception {
    }

    protected void addExpandoColumn(ExpandoTable expandoTable, String name, UnicodeProperties properties) throws Exception {
        ExpandoColumn expandoColumn = this._expandoColumnLocalService.getColumn(expandoTable.getTableId(), name);
        if (expandoColumn != null) {
            return;
        }
        expandoColumn = this._expandoColumnLocalService.addColumn(expandoTable.getTableId(), name, 15);
        this._expandoColumnLocalService.updateTypeSettings(expandoColumn.getColumnId(), properties.toString());
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }
}

