/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.google.internal.auto.login;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.google.GoogleAuthorization;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AutoLogin.class})
public class GoogleAutoLogin
extends BaseAutoLogin {
    @Reference
    private GoogleAuthorization _googleAuthorization;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    protected String[] doLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long companyId = this._portal.getCompanyId(httpServletRequest);
        if (!this._googleAuthorization.isEnabled(companyId)) {
            return null;
        }
        User user = this.getUser(httpServletRequest, companyId);
        if (user == null) {
            return null;
        }
        String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
        return credentials;
    }

    protected User getUser(HttpServletRequest httpServletRequest, long companyId) throws Exception {
        HttpSession session = httpServletRequest.getSession();
        String emailAddress = GetterUtil.getString((Object)session.getAttribute("GOOGLE_USER_EMAIL_ADDRESS"));
        if (Validator.isNotNull((String)emailAddress)) {
            session.removeAttribute("GOOGLE_USER_EMAIL_ADDRESS");
            return this._userLocalService.getUserByEmailAddress(companyId, emailAddress);
        }
        String googleUserId = GetterUtil.getString((String)((String)session.getAttribute("GOOGLE_USER_ID")));
        if (Validator.isNotNull((String)googleUserId)) {
            return this._userLocalService.getUserByGoogleUserId(companyId, googleUserId);
        }
        return null;
    }

    protected void setGoogleAuthorization(GoogleAuthorization googleAuthorization) {
        this._googleAuthorization = googleAuthorization;
    }

    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

