/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.google.internal;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeRequestUrl;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.oauth2.Oauth2;
import com.google.api.services.oauth2.model.Userinfoplus;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ServiceBeanMethodInvocationFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.google.GoogleAuthorization;
import com.liferay.portal.security.sso.google.configuration.GoogleAuthorizationConfiguration;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.sso.google.configuration.GoogleAuthorizationConfiguration"}, immediate=true, service={GoogleAuthorization.class})
public class GoogleAuthorizationImpl
implements GoogleAuthorization {
    private static final String _ONLINE_ACCESS_TYPE = "online";
    @Reference
    private ConfigurationProvider _configurationProvider;
    private final Method _doAddOrUpdateUser;
    @Reference
    private UserLocalService _userLocalService;

    public GoogleAuthorizationImpl() {
        try {
            Class<?> clazz = this.getClass();
            this._doAddOrUpdateUser = clazz.getDeclaredMethod("doAddOrUpdateUser", HttpSession.class, Long.TYPE, Userinfoplus.class);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public User addOrUpdateUser(HttpSession session, long companyId, String authorizationCode, String returnRequestUri, List<String> scopes) throws Exception {
        GoogleAuthorizationCodeFlow googleAuthorizationCodeFlow = this.getGoogleAuthorizationCodeFlow(companyId, scopes);
        GoogleAuthorizationCodeTokenRequest googleAuthorizationCodeTokenRequest = googleAuthorizationCodeFlow.newTokenRequest(authorizationCode);
        googleAuthorizationCodeTokenRequest.setRedirectUri(returnRequestUri);
        GoogleTokenResponse googleTokenResponse = googleAuthorizationCodeTokenRequest.execute();
        Credential credential = googleAuthorizationCodeFlow.createAndStoreCredential((TokenResponse)googleTokenResponse, null);
        Userinfoplus userinfoplus = this.getUserinfoplus(credential);
        if (userinfoplus == null) {
            return null;
        }
        ServiceBeanMethodInvocationFactoryUtil.proceed((Object)this, GoogleAuthorizationImpl.class, (Method)this._doAddOrUpdateUser, (Object[])new Object[]{session, companyId, userinfoplus}, (String[])new String[]{"transactionAdvice"});
        return this.doAddOrUpdateUser(session, companyId, userinfoplus);
    }

    public String getLoginRedirect(long companyId, String returnRequestUri, List<String> scopes) throws Exception {
        GoogleAuthorizationCodeFlow googleAuthorizationCodeFlow = this.getGoogleAuthorizationCodeFlow(companyId, scopes);
        GoogleAuthorizationCodeRequestUrl googleAuthorizationCodeRequestUrl = googleAuthorizationCodeFlow.newAuthorizationUrl();
        googleAuthorizationCodeRequestUrl = googleAuthorizationCodeRequestUrl.setRedirectUri(returnRequestUri);
        return googleAuthorizationCodeRequestUrl.build();
    }

    public boolean isEnabled(long companyId) {
        GoogleAuthorizationConfiguration googleConfiguration = this.getGoogleConfiguration(companyId);
        if (Validator.isNull((String)googleConfiguration.clientId()) || Validator.isNull((String)googleConfiguration.clientSecret())) {
            return false;
        }
        return googleConfiguration.enabled();
    }

    protected User addUser(long companyId, Userinfoplus userinfoplus) throws Exception {
        long creatorUserId = 0L;
        boolean autoPassword = true;
        String password1 = "";
        String password2 = "";
        boolean autoScreenName = true;
        String screenName = "";
        String emailAddress = userinfoplus.getEmail();
        String googleUserId = userinfoplus.getId();
        String openId = "";
        Locale locale = LocaleUtil.getDefault();
        String firstName = userinfoplus.getGivenName();
        String middleName = "";
        String lastName = userinfoplus.getFamilyName();
        long prefixId = 0L;
        long suffixId = 0L;
        boolean male = Objects.equals(userinfoplus.getGender(), "male");
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = true;
        ServiceContext serviceContext = new ServiceContext();
        User user = this._userLocalService.addUser(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, 0L, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
        user = this._userLocalService.updateGoogleUserId(user.getUserId(), googleUserId);
        user = this._userLocalService.updateLastLogin(user.getUserId(), user.getLoginIP());
        user = this._userLocalService.updatePasswordReset(user.getUserId(), false);
        user = this._userLocalService.updateEmailAddressVerified(user.getUserId(), true);
        return user;
    }

    protected User doAddOrUpdateUser(HttpSession session, long companyId, Userinfoplus userinfoplus) throws Exception {
        User user = null;
        String googleUserId = userinfoplus.getId();
        if (Validator.isNotNull((String)googleUserId) && (user = this._userLocalService.fetchUserByGoogleUserId(companyId, googleUserId)) != null && user.getStatus() != 6) {
            session.setAttribute("GOOGLE_USER_ID", (Object)String.valueOf(googleUserId));
        }
        String emailAddress = userinfoplus.getEmail();
        if (user == null && Validator.isNotNull((String)emailAddress) && (user = this._userLocalService.fetchUserByEmailAddress(companyId, emailAddress)) != null && user.getStatus() != 6) {
            session.setAttribute("GOOGLE_USER_EMAIL_ADDRESS", (Object)emailAddress);
        }
        if (user != null) {
            if (user.getStatus() == 6) {
                session.setAttribute("GOOGLE_INCOMPLETE_USER_ID", (Object)userinfoplus.getId());
                user.setEmailAddress(userinfoplus.getEmail());
                user.setFirstName(userinfoplus.getGivenName());
                user.setLastName(userinfoplus.getFamilyName());
                return user;
            }
            user = this.updateUser(user, userinfoplus);
        } else {
            user = this.addUser(companyId, userinfoplus);
            session.setAttribute("GOOGLE_USER_EMAIL_ADDRESS", (Object)emailAddress);
        }
        return user;
    }

    protected GoogleAuthorizationCodeFlow getGoogleAuthorizationCodeFlow(long companyId, List<String> scopes) throws Exception {
        GoogleAuthorizationConfiguration googleAuthorizationConfiguration = this.getGoogleConfiguration(companyId);
        NetHttpTransport httpTransport = new NetHttpTransport();
        JacksonFactory jsonFactory = new JacksonFactory();
        GoogleAuthorizationCodeFlow.Builder googleAuthorizationCodeFlowBuilder = new GoogleAuthorizationCodeFlow.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, googleAuthorizationConfiguration.clientId(), googleAuthorizationConfiguration.clientSecret(), scopes);
        googleAuthorizationCodeFlowBuilder = googleAuthorizationCodeFlowBuilder.setAccessType(_ONLINE_ACCESS_TYPE);
        return googleAuthorizationCodeFlowBuilder.build();
    }

    protected GoogleAuthorizationConfiguration getGoogleConfiguration(long companyId) {
        try {
            return (GoogleAuthorizationConfiguration)this._configurationProvider.getConfiguration(GoogleAuthorizationConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.portal.security.sso.google.authorization"));
        }
        catch (ConfigurationException ce) {
            throw new SystemException((Throwable)ce);
        }
    }

    protected Userinfoplus getUserinfoplus(Credential credentials) throws Exception {
        Oauth2.Builder builder = new Oauth2.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), (HttpRequestInitializer)credentials);
        Oauth2 oauth2 = builder.build();
        Oauth2.Userinfo oAuth2Userinfo = oauth2.userinfo();
        Oauth2.Userinfo.Get oAuth2UserinfoGet = oAuth2Userinfo.get();
        Userinfoplus userinfoplus = (Userinfoplus)oAuth2UserinfoGet.execute();
        if (userinfoplus == null || userinfoplus.getId() == null) {
            throw new PrincipalException();
        }
        return userinfoplus;
    }

    protected User updateUser(User user, Userinfoplus userinfoplus) throws Exception {
        String emailAddress = userinfoplus.getEmail();
        String googleUserId = userinfoplus.getId();
        String firstName = userinfoplus.getGivenName();
        String lastName = userinfoplus.getFamilyName();
        boolean male = Objects.equals(userinfoplus.getGender(), "male");
        if (emailAddress.equals(user.getEmailAddress()) && firstName.equals(user.getFirstName()) && lastName.equals(user.getLastName()) && male == user.isMale()) {
            return user;
        }
        Contact contact = user.getContact();
        Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
        birthdayCal.setTime(contact.getBirthday());
        int birthdayMonth = birthdayCal.get(2);
        int birthdayDay = birthdayCal.get(5);
        int birthdayYear = birthdayCal.get(1);
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        List userGroupRoles = null;
        long[] userGroupIds = null;
        ServiceContext serviceContext = new ServiceContext();
        if (!StringUtil.equalsIgnoreCase((String)googleUserId, (String)user.getGoogleUserId())) {
            this._userLocalService.updateGoogleUserId(user.getUserId(), googleUserId);
        }
        if (!StringUtil.equalsIgnoreCase((String)emailAddress, (String)user.getEmailAddress())) {
            this._userLocalService.updateEmailAddress(user.getUserId(), "", emailAddress, emailAddress);
        }
        this._userLocalService.updateEmailAddressVerified(user.getUserId(), true);
        return this._userLocalService.updateUser(user.getUserId(), "", "", "", false, user.getReminderQueryQuestion(), user.getReminderQueryAnswer(), user.getScreenName(), emailAddress, 0L, user.getOpenId(), true, null, user.getLanguageId(), user.getTimeZoneId(), user.getGreeting(), user.getComments(), firstName, user.getMiddleName(), lastName, contact.getPrefixId(), contact.getSuffixId(), male, birthdayMonth, birthdayDay, birthdayYear, contact.getSmsSn(), contact.getFacebookSn(), contact.getJabberSn(), contact.getSkypeSn(), contact.getTwitterSn(), contact.getJobTitle(), groupIds, organizationIds, roleIds, userGroupRoles, userGroupIds, serviceContext);
    }
}

