/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.facebook.connect.internal.auto.login;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.facebook.FacebookConnect;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AutoLogin.class})
public class FacebookConnectAutoLogin
extends BaseAutoLogin {
    private FacebookConnect _facebookConnect;
    @Reference
    private Portal _portal;
    private UserLocalService _userLocalService;

    protected String[] doLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long companyId = this._portal.getCompanyId(request);
        if (!this._facebookConnect.isEnabled(companyId)) {
            return null;
        }
        User user = this.getUser(request, companyId);
        if (user == null) {
            return null;
        }
        String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.FALSE.toString()};
        return credentials;
    }

    protected User getUser(HttpServletRequest request, long companyId) throws PortalException {
        HttpSession session = request.getSession();
        String emailAddress = (String)session.getAttribute("FACEBOOK_USER_EMAIL_ADDRESS");
        if (Validator.isNotNull((String)emailAddress)) {
            session.removeAttribute("FACEBOOK_USER_EMAIL_ADDRESS");
            return this._userLocalService.getUserByEmailAddress(companyId, emailAddress);
        }
        long facebookId = GetterUtil.getLong((String)((String)session.getAttribute("FACEBOOK_USER_ID")));
        if (facebookId > 0L) {
            return this._userLocalService.getUserByFacebookId(companyId, facebookId);
        }
        return null;
    }

    @Reference(unbind="-")
    protected void setFacebookConnect(FacebookConnect facebookConnect) {
        this._facebookConnect = facebookConnect;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

