/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.cas.internal.servlet.filter;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.servlet.BaseFilter;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.cas.configuration.CASConfiguration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ProxyTicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.sso.cas.configuration.CASConfiguration"}, immediate=true, property={"before-filter=Auto Login Filter", "dispatcher=FORWARD", "dispatcher=REQUEST", "servlet-context-name=", "servlet-filter-name=SSO CAS Filter", "url-pattern=/c/portal/login", "url-pattern=/c/portal/logout"}, service={Filter.class})
public class CASFilter
extends BaseFilter {
    private static final Log _log = LogFactoryUtil.getLog(CASFilter.class);
    private static final Map<Long, TicketValidator> _ticketValidators = new ConcurrentHashMap<Long, TicketValidator>();
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Http _http;
    @Reference
    private Portal _portal;

    public static void reload(long companyId) {
        _ticketValidators.remove(companyId);
    }

    public boolean isFilterEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            CASConfiguration casConfiguration = (CASConfiguration)this._configurationProvider.getConfiguration(CASConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(this._portal.getCompanyId(httpServletRequest), "com.liferay.portal.security.sso.cas"));
            if (casConfiguration.enabled()) {
                return true;
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        return false;
    }

    protected Log getLog() {
        return _log;
    }

    protected TicketValidator getTicketValidator(long companyId) throws Exception {
        TicketValidator ticketValidator = _ticketValidators.get(companyId);
        if (ticketValidator != null) {
            return ticketValidator;
        }
        CASConfiguration casConfiguration = (CASConfiguration)this._configurationProvider.getConfiguration(CASConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.portal.security.sso.cas"));
        String serverName = casConfiguration.serverName();
        String serverUrl = casConfiguration.serverURL();
        String loginUrl = casConfiguration.loginURL();
        Cas20ProxyTicketValidator cas20ProxyTicketValidator = new Cas20ProxyTicketValidator(serverUrl);
        cas20ProxyTicketValidator.setCustomParameters((Map)HashMapBuilder.put((Object)"casServerLoginUrl", (Object)loginUrl).put((Object)"casServerUrlPrefix", (Object)serverUrl).put((Object)"redirectAfterValidation", (Object)"false").put((Object)"serverName", (Object)serverName).build());
        _ticketValidators.put(companyId, (TicketValidator)cas20ProxyTicketValidator);
        return cas20ProxyTicketValidator;
    }

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        String ticket;
        HttpSession session = httpServletRequest.getSession();
        long companyId = this._portal.getCompanyId(httpServletRequest);
        CASConfiguration casConfiguration = (CASConfiguration)this._configurationProvider.getConfiguration(CASConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.portal.security.sso.cas"));
        Object forceLogout = session.getAttribute("CAS_FORCE_LOGOUT");
        if (forceLogout != null) {
            session.removeAttribute("CAS_FORCE_LOGOUT");
            String logoutUrl = casConfiguration.logoutURL();
            httpServletResponse.sendRedirect(logoutUrl);
            return;
        }
        String pathInfo = httpServletRequest.getPathInfo();
        if (Validator.isNotNull((String)pathInfo) && pathInfo.contains("/portal/logout")) {
            session.invalidate();
            String logoutUrl = casConfiguration.logoutURL();
            httpServletResponse.sendRedirect(logoutUrl);
            return;
        }
        String login = (String)session.getAttribute("CAS_LOGIN");
        if (Validator.isNotNull((String)login)) {
            this.processFilter(CASFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
            return;
        }
        String serverName = casConfiguration.serverName();
        String serviceURL = casConfiguration.serviceURL();
        if (Validator.isNull((String)serviceURL)) {
            serviceURL = CommonUtils.constructServiceUrl((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)serviceURL, (String)serverName, (String)"service", (String)"ticket", (boolean)true);
        }
        if (Validator.isNull((String)(ticket = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"ticket")))) {
            String loginUrl = casConfiguration.loginURL();
            loginUrl = this._http.addParameter(loginUrl, "service", serviceURL);
            httpServletResponse.sendRedirect(loginUrl);
            return;
        }
        TicketValidator ticketValidator = this.getTicketValidator(companyId);
        Assertion assertion = null;
        try {
            assertion = ticketValidator.validate(ticket, serviceURL);
        }
        catch (TicketValidationException ticketValidationException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)ticketValidationException.getMessage(), (Throwable)ticketValidationException);
            } else if (_log.isInfoEnabled()) {
                _log.info((Object)ticketValidationException.getMessage());
            }
            this._portal.sendError((Exception)new PortalException("Unable to validate CAS ticket: " + ticket, (Throwable)ticketValidationException), httpServletRequest, httpServletResponse);
            return;
        }
        if (assertion != null) {
            AttributePrincipal attributePrincipal = assertion.getPrincipal();
            login = attributePrincipal.getName();
            session.setAttribute("CAS_LOGIN", (Object)login);
        }
        this.processFilter(CASFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }
}

