/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.cas.internal.auto.login;

import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.exportimport.UserImporter;
import com.liferay.portal.security.sso.cas.configuration.CASConfiguration;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.portal.security.sso.cas.configuration.CASConfiguration"}, immediate=true, service={AutoLogin.class})
public class CASAutoLogin
extends BaseAutoLogin {
    private static final Log _log = LogFactoryUtil.getLog(CASAutoLogin.class);
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Portal _portal;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile UserImporter _userImporter;
    private UserLocalService _userLocalService;

    protected String[] doHandleException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception) {
        if (exception instanceof NoSuchUserException) {
            HttpSession session = httpServletRequest.getSession();
            session.removeAttribute("CAS_LOGIN");
            session.setAttribute("CAS_NO_SUCH_USER_EXCEPTION", (Object)Boolean.TRUE);
        }
        _log.error((Object)exception, (Throwable)exception);
        return null;
    }

    protected String[] doLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String authType;
        User user;
        String login;
        long companyId;
        block7: {
            HttpSession session = httpServletRequest.getSession();
            companyId = this._portal.getCompanyId(httpServletRequest);
            CASConfiguration casConfiguration = (CASConfiguration)this._configurationProvider.getConfiguration(CASConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.portal.security.sso.cas"));
            if (!casConfiguration.enabled()) {
                return null;
            }
            login = (String)session.getAttribute("CAS_LOGIN");
            if (Validator.isNull((String)login)) {
                Object noSuchUserException = session.getAttribute("CAS_NO_SUCH_USER_EXCEPTION");
                if (noSuchUserException == null) {
                    return null;
                }
                session.removeAttribute("CAS_NO_SUCH_USER_EXCEPTION");
                session.setAttribute("CAS_FORCE_LOGOUT", (Object)Boolean.TRUE);
                String redirect = casConfiguration.noSuchUserRedirectURL();
                httpServletRequest.setAttribute("AUTO_LOGIN_REDIRECT", (Object)redirect);
                return null;
            }
            user = null;
            authType = PrefsPropsUtil.getString((long)companyId, (String)"company.security.auth.type", (String)PropsValues.COMPANY_SECURITY_AUTH_TYPE);
            if (casConfiguration.importFromLDAP()) {
                try {
                    user = authType.equals("screenName") ? this._userImporter.importUser(companyId, "", login) : this._userImporter.importUser(companyId, login, "");
                }
                catch (SystemException systemException) {
                    if (!_log.isDebugEnabled()) break block7;
                    _log.debug((Object)systemException, (Throwable)systemException);
                }
            }
        }
        if (user == null) {
            user = authType.equals("screenName") ? this._userLocalService.getUserByScreenName(companyId, login) : this._userLocalService.getUserByEmailAddress(companyId, login);
        }
        this.addRedirect(httpServletRequest);
        String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
        return credentials;
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

