/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.cas.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.sso.SSO;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.security.sso.cas.configuration.CASConfiguration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.sso.cas.configuration.CASConfiguration"}, immediate=true, service={SSO.class})
public class SSOImpl
implements SSO {
    private static final Log _log = LogFactoryUtil.getLog(SSOImpl.class);
    private ConfigurationProvider _configurationProvider;

    public String getSessionExpirationRedirectUrl(long companyId) {
        CASConfiguration casConfiguration = this._getCASConfiguration(companyId);
        if (casConfiguration.logoutOnSessionExpiration()) {
            return casConfiguration.logoutURL();
        }
        return null;
    }

    public String getSignInURL(long companyId, String defaultSigninURL) {
        CASConfiguration casConfiguration = this._getCASConfiguration(companyId);
        if (!casConfiguration.enabled()) {
            return null;
        }
        return casConfiguration.loginURL();
    }

    public boolean isLoginRedirectRequired(long companyId) {
        return this.isCASAuthEnabled(companyId);
    }

    public boolean isRedirectRequired(long companyId) {
        return this.isCASAuthEnabled(companyId);
    }

    public boolean isSessionRedirectOnExpire(long companyId) {
        CASConfiguration casConfiguration = this._getCASConfiguration(companyId);
        return casConfiguration.logoutOnSessionExpiration();
    }

    protected boolean isCASAuthEnabled(long companyId) {
        CASConfiguration casConfiguration = this._getCASConfiguration(companyId);
        return casConfiguration.enabled();
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }

    private CASConfiguration _getCASConfiguration(long companyId) {
        try {
            CASConfiguration casCompanyServiceSettings = (CASConfiguration)this._configurationProvider.getConfiguration(CASConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.portal.security.sso.cas"));
            return casCompanyServiceSettings;
        }
        catch (ConfigurationException ce) {
            _log.error((Object)"Unable to get CAS configuration", (Throwable)ce);
            return null;
        }
    }
}

