/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.service.access.policy.web.internal.portlet;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionMapping;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManager;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.service.access.policy.service.SAPEntryService;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"com.liferay.portlet.css-class-wrapper=portal-security-service-access-policy-portlet", "com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.instanceable=false", "javax.portlet.display-name=Service Access Policy", "javax.portlet.expiration-cache=0", "javax.portlet.info.keywords=Service Access Policy", "javax.portlet.info.short-title=Service Access Policy", "javax.portlet.info.title=Service Access Policy", "javax.portlet.init-param.clear-request-parameters=true", "javax.portlet.init-param.copy-request-parameters=true", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_portal_security_service_access_policy_web_portlet_SAPPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class SAPPortlet
extends MVCPortlet {
    private JSONWebServiceActionsManager _jsonWebServiceActionsManager;
    private SAPEntryService _sapEntryService;

    public void deleteSAPEntry(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long sapEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"sapEntryId");
        this._sapEntryService.deleteSAPEntry(sapEntryId);
    }

    public void getActionMethodNames(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException {
        PrintWriter printWriter = resourceResponse.getWriter();
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        String contextName = ParamUtil.getString((PortletRequest)resourceRequest, (String)"contextName");
        Map<String, Set<JSONWebServiceActionMapping>> jsonWebServiceActionMappingsMap = this.getServiceJSONWebServiceActionMappingsMap(contextName);
        String serviceClassName = ParamUtil.getString((PortletRequest)resourceRequest, (String)"serviceClassName");
        Set<JSONWebServiceActionMapping> jsonWebServiceActionMappingsSet = jsonWebServiceActionMappingsMap.get(serviceClassName);
        for (JSONWebServiceActionMapping jsonWebServiceActionMapping : jsonWebServiceActionMappingsSet) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            Method method = jsonWebServiceActionMapping.getActionMethod();
            String actionMethodName = method.getName();
            jsonObject.put("actionMethodName", actionMethodName);
            jsonArray.put(jsonObject);
        }
        printWriter.write(jsonArray.toString());
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        String mvcPath = ParamUtil.getString((PortletRequest)renderRequest, (String)"mvcPath");
        if (mvcPath.equals("/edit_entry.jsp")) {
            JSONArray serviceClassNamesToContextNamesJSONArray = this.getServiceClassNamesToContextNamesJSONArray();
            renderRequest.setAttribute("SERVICE_CLASS_NAMES_TO_CONTEXT_NAMES", (Object)serviceClassNamesToContextNamesJSONArray);
        }
        super.render(renderRequest, renderResponse);
    }

    public void updateSAPEntry(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long sapEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"sapEntryId");
        String allowedServiceSignatures = ParamUtil.getString((PortletRequest)actionRequest, (String)"allowedServiceSignatures");
        boolean defaultSAPEntry = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"defaultSAPEntry");
        boolean enabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enabled");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        Map titleMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"title");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        if (sapEntryId > 0L) {
            this._sapEntryService.updateSAPEntry(sapEntryId, allowedServiceSignatures, defaultSAPEntry, enabled, name, titleMap, serviceContext);
        } else {
            this._sapEntryService.addSAPEntry(allowedServiceSignatures, defaultSAPEntry, enabled, name, titleMap, serviceContext);
        }
    }

    protected JSONArray getServiceClassNamesToContextNamesJSONArray() {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        Set contextNames = this._jsonWebServiceActionsManager.getContextNames();
        for (String contextName : contextNames) {
            Map<String, Set<JSONWebServiceActionMapping>> jsonWebServiceActionMappingsMap = this.getServiceJSONWebServiceActionMappingsMap(contextName);
            for (Map.Entry<String, Set<JSONWebServiceActionMapping>> entry : jsonWebServiceActionMappingsMap.entrySet()) {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                jsonObject.put("serviceClassName", entry.getKey());
                Set<JSONWebServiceActionMapping> jsonWebServiceActionMappingsSet = entry.getValue();
                Iterator<JSONWebServiceActionMapping> iterator = jsonWebServiceActionMappingsSet.iterator();
                JSONWebServiceActionMapping firstJSONWebServiceActionMapping = iterator.next();
                jsonObject.put("contextName", firstJSONWebServiceActionMapping.getContextName());
                jsonArray.put(jsonObject);
            }
        }
        return jsonArray;
    }

    protected Map<String, Set<JSONWebServiceActionMapping>> getServiceJSONWebServiceActionMappingsMap(String contextName) {
        LinkedHashMap<String, Set<JSONWebServiceActionMapping>> jsonWebServiceActionMappingsMap = new LinkedHashMap<String, Set<JSONWebServiceActionMapping>>();
        List jsonWebServiceActionMappings = this._jsonWebServiceActionsManager.getJSONWebServiceActionMappings(contextName);
        for (JSONWebServiceActionMapping jsonWebServiceActionMapping : jsonWebServiceActionMappings) {
            Class<?>[] serviceInterfaces;
            Object actionObject = jsonWebServiceActionMapping.getActionObject();
            Class<?> serviceClass = actionObject.getClass();
            for (Class<?> serviceInterface : serviceInterfaces = serviceClass.getInterfaces()) {
                Annotation[] declaredAnnotations;
                for (Annotation declaredAnnotation : declaredAnnotations = serviceInterface.getDeclaredAnnotations()) {
                    if (!(declaredAnnotation instanceof AccessControlled)) continue;
                    String serviceClassName = serviceInterface.getName();
                    LinkedHashSet<JSONWebServiceActionMapping> jsonWebServiceActionMappingsSet = (LinkedHashSet<JSONWebServiceActionMapping>)jsonWebServiceActionMappingsMap.get(serviceClassName);
                    if (jsonWebServiceActionMappingsSet == null) {
                        jsonWebServiceActionMappingsSet = new LinkedHashSet<JSONWebServiceActionMapping>();
                        jsonWebServiceActionMappingsMap.put(serviceClassName, jsonWebServiceActionMappingsSet);
                    }
                    jsonWebServiceActionMappingsSet.add(jsonWebServiceActionMapping);
                }
            }
        }
        return jsonWebServiceActionMappingsMap;
    }

    @Reference(unbind="-")
    protected void setJSONWebServiceActionsManager(JSONWebServiceActionsManager jsonWebServiceActionsManager) {
        this._jsonWebServiceActionsManager = jsonWebServiceActionsManager;
    }

    @Reference(unbind="-")
    protected void setSAPEntryService(SAPEntryService sapEntryService) {
        this._sapEntryService = sapEntryService;
    }
}

