/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.service.access.policy.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.model.SAPEntrySoap;
import com.liferay.portal.security.service.access.policy.model.impl.SAPEntryModelImpl;
import com.liferay.portal.security.service.access.policy.service.SAPEntryServiceUtil;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class SAPEntryServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(SAPEntryServiceSoap.class);

    public static SAPEntrySoap addSAPEntry(String allowedServiceSignatures, boolean defaultSAPEntry, boolean enabled, String name, String[] titleMapLanguageIds, String[] titleMapValues, ServiceContext serviceContext) throws RemoteException {
        try {
            Map titleMap = LocalizationUtil.getLocalizationMap((String[])titleMapLanguageIds, (String[])titleMapValues);
            SAPEntry returnValue = SAPEntryServiceUtil.addSAPEntry((String)allowedServiceSignatures, (boolean)defaultSAPEntry, (boolean)enabled, (String)name, (Map)titleMap, (ServiceContext)serviceContext);
            return SAPEntrySoap.toSoapModel((SAPEntry)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SAPEntrySoap deleteSAPEntry(long sapEntryId) throws RemoteException {
        try {
            SAPEntry returnValue = SAPEntryServiceUtil.deleteSAPEntry((long)sapEntryId);
            return SAPEntrySoap.toSoapModel((SAPEntry)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SAPEntrySoap deleteSAPEntry(SAPEntrySoap sapEntry) throws RemoteException {
        try {
            SAPEntry returnValue = SAPEntryServiceUtil.deleteSAPEntry((SAPEntry)SAPEntryModelImpl.toModel(sapEntry));
            return SAPEntrySoap.toSoapModel((SAPEntry)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SAPEntrySoap fetchSAPEntry(long companyId, String name) throws RemoteException {
        try {
            SAPEntry returnValue = SAPEntryServiceUtil.fetchSAPEntry((long)companyId, (String)name);
            return SAPEntrySoap.toSoapModel((SAPEntry)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SAPEntrySoap[] getCompanySAPEntries(long companyId, int start, int end) throws RemoteException {
        try {
            List returnValue = SAPEntryServiceUtil.getCompanySAPEntries((long)companyId, (int)start, (int)end);
            return SAPEntrySoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SAPEntrySoap[] getCompanySAPEntries(long companyId, int start, int end, OrderByComparator<SAPEntry> obc) throws RemoteException {
        try {
            List returnValue = SAPEntryServiceUtil.getCompanySAPEntries((long)companyId, (int)start, (int)end, obc);
            return SAPEntrySoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getCompanySAPEntriesCount(long companyId) throws RemoteException {
        try {
            int returnValue = SAPEntryServiceUtil.getCompanySAPEntriesCount((long)companyId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SAPEntrySoap getSAPEntry(long sapEntryId) throws RemoteException {
        try {
            SAPEntry returnValue = SAPEntryServiceUtil.getSAPEntry((long)sapEntryId);
            return SAPEntrySoap.toSoapModel((SAPEntry)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SAPEntrySoap getSAPEntry(long companyId, String name) throws RemoteException {
        try {
            SAPEntry returnValue = SAPEntryServiceUtil.getSAPEntry((long)companyId, (String)name);
            return SAPEntrySoap.toSoapModel((SAPEntry)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static SAPEntrySoap updateSAPEntry(long sapEntryId, String allowedServiceSignatures, boolean defaultSAPEntry, boolean enabled, String name, String[] titleMapLanguageIds, String[] titleMapValues, ServiceContext serviceContext) throws RemoteException {
        try {
            Map titleMap = LocalizationUtil.getLocalizationMap((String[])titleMapLanguageIds, (String[])titleMapValues);
            SAPEntry returnValue = SAPEntryServiceUtil.updateSAPEntry((long)sapEntryId, (String)allowedServiceSignatures, (boolean)defaultSAPEntry, (boolean)enabled, (String)name, (Map)titleMap, (ServiceContext)serviceContext);
            return SAPEntrySoap.toSoapModel((SAPEntry)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }
}

