/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.service.access.policy.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryServiceUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class SAPEntryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(SAPEntryServiceHttp.class);
    private static final Class<?>[] _addSAPEntryParameterTypes0 = new Class[]{String.class, Boolean.TYPE, Boolean.TYPE, String.class, Map.class, ServiceContext.class};
    private static final Class<?>[] _deleteSAPEntryParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _deleteSAPEntryParameterTypes2 = new Class[]{SAPEntry.class};
    private static final Class<?>[] _fetchSAPEntryParameterTypes3 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getCompanySAPEntriesParameterTypes4 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getCompanySAPEntriesParameterTypes5 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _getCompanySAPEntriesCountParameterTypes6 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getSAPEntryParameterTypes7 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getSAPEntryParameterTypes8 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _updateSAPEntryParameterTypes9 = new Class[]{Long.TYPE, String.class, Boolean.TYPE, Boolean.TYPE, String.class, Map.class, ServiceContext.class};

    public static SAPEntry addSAPEntry(HttpPrincipal httpPrincipal, String allowedServiceSignatures, boolean defaultSAPEntry, boolean enabled, String name, Map<Locale, String> titleMap, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(SAPEntryServiceUtil.class, "addSAPEntry", (Class[])_addSAPEntryParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{allowedServiceSignatures, defaultSAPEntry, enabled, name, titleMap, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (SAPEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static SAPEntry deleteSAPEntry(HttpPrincipal httpPrincipal, long sapEntryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(SAPEntryServiceUtil.class, "deleteSAPEntry", (Class[])_deleteSAPEntryParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{sapEntryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (SAPEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static SAPEntry deleteSAPEntry(HttpPrincipal httpPrincipal, SAPEntry sapEntry) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(SAPEntryServiceUtil.class, "deleteSAPEntry", (Class[])_deleteSAPEntryParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{sapEntry});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (SAPEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static SAPEntry fetchSAPEntry(HttpPrincipal httpPrincipal, long companyId, String name) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(SAPEntryServiceUtil.class, "fetchSAPEntry", (Class[])_fetchSAPEntryParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (SAPEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<SAPEntry> getCompanySAPEntries(HttpPrincipal httpPrincipal, long companyId, int start, int end) {
        try {
            MethodKey methodKey = new MethodKey(SAPEntryServiceUtil.class, "getCompanySAPEntries", (Class[])_getCompanySAPEntriesParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<SAPEntry> getCompanySAPEntries(HttpPrincipal httpPrincipal, long companyId, int start, int end, OrderByComparator<SAPEntry> obc) {
        try {
            MethodKey methodKey = new MethodKey(SAPEntryServiceUtil.class, "getCompanySAPEntries", (Class[])_getCompanySAPEntriesParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, start, end, obc});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getCompanySAPEntriesCount(HttpPrincipal httpPrincipal, long companyId) {
        try {
            MethodKey methodKey = new MethodKey(SAPEntryServiceUtil.class, "getCompanySAPEntriesCount", (Class[])_getCompanySAPEntriesCountParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static SAPEntry getSAPEntry(HttpPrincipal httpPrincipal, long sapEntryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(SAPEntryServiceUtil.class, "getSAPEntry", (Class[])_getSAPEntryParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{sapEntryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (SAPEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static SAPEntry getSAPEntry(HttpPrincipal httpPrincipal, long companyId, String name) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(SAPEntryServiceUtil.class, "getSAPEntry", (Class[])_getSAPEntryParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (SAPEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static SAPEntry updateSAPEntry(HttpPrincipal httpPrincipal, long sapEntryId, String allowedServiceSignatures, boolean defaultSAPEntry, boolean enabled, String name, Map<Locale, String> titleMap, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(SAPEntryServiceUtil.class, "updateSAPEntry", (Class[])_updateSAPEntryParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{sapEntryId, allowedServiceSignatures, defaultSAPEntry, enabled, name, titleMap, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (SAPEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

