/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.service.access.policy.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.access.control.AccessControlPolicy;
import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.security.access.control.BaseAccessControlPolicy;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.security.service.access.policy.ServiceAccessPolicyThreadLocal;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.service.access.policy.configuration.SAPConfiguration;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AccessControlPolicy.class})
public class SAPAccessControlPolicy
extends BaseAccessControlPolicy {
    private ConfigurationProvider _configurationProvider;
    private SAPEntryLocalService _sapEntryLocalService;

    public void onServiceRemoteAccess(Method method, Object[] arguments, AccessControlled accessControlled) throws SecurityException {
        if (this.isChecked()) {
            return;
        }
        ArrayList<String> serviceAccessPolicyNames = new ArrayList<String>();
        serviceAccessPolicyNames.addAll(this.getActiveServiceAccessPolicyNames());
        serviceAccessPolicyNames.addAll(this.getDefaultServiceAccessPolicyNames(CompanyThreadLocal.getCompanyId()));
        serviceAccessPolicyNames.addAll(this.getSystemServiceAccessPolicyNames(CompanyThreadLocal.getCompanyId()));
        Set<String> allowedServiceSignatures = this.loadAllowedServiceSignatures(CompanyThreadLocal.getCompanyId(), serviceAccessPolicyNames);
        Class<?> clazz = method.getDeclaringClass();
        this.checkAccess(allowedServiceSignatures, clazz.getName(), method.getName());
    }

    protected void checkAccess(Set<String> allowedServiceSignatures, String className, String methodName) {
        if (allowedServiceSignatures.contains("*")) {
            return;
        }
        if (allowedServiceSignatures.contains(className)) {
            return;
        }
        String classNameAndMethodName = className.concat("#").concat(methodName);
        if (allowedServiceSignatures.contains(classNameAndMethodName)) {
            return;
        }
        for (String allowedServiceSignature : allowedServiceSignatures) {
            if (!this.matches(className, methodName, allowedServiceSignature)) continue;
            return;
        }
        throw new SecurityException("Access denied to " + classNameAndMethodName);
    }

    protected List<String> getActiveServiceAccessPolicyNames() {
        ArrayList activeServiceAccessPolicyNames = ServiceAccessPolicyThreadLocal.getActiveServiceAccessPolicyNames();
        if (activeServiceAccessPolicyNames == null) {
            activeServiceAccessPolicyNames = new ArrayList();
            ServiceAccessPolicyThreadLocal.setActiveServiceAccessPolicyNames(activeServiceAccessPolicyNames);
        }
        return activeServiceAccessPolicyNames;
    }

    protected List<String> getDefaultServiceAccessPolicyNames(long companyId) {
        List defaultSAPEntries = this._sapEntryLocalService.getDefaultSAPEntries(companyId, true);
        ArrayList<String> defaultServiceAccessPolicyNames = new ArrayList<String>(defaultSAPEntries.size());
        for (SAPEntry sapEntry : defaultSAPEntries) {
            defaultServiceAccessPolicyNames.add(sapEntry.getName());
        }
        return defaultServiceAccessPolicyNames;
    }

    protected List<String> getSystemServiceAccessPolicyNames(long companyId) {
        AuthVerifierResult authVerifierResult;
        ArrayList<String> systemServiceAccessPolicyNames = new ArrayList<String>(2);
        SAPConfiguration sapConfiguration = null;
        try {
            sapConfiguration = (SAPConfiguration)this._configurationProvider.getConfiguration(SAPConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.portal.security.service.access.policy"));
        }
        catch (ConfigurationException ce) {
            throw new SystemException("Unable to get service access policy configuration", (Throwable)ce);
        }
        if (!sapConfiguration.useSystemSAPEntries()) {
            return systemServiceAccessPolicyNames;
        }
        systemServiceAccessPolicyNames.add(sapConfiguration.systemDefaultSAPEntryName());
        boolean passwordBasedAuthentication = false;
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        if (accessControlContext != null && (authVerifierResult = accessControlContext.getAuthVerifierResult()) != null) {
            passwordBasedAuthentication = authVerifierResult.isPasswordBasedAuthentication();
        }
        if (passwordBasedAuthentication) {
            systemServiceAccessPolicyNames.add(sapConfiguration.systemUserPasswordSAPEntryName());
        }
        return systemServiceAccessPolicyNames;
    }

    protected boolean isChecked() {
        Map settings;
        int serviceDepth;
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        return accessControlContext != null && (serviceDepth = ((Integer)(settings = accessControlContext.getSettings()).get(AccessControlContext.Settings.SERVICE_DEPTH.toString())).intValue()) > 1;
    }

    protected Set<String> loadAllowedServiceSignatures(long companyId, List<String> serviceAccessPolicyNames) {
        HashSet<String> allowedServiceSignatures = new HashSet<String>();
        for (String serviceAccessPolicyName : serviceAccessPolicyNames) {
            try {
                SAPEntry sapEntry = this._sapEntryLocalService.getSAPEntry(companyId, serviceAccessPolicyName);
                if (!sapEntry.isEnabled()) continue;
                allowedServiceSignatures.addAll(sapEntry.getAllowedServiceSignaturesList());
            }
            catch (PortalException pe) {
                throw new SystemException((Throwable)pe);
            }
        }
        return allowedServiceSignatures;
    }

    protected boolean matches(String className, String methodName, String allowedServiceSignature) {
        String allowedClassName = null;
        String allowedMethodName = null;
        int index = allowedServiceSignature.indexOf(35);
        if (index > -1) {
            allowedClassName = allowedServiceSignature.substring(0, index);
            allowedMethodName = allowedServiceSignature.substring(index + 1);
        } else {
            allowedClassName = allowedServiceSignature;
        }
        boolean wildcardMatchClass = false;
        if (Validator.isNotNull((String)allowedClassName) && allowedClassName.endsWith("*")) {
            allowedClassName = allowedClassName.substring(0, allowedClassName.length() - 1);
            wildcardMatchClass = true;
        }
        boolean wildcardMatchMethod = false;
        if (Validator.isNotNull((String)allowedMethodName) && allowedMethodName.endsWith("*")) {
            allowedMethodName = allowedMethodName.substring(0, allowedMethodName.length() - 1);
            wildcardMatchMethod = true;
        }
        if (Validator.isNotNull((String)allowedClassName) && Validator.isNotNull((String)allowedMethodName)) {
            if (wildcardMatchClass && !className.startsWith(allowedClassName)) {
                return false;
            }
            if (!wildcardMatchClass && !className.equals(allowedClassName)) {
                return false;
            }
            if (wildcardMatchMethod && !methodName.startsWith(allowedMethodName)) {
                return false;
            }
            return wildcardMatchMethod || methodName.equals(allowedMethodName);
        }
        if (Validator.isNotNull((String)allowedClassName)) {
            if (wildcardMatchClass && !className.startsWith(allowedClassName)) {
                return false;
            }
            return wildcardMatchClass || className.equals(allowedClassName);
        }
        if (Validator.isNotNull((String)allowedMethodName)) {
            if (wildcardMatchMethod && !methodName.startsWith(allowedMethodName)) {
                return false;
            }
            return wildcardMatchMethod || methodName.equals(allowedMethodName);
        }
        return wildcardMatchClass && Validator.isNull((String)allowedClassName);
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }

    @Reference(unbind="-")
    protected void setSAPEntryLocalService(SAPEntryLocalService sapEntryLocalService) {
        this._sapEntryLocalService = sapEntryLocalService;
    }
}

