/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.service.access.policy.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.security.service.access.policy.constants.SAPActionKeys;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.base.SAPEntryServiceBaseImpl;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SAPEntryServiceImpl
extends SAPEntryServiceBaseImpl {
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(SAPEntryServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.portal.security.service.access.policy");
    private static volatile ModelResourcePermission<SAPEntry> _sapEntryFolderModelResourcePermission = ModelResourcePermissionFactory.getInstance(SAPEntryServiceImpl.class, (String)"_sapEntryFolderModelResourcePermission", SAPEntry.class);

    public SAPEntry addSAPEntry(String allowedServiceSignatures, boolean defaultSAPEntry, boolean enabled, String name, Map<Locale, String> titleMap, ServiceContext serviceContext) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), null, SAPActionKeys.ACTION_ADD_SAP_ENTRY);
        return this.sapEntryLocalService.addSAPEntry(this.getUserId(), allowedServiceSignatures, defaultSAPEntry, enabled, name, titleMap, serviceContext);
    }

    public SAPEntry deleteSAPEntry(long sapEntryId) throws PortalException {
        _sapEntryFolderModelResourcePermission.check(this.getPermissionChecker(), sapEntryId, "DELETE");
        return this.sapEntryLocalService.deleteSAPEntry(sapEntryId);
    }

    public SAPEntry deleteSAPEntry(SAPEntry sapEntry) throws PortalException {
        _sapEntryFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)sapEntry, "DELETE");
        return this.sapEntryLocalService.deleteSAPEntry(sapEntry);
    }

    public SAPEntry fetchSAPEntry(long companyId, String name) throws PortalException {
        SAPEntry sapEntry = this.sapEntryPersistence.fetchByC_N(companyId, name);
        if (sapEntry != null) {
            _sapEntryFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)sapEntry, "VIEW");
        }
        return sapEntry;
    }

    public List<SAPEntry> getCompanySAPEntries(long companyId, int start, int end) {
        return this.sapEntryPersistence.filterFindByCompanyId(companyId, start, end);
    }

    public List<SAPEntry> getCompanySAPEntries(long companyId, int start, int end, OrderByComparator<SAPEntry> obc) {
        return this.sapEntryPersistence.filterFindByCompanyId(companyId, start, end, obc);
    }

    public int getCompanySAPEntriesCount(long companyId) {
        return this.sapEntryPersistence.filterCountByCompanyId(companyId);
    }

    public SAPEntry getSAPEntry(long sapEntryId) throws PortalException {
        _sapEntryFolderModelResourcePermission.check(this.getPermissionChecker(), sapEntryId, "VIEW");
        return this.sapEntryPersistence.findByPrimaryKey(sapEntryId);
    }

    public SAPEntry getSAPEntry(long companyId, String name) throws PortalException {
        SAPEntry sapEntry = this.sapEntryPersistence.findByC_N(companyId, name);
        _sapEntryFolderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)sapEntry, "VIEW");
        return sapEntry;
    }

    public SAPEntry updateSAPEntry(long sapEntryId, String allowedServiceSignatures, boolean defaultSAPEntry, boolean enabled, String name, Map<Locale, String> titleMap, ServiceContext serviceContext) throws PortalException {
        _sapEntryFolderModelResourcePermission.check(this.getPermissionChecker(), sapEntryId, "UPDATE");
        return this.sapEntryLocalService.updateSAPEntry(sapEntryId, allowedServiceSignatures, defaultSAPEntry, enabled, name, titleMap, serviceContext);
    }
}

