/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.service.access.policy.internal.verify;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import com.liferay.portal.verify.VerifyProcess;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"verify.process.name=com.liferay.portal.security.service.access.policy.service"}, service={VerifyProcess.class})
public class SAPServiceVerifyProcess
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(SAPServiceVerifyProcess.class);
    private CompanyLocalService _companyLocalService;
    private SAPEntryLocalService _sapEntryLocalService;

    protected void doVerify() throws Exception {
        this.verifyDefaultSAPEntry();
    }

    @Reference(unbind="-")
    protected void setCompanyLocalService(CompanyLocalService companyLocalService) {
        this._companyLocalService = companyLocalService;
    }

    @Reference(unbind="-")
    protected void setSAPEntryLocalService(SAPEntryLocalService sapEntryLocalService) {
        this._sapEntryLocalService = sapEntryLocalService;
    }

    protected void verifyDefaultSAPEntry() {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List companies = this._companyLocalService.getCompanies();
            for (Company company : companies) {
                try {
                    this._sapEntryLocalService.checkSystemSAPEntries(company.getCompanyId());
                }
                catch (PortalException pe) {
                    _log.error((Object)("Unable to add default service access policy for company " + company.getCompanyId()), (Throwable)pe);
                }
            }
        }
    }
}

