/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission.test.util;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.RoleTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.test.util.UserTestUtil;
import com.liferay.portal.service.test.ServiceTestUtil;
import java.util.Map;
import org.junit.After;
import org.junit.Before;

public abstract class BasePermissionTestCase {
    @DeleteAfterTestRun
    protected Group group;
    protected PermissionChecker permissionChecker;
    protected ServiceContext serviceContext;
    @DeleteAfterTestRun
    protected User user;

    @Before
    public void setUp() throws Exception {
        this.group = GroupTestUtil.addGroup();
        this.user = UserTestUtil.addUser();
        this.serviceContext = ServiceContextTestUtil.getServiceContext((long)this.group.getGroupId());
        this.doSetUp();
        ServiceTestUtil.setUser((User)this.user);
        this.permissionChecker = PermissionThreadLocal.getPermissionChecker();
        this.addPortletModelViewPermission();
    }

    @After
    public void tearDown() throws Exception {
        ServiceTestUtil.setUser((User)TestPropsValues.getUser());
        this.removePortletModelViewPermission();
    }

    protected void addPortletModelViewPermission() throws Exception {
        RoleTestUtil.addResourcePermission((String)this.getRoleName(), (String)this.getResourceName(), (int)2, (String)this.getPrimKey(), (String)"VIEW");
        Role role = RoleLocalServiceUtil.getRole((long)TestPropsValues.getCompanyId(), (String)this.getRoleName());
        ResourcePermissionLocalServiceUtil.setResourcePermissions((long)this.group.getCompanyId(), (String)this.getResourceName(), (int)4, (String)this.getPrimKey(), (long)role.getRoleId(), (String[])new String[]{"VIEW"});
    }

    protected abstract void doSetUp() throws Exception;

    protected String getPrimKey() {
        return String.valueOf(this.group.getGroupId());
    }

    protected abstract String getResourceName();

    protected String getRoleName() {
        return "Guest";
    }

    protected void removePortletModelViewPermission() throws Exception {
        RoleTestUtil.removeResourcePermission((String)this.getRoleName(), (String)this.getResourceName(), (int)2, (String)this.getPrimKey(), (String)"VIEW");
        RoleTestUtil.removeResourcePermission((String)this.getRoleName(), (String)this.getResourceName(), (int)4, (String)this.getPrimKey(), (String)"VIEW");
        Map permissionChecksMap = this.permissionChecker.getPermissionChecksMap();
        permissionChecksMap.clear();
    }
}

