/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.ldap.validator.LDAPFilterValidator;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class LDAPUtil {
    private static LDAPFilterValidator _ldapFilterValidator;

    public static Object getAttributeObject(Attributes attributes, Properties properties, String key) throws NamingException {
        String id = properties.getProperty(key);
        return LDAPUtil.getAttributeObject(attributes, id);
    }

    public static Object getAttributeObject(Attributes attributes, Properties properties, String key, Object defaultValue) throws NamingException {
        String id = properties.getProperty(key);
        return LDAPUtil.getAttributeObject(attributes, id, defaultValue);
    }

    public static Object getAttributeObject(Attributes attributes, String id) throws NamingException {
        return LDAPUtil.getAttributeObject(attributes, id, null);
    }

    public static Object getAttributeObject(Attributes attributes, String id, Object defaultValue) throws NamingException {
        if (Validator.isNull((String)id)) {
            return defaultValue;
        }
        Attribute attribute = attributes.get(id);
        if (attribute == null) {
            return defaultValue;
        }
        Object object = attribute.get();
        if (object == null) {
            return defaultValue;
        }
        return object;
    }

    public static String getAttributeString(Attributes attributes, Properties properties, String key) throws NamingException {
        String id = properties.getProperty(key);
        return LDAPUtil.getAttributeString(attributes, id);
    }

    public static String getAttributeString(Attributes attributes, Properties properties, String key, String defaultValue) throws NamingException {
        String id = properties.getProperty(key);
        return LDAPUtil.getAttributeString(attributes, id, defaultValue);
    }

    public static String getAttributeString(Attributes attributes, String id) throws NamingException {
        return LDAPUtil.getAttributeString(attributes, id, "");
    }

    public static String getAttributeString(Attributes attributes, String id, String defaultValue) throws NamingException {
        if (Validator.isNull((String)id)) {
            return defaultValue;
        }
        Attribute attribute = attributes.get(id);
        if (attribute == null) {
            return defaultValue;
        }
        Object object = attribute.get();
        if (object == null) {
            return defaultValue;
        }
        return object.toString();
    }

    public static String[] getAttributeStringArray(Attributes attributes, Properties properties, String key) throws NamingException {
        String id = properties.getProperty(key);
        return LDAPUtil.getAttributeStringArray(attributes, id);
    }

    public static String[] getAttributeStringArray(Attributes attributes, String id) throws NamingException {
        if (Validator.isNull((String)id)) {
            return null;
        }
        Attribute attribute = attributes.get(id);
        if (attribute == null) {
            return new String[0];
        }
        int size = attribute.size();
        if (size == 0) {
            return null;
        }
        String[] array = new String[size];
        for (int i = 0; i < size; ++i) {
            Object object = attribute.get(i);
            array[i] = object == null ? "" : object.toString();
        }
        return array;
    }

    public static String getFullProviderURL(String baseURL, String baseDN) {
        return baseURL + "/" + baseDN;
    }

    public static boolean isValidFilter(String filter) {
        return _ldapFilterValidator.isValid(filter);
    }

    public static Date parseDate(String date) throws Exception {
        if (Validator.isNull((String)date)) {
            return null;
        }
        String format = "yyyyMMddHHmmss";
        if (date.endsWith("Z")) {
            format = date.indexOf(46) != -1 ? "yyyyMMddHHmmss.S'Z'" : "yyyyMMddHHmmss'Z'";
        } else if (date.indexOf(45) != -1 || date.indexOf(43) != -1) {
            format = date.indexOf(46) != -1 ? "yyyyMMddHHmmss.SSSZ" : "yyyyMMddHHmmssZ";
        } else if (date.indexOf(46) != -1) {
            format = "yyyyMMddHHmmss.S";
        }
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)format);
        return dateFormat.parse(date);
    }

    public static void validateFilter(String filter) throws PortalException {
        _ldapFilterValidator.validate(filter);
    }

    public static void validateFilter(String filter, String filterPropertyName) throws PortalException {
        _ldapFilterValidator.validate(filter, filterPropertyName);
    }

    @Reference(unbind="-")
    protected void setLDAPFilterValidator(LDAPFilterValidator ldapFilterValidator) {
        _ldapFilterValidator = ldapFilterValidator;
    }
}

