/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.exportimport.LDAPUserImporter;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration;
import java.util.List;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={UserImportMessageListener.class})
public class UserImportMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(UserImportMessageListener.class);
    private CompanyLocalService _companyLocalService;
    private ConfigurationProvider<LDAPImportConfiguration> _ldapImportConfigurationProvider;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile LDAPUserImporter _ldapUserImporter;
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;

    @Activate
    @Modified
    protected void activate() {
        LDAPImportConfiguration ldapImportConfiguration = this._ldapImportConfigurationProvider.getConfiguration(0L);
        int interval = ldapImportConfiguration.importInterval();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("LDAP user imports will occur every " + interval + " minutes"));
        }
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String className = clazz.getName();
        Trigger trigger = this._triggerFactory.createTrigger(className, className, null, null, interval, TimeUnit.MINUTE);
        SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl(className, trigger);
        this._schedulerEngineHelper.register((MessageListener)this, (SchedulerEntry)schedulerEntry, "liferay/scheduled_user_ldap_import");
    }

    @Deactivate
    protected void deactivate() {
        this._schedulerEngineHelper.unregister((MessageListener)this);
    }

    protected void doReceive(Message message) throws Exception {
        long time = System.currentTimeMillis() - this._ldapUserImporter.getLastImportTime();
        time = Math.round((double)time / 60000.0);
        List companies = this._companyLocalService.getCompanies(false);
        for (Company company : companies) {
            long companyId = company.getCompanyId();
            LDAPImportConfiguration ldapImportConfiguration = this._ldapImportConfigurationProvider.getConfiguration(companyId);
            if (!ldapImportConfiguration.importEnabled()) continue;
            if (ldapImportConfiguration.importInterval() <= 0) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Skipping LDAP user import for company " + companyId));
                }
                return;
            }
            if (time < (long)ldapImportConfiguration.importInterval()) continue;
            this._ldapUserImporter.importUsers(companyId);
        }
    }

    @Reference(unbind="-")
    protected void setCompanyLocalService(CompanyLocalService companyLocalService) {
        this._companyLocalService = companyLocalService;
    }

    @Reference(target="(destination.name=liferay/scheduled_user_ldap_import)", unbind="-")
    protected void setDestination(Destination destination) {
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration)", unbind="-")
    protected void setLDAPImportConfigurationProvider(ConfigurationProvider<LDAPImportConfiguration> ldapImportConfigurationProvider) {
        this._ldapImportConfigurationProvider = ldapImportConfigurationProvider;
    }

    @Reference(unbind="-")
    protected void setSchedulerEngineHelper(SchedulerEngineHelper schedulerEngineHelper) {
        this._schedulerEngineHelper = schedulerEngineHelper;
    }
}

