/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.ldap.LDAPSettings;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.security.exportimport.UserExporter;
import com.liferay.portal.security.ldap.internal.UserImportTransactionThreadLocal;
import com.liferay.portal.security.ldap.internal.model.listener.BaseLDAPExportModelListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={ModelListener.class})
public class ContactModelListener
extends BaseLDAPExportModelListener<Contact> {
    private static final Log _log = LogFactoryUtil.getLog(ContactModelListener.class);
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private LDAPSettings _ldapSettings;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private UserExporter _userExporter;
    @Reference
    private UserLocalService _userLocalService;

    public void onAfterCreate(Contact contact) throws ModelListenerException {
        try {
            this.exportToLDAP(contact);
        }
        catch (Exception e) {
            throw new ModelListenerException("Unable to export contact with user ID " + contact.getUserId() + " to LDAP on after create", (Throwable)e);
        }
    }

    public void onAfterUpdate(Contact contact) throws ModelListenerException {
        try {
            this.exportToLDAP(contact);
        }
        catch (Exception e) {
            throw new ModelListenerException("Unable to export contact with user ID " + contact.getUserId() + " to LDAP on after update", (Throwable)e);
        }
    }

    protected void exportToLDAP(Contact contact) throws Exception {
        if (UserImportTransactionThreadLocal.isOriginatesFromImport()) {
            return;
        }
        User user = this._userLocalService.fetchUser(contact.getUserId());
        this.exportToLDAP(user, this._userExporter, this._ldapSettings);
    }
}

