/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.exportimport;

import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.exception.UserScreenNameException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.ContactConstants;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.FullNameDefinition;
import com.liferay.portal.kernel.security.auth.FullNameDefinitionFactory;
import com.liferay.portal.kernel.security.auth.FullNameGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.kernel.service.ListTypeService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.persistence.ContactPersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.ldap.exportimport.LDAPGroup;
import com.liferay.portal.security.ldap.exportimport.LDAPToPortalConverter;
import com.liferay.portal.security.ldap.exportimport.LDAPUser;
import com.liferay.portal.security.ldap.util.LDAPUtil;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={LDAPToPortalConverter.class})
public class DefaultLDAPToPortalConverter
implements LDAPToPortalConverter {
    private static final Log _log = LogFactoryUtil.getLog(DefaultLDAPToPortalConverter.class);
    private ContactPersistence _contactPersistence;
    private ListTypeService _listTypeService;
    private UserPersistence _userPersistence;

    @Override
    public LDAPGroup importLDAPGroup(long companyId, Attributes attributes, Properties groupMappings) throws Exception {
        LDAPGroup ldapGroup = new LDAPGroup();
        ldapGroup.setCompanyId(companyId);
        String description = LDAPUtil.getAttributeString(attributes, groupMappings, "description");
        ldapGroup.setDescription(description);
        String groupName = LDAPUtil.getAttributeString(attributes, groupMappings, "groupName");
        ldapGroup.setGroupName(groupName);
        return ldapGroup;
    }

    @Override
    public LDAPUser importLDAPUser(long companyId, Attributes attributes, Properties userMappings, Properties userExpandoMappings, Properties contactMappings, Properties contactExpandoMappings, String password) throws Exception {
        boolean autoScreenName = PrefsPropsUtil.getBoolean((long)companyId, (String)"users.screen.name.always.autogenerate");
        String screenName = StringUtil.toLowerCase((String)LDAPUtil.getAttributeString(attributes, userMappings, "screenName"));
        String emailAddress = LDAPUtil.getAttributeString(attributes, userMappings, "emailAddress");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Screen name ", screenName, " and email address ", emailAddress}));
        }
        String firstName = LDAPUtil.getAttributeString(attributes, userMappings, "firstName");
        String middleName = LDAPUtil.getAttributeString(attributes, userMappings, "middleName");
        String lastName = LDAPUtil.getAttributeString(attributes, userMappings, "lastName");
        FullNameDefinition fullNameDefinition = FullNameDefinitionFactory.getInstance((Locale)LocaleUtil.getDefault());
        if (Validator.isNull((String)firstName) || fullNameDefinition.isFieldRequired("last-name") && Validator.isNull((String)lastName)) {
            String fullName = LDAPUtil.getAttributeString(attributes, userMappings, "fullName");
            FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
            String[] names = fullNameGenerator.splitFullName(fullName);
            if (Validator.isNull((String)firstName)) {
                firstName = names[0];
            }
            if (Validator.isNull((String)middleName)) {
                middleName = names[1];
            }
            if (Validator.isNull((String)lastName)) {
                lastName = names[2];
            }
        }
        if (!autoScreenName && Validator.isNull((String)screenName)) {
            throw new UserScreenNameException.MustNotBeNull(ContactConstants.getFullName((String)firstName, (String)middleName, (String)lastName));
        }
        if (Validator.isNull((String)emailAddress) && PrefsPropsUtil.getBoolean((long)companyId, (String)"users.email.address.required")) {
            throw new UserEmailAddressException.MustNotBeNull(ContactConstants.getFullName((String)firstName, (String)middleName, (String)lastName));
        }
        LDAPUser ldapUser = new LDAPUser();
        ldapUser.setAutoPassword(password == null);
        ldapUser.setAutoScreenName(autoScreenName);
        Contact contact = this._contactPersistence.create(0L);
        long prefixId = this.getListTypeId(attributes, contactMappings, "prefix", ListTypeConstants.CONTACT_PREFIX);
        contact.setPrefixId(prefixId);
        long suffixId = this.getListTypeId(attributes, contactMappings, "suffix", ListTypeConstants.CONTACT_SUFFIX);
        contact.setSuffixId(suffixId);
        String gender = LDAPUtil.getAttributeString(attributes, contactMappings, "gender");
        gender = StringUtil.toLowerCase((String)gender);
        if (Validator.isNull((String)gender) || GetterUtil.getBoolean((String)gender) || gender.equals("m") || gender.equals("male")) {
            contact.setMale(true);
        } else {
            contact.setMale(false);
        }
        try {
            Date birthday = DateUtil.parseDate((String)LDAPUtil.getAttributeString(attributes, contactMappings, "birthday"), (Locale)LocaleUtil.getDefault());
            contact.setBirthday(birthday);
        }
        catch (ParseException pe) {
            Calendar birthdayCalendar = CalendarFactoryUtil.getCalendar((int)1970, (int)0, (int)1);
            contact.setBirthday(birthdayCalendar.getTime());
        }
        contact.setSmsSn(LDAPUtil.getAttributeString(attributes, contactMappings, "smsSn"));
        contact.setFacebookSn(LDAPUtil.getAttributeString(attributes, contactMappings, "facebookSn"));
        contact.setJabberSn(LDAPUtil.getAttributeString(attributes, contactMappings, "jabberSn"));
        contact.setSkypeSn(LDAPUtil.getAttributeString(attributes, contactMappings, "skypeSn"));
        contact.setTwitterSn(LDAPUtil.getAttributeString(attributes, contactMappings, "twitterSn"));
        contact.setJobTitle(LDAPUtil.getAttributeString(attributes, contactMappings, "jobTitle"));
        ldapUser.setContact(contact);
        Map<String, String[]> contactExpandoAttributes = this.getExpandoAttributes(attributes, contactExpandoMappings);
        ldapUser.setContactExpandoAttributes(contactExpandoAttributes);
        ldapUser.setCreatorUserId(0L);
        ldapUser.setGroupIds(null);
        ldapUser.setOrganizationIds(null);
        ldapUser.setPasswordReset(false);
        String portrait = userMappings.getProperty("portrait");
        if (Validator.isNotNull((String)portrait)) {
            Object portraitObject = LDAPUtil.getAttributeObject(attributes, portrait);
            if (portraitObject != null) {
                byte[] portraitBytes = (byte[])portraitObject;
                if (portraitBytes.length > 0) {
                    ldapUser.setPortraitBytes((byte[])portraitObject);
                }
                ldapUser.setUpdatePortrait(true);
            }
        } else {
            ldapUser.setUpdatePortrait(true);
        }
        ldapUser.setRoleIds(null);
        ldapUser.setSendEmail(false);
        ServiceContext serviceContext = new ServiceContext();
        String uuid = LDAPUtil.getAttributeString(attributes, userMappings, "uuid");
        serviceContext.setUuid(uuid);
        ldapUser.setServiceContext(serviceContext);
        ldapUser.setUpdatePassword(password != null);
        User user = this._userPersistence.create(0L);
        user.setCompanyId(companyId);
        user.setEmailAddress(emailAddress);
        user.setFirstName(firstName);
        String jobTitle = LDAPUtil.getAttributeString(attributes, userMappings, "jobTitle");
        user.setJobTitle(jobTitle);
        Locale locale = LocaleUtil.getDefault();
        user.setLanguageId(locale.toString());
        user.setLastName(lastName);
        user.setMiddleName(middleName);
        user.setOpenId("");
        user.setPasswordUnencrypted(password);
        user.setScreenName(screenName);
        String status = LDAPUtil.getAttributeString(attributes, userMappings, "status");
        if (Validator.isNotNull((String)status)) {
            user.setStatus(GetterUtil.getInteger((String)status));
        }
        ldapUser.setUser(user);
        Map<String, String[]> userExpandoAttributes = this.getExpandoAttributes(attributes, userExpandoMappings);
        ldapUser.setUserExpandoAttributes(userExpandoAttributes);
        ldapUser.setUserGroupIds(null);
        ldapUser.setUserGroupRoles(null);
        return ldapUser;
    }

    protected Map<String, String[]> getExpandoAttributes(Attributes attributes, Properties expandoMappings) throws NamingException {
        HashMap<String, String[]> expandoAttributes = new HashMap<String, String[]>();
        for (Object key : expandoMappings.keySet()) {
            String name = (String)key;
            String[] value = LDAPUtil.getAttributeStringArray(attributes, expandoMappings, name);
            if (value == null) continue;
            expandoAttributes.put(name, value);
        }
        return expandoAttributes;
    }

    protected long getListTypeId(Attributes attributes, Properties contactMappings, String contactMappingsKey, String listTypeType) throws Exception {
        List contactPrefixListTypes = this._listTypeService.getListTypes(listTypeType);
        String name = LDAPUtil.getAttributeString(attributes, contactMappings, contactMappingsKey);
        for (ListType listType : contactPrefixListTypes) {
            if (!name.equals(listType.getName())) continue;
            return listType.getListTypeId();
        }
        return 0L;
    }

    @Reference(unbind="-")
    protected void setContactPersistence(ContactPersistence contactPersistence) {
        this._contactPersistence = contactPersistence;
    }

    @Reference(unbind="-")
    protected void setListTypeService(ListTypeService listTypeService) {
        this._listTypeService = listTypeService;
    }

    @Reference(unbind="-")
    protected void setUserPersistence(UserPersistence userPersistence) {
        this._userPersistence = userPersistence;
    }
}

