/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.configuration;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.security.ldap.configuration.BaseConfigurationProvider;
import com.liferay.portal.security.ldap.configuration.CompanyScopedConfiguration;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import java.io.IOException;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.cm.Configuration;

public abstract class CompanyScopedConfigurationProvider<T extends CompanyScopedConfiguration>
extends BaseConfigurationProvider<T>
implements ConfigurationProvider<T> {
    private static final Log _log = LogFactoryUtil.getLog(CompanyScopedConfigurationProvider.class);
    private final Map<Long, ObjectValuePair<Configuration, T>> _configurations = new HashMap<Long, ObjectValuePair<Configuration, T>>();
    private final T _defaultConfiguration = (CompanyScopedConfiguration)ConfigurableUtil.createConfigurable(this.getMetatype(), Collections.emptyMap());

    @Override
    public boolean delete(long companyId) {
        ObjectValuePair<Configuration, T> objectValuePair = this._configurations.remove(companyId);
        if (objectValuePair == null) {
            return false;
        }
        Configuration configuration = (Configuration)objectValuePair.getKey();
        try {
            Dictionary properties = configuration.getProperties();
            configuration.delete();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Deleted configuration ", this.getMetatypeId(), " for company ", String.valueOf(companyId), " with properties: ", String.valueOf(properties)}));
            }
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        return true;
    }

    @Override
    public boolean delete(long companyId, long index) {
        return this.delete(companyId);
    }

    @Override
    public T getConfiguration(long companyId) {
        ObjectValuePair<Configuration, T> objectValuePair = this._configurations.get(companyId);
        if (objectValuePair == null) {
            objectValuePair = this._configurations.get(0L);
        }
        if (objectValuePair == null) {
            return this._defaultConfiguration;
        }
        return (T)((CompanyScopedConfiguration)objectValuePair.getValue());
    }

    @Override
    public T getConfiguration(long companyId, long index) {
        return (T)this.getConfiguration(companyId);
    }

    @Override
    public Dictionary<String, Object> getConfigurationProperties(long companyId) {
        ObjectValuePair<Configuration, T> objectValuePair = this._configurations.get(companyId);
        if (objectValuePair == null) {
            objectValuePair = this._configurations.get(0L);
        }
        if (objectValuePair == null) {
            return new HashMapDictionary();
        }
        Configuration configuration = (Configuration)objectValuePair.getKey();
        return configuration.getProperties();
    }

    @Override
    public Dictionary<String, Object> getConfigurationProperties(long companyId, long index) {
        return this.getConfigurationProperties(companyId);
    }

    @Override
    public List<T> getConfigurations(long companyId) {
        return this.getConfigurations(companyId, true);
    }

    @Override
    public List<T> getConfigurations(long companyId, boolean useDefault) {
        ObjectValuePair<Configuration, T> objectValuePair = this._configurations.get(companyId);
        if (objectValuePair == null && useDefault) {
            objectValuePair = this._configurations.get(0L);
        }
        if (objectValuePair == null && useDefault) {
            return Collections.singletonList(this._defaultConfiguration);
        }
        if (objectValuePair != null) {
            return Collections.singletonList(objectValuePair.getValue());
        }
        return Collections.emptyList();
    }

    @Override
    public List<Dictionary<String, Object>> getConfigurationsProperties(long companyId) {
        return this.getConfigurationsProperties(companyId, true);
    }

    @Override
    public List<Dictionary<String, Object>> getConfigurationsProperties(long companyId, boolean useDefault) {
        ObjectValuePair<Configuration, T> objectValuePair = this._configurations.get(companyId);
        if (objectValuePair == null && useDefault) {
            objectValuePair = this._configurations.get(0L);
        }
        if (objectValuePair == null && useDefault) {
            return Collections.singletonList(new HashMapDictionary());
        }
        if (objectValuePair != null) {
            Configuration configuration = (Configuration)objectValuePair.getKey();
            return Collections.singletonList(configuration.getProperties());
        }
        return Collections.emptyList();
    }

    @Override
    public synchronized void registerConfiguration(Configuration configuration) {
        Dictionary properties = configuration.getProperties();
        if (properties == null) {
            properties = new HashMapDictionary();
        }
        CompanyScopedConfiguration configurable = (CompanyScopedConfiguration)ConfigurableUtil.createConfigurable(this.getMetatype(), (Dictionary)properties);
        this._configurations.put(configurable.companyId(), new ObjectValuePair((Object)configuration, (Object)configurable));
    }

    @Override
    public synchronized void unregisterConfiguration(Configuration configuration) {
        Dictionary properties = configuration.getProperties();
        if (properties == null) {
            properties = new HashMapDictionary();
        }
        CompanyScopedConfiguration configurable = (CompanyScopedConfiguration)ConfigurableUtil.createConfigurable(this.getMetatype(), (Dictionary)properties);
        this._configurations.remove(configurable.companyId());
    }

    @Override
    public void updateProperties(long companyId, Dictionary<String, Object> properties) {
        if (properties == null) {
            properties = new HashMapDictionary();
        }
        properties.put("companyId", companyId);
        ObjectValuePair<Configuration, T> objectValuePair = this._configurations.get(companyId);
        try {
            Configuration configuration = null;
            configuration = objectValuePair == null ? this.configurationAdmin.createFactoryConfiguration(this.getMetatypeId(), "?") : (Configuration)objectValuePair.getKey();
            configuration.update((Dictionary)properties);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Updated configuration ", this.getMetatypeId(), " for company ", String.valueOf(companyId), " with properties: ", String.valueOf(properties)}));
            }
        }
        catch (IOException ioe) {
            throw new SystemException("Unable to update configuration", (Throwable)ioe);
        }
    }

    @Override
    public void updateProperties(long companyId, long index, Dictionary<String, Object> properties) {
        this.updateProperties(companyId, properties);
    }
}

