/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.MembershipRequest;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.MembershipRequestLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.exportimport.UserExporter;
import com.liferay.portal.security.ldap.internal.UserImportTransactionThreadLocal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class UserModelListener
extends BaseModelListener<User> {
    private static final Log _log = LogFactoryUtil.getLog(UserModelListener.class);
    @Reference
    private MembershipRequestLocalService _membershipRequestLocalService;
    @Reference
    private UserExporter _userExporter;
    @Reference
    private UserLocalService _userLocalService;

    public void onAfterAddAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        try {
            if (associationClassName.equals(Group.class.getName())) {
                long userId = (Long)classPK;
                long groupId = (Long)associationClassPK;
                this.updateMembershipRequestStatus(userId, groupId);
            }
        }
        catch (Exception e) {
            throw new ModelListenerException((Throwable)e);
        }
    }

    public void onAfterCreate(User user) {
        try {
            this.exportToLDAP(user);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to export user " + user.getUserId() + " to LDAP on after create"), (Throwable)e);
        }
    }

    public void onAfterUpdate(User user) {
        try {
            this.exportToLDAP(user);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to export user " + user.getUserId() + " to LDAP on after update"), (Throwable)e);
        }
    }

    public void onBeforeUpdate(User user) {
        UserImportTransactionThreadLocal.setOriginalEmailAddress(user.getOriginalEmailAddress());
    }

    protected void exportToLDAP(User user) throws Exception {
        if (user.isDefaultUser() || UserImportTransactionThreadLocal.isOriginatesFromImport()) {
            return;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Map expandoBridgeAttributes = null;
        if (serviceContext != null) {
            expandoBridgeAttributes = serviceContext.getExpandoBridgeAttributes();
        }
        this._userExporter.exportUser(user, expandoBridgeAttributes);
    }

    protected void updateMembershipRequestStatus(long userId, long groupId) throws Exception {
        long principalUserId = GetterUtil.getLong((String)PrincipalThreadLocal.getName());
        User user = this._userLocalService.getUser(userId);
        List membershipRequests = this._membershipRequestLocalService.getMembershipRequests(userId, groupId, 0L);
        for (MembershipRequest membershipRequest : membershipRequests) {
            this._membershipRequestLocalService.updateStatus(principalUserId, membershipRequest.getMembershipRequestId(), LanguageUtil.get((Locale)user.getLocale(), (String)"your-membership-has-been-approved"), 1L, false, new ServiceContext());
        }
    }
}

