/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.model.listener;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.security.exportimport.UserExporter;
import com.liferay.portal.security.exportimport.UserOperation;
import com.liferay.portal.security.ldap.internal.UserImportTransactionThreadLocal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class UserGroupModelListener
extends BaseModelListener<UserGroup> {
    private static final Log _log = LogFactoryUtil.getLog(UserGroupModelListener.class);
    @Reference
    private UserExporter _userExporter;

    public void onAfterAddAssociation(Object userGroupId, String associationClassName, Object associationClassPK) {
        try {
            if (associationClassName.equals(User.class.getName())) {
                this.exportToLDAP((Long)associationClassPK, (Long)userGroupId, UserOperation.ADD);
            }
        }
        catch (Exception e) {
            _log.error((Object)("Unable to export user group with user ID " + associationClassPK + " to LDAP on after add association"), (Throwable)e);
        }
    }

    public void onAfterRemoveAssociation(Object userGroupId, String associationClassName, Object associationClassPK) {
        try {
            if (associationClassName.equals(User.class.getName())) {
                this.exportToLDAP((Long)associationClassPK, (Long)userGroupId, UserOperation.REMOVE);
            }
        }
        catch (Exception e) {
            _log.error((Object)("Unable to export user group with user ID " + associationClassPK + " to LDAP on after remove association"), (Throwable)e);
        }
    }

    protected void exportToLDAP(long userId, long userGroupId, UserOperation userOperation) throws Exception {
        if (UserImportTransactionThreadLocal.isOriginatesFromImport()) {
            return;
        }
        this._userExporter.exportUser(userId, userGroupId, userOperation);
        if (_log.isDebugEnabled() && _log.isDebugEnabled()) {
            _log.debug((Object)("Exporting user " + userId + " to user group " + userGroupId + " with user operation " + userOperation.name()));
        }
    }
}

