/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.model.listener;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.security.exportimport.UserExporter;
import com.liferay.portal.security.ldap.internal.UserImportTransactionThreadLocal;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class ContactModelListener
extends BaseModelListener<Contact> {
    private static final Log _log = LogFactoryUtil.getLog(ContactModelListener.class);
    @Reference
    private UserExporter _userExporter;
    @Reference
    private UserLocalService _userLocalService;

    public void onAfterCreate(Contact contact) {
        try {
            this.exportToLDAP(contact);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to export contact with user ID " + contact.getUserId() + " to LDAP on after create"), (Throwable)e);
        }
    }

    public void onAfterUpdate(Contact contact) {
        try {
            this.exportToLDAP(contact);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to export contact with user ID " + contact.getUserId() + " to LDAP on after update"), (Throwable)e);
        }
    }

    protected void exportToLDAP(Contact contact) throws Exception {
        if (UserImportTransactionThreadLocal.isOriginatesFromImport()) {
            return;
        }
        User user = this._userLocalService.fetchUser(contact.getUserId());
        if (user == null || user.isDefaultUser()) {
            return;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Map expandoBridgeAttributes = null;
        if (serviceContext != null) {
            expandoBridgeAttributes = serviceContext.getExpandoBridgeAttributes();
        }
        this._userExporter.exportUser(contact, expandoBridgeAttributes);
    }
}

