/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.messaging;

import com.liferay.portal.kernel.messaging.BaseSchedulerEntryMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.scheduler.TriggerFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.exportimport.LDAPUserImporter;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration;
import java.util.List;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={UserImportMessageListener.class})
public class UserImportMessageListener
extends BaseSchedulerEntryMessageListener {
    private CompanyLocalService _companyLocalService;
    private ConfigurationProvider<LDAPImportConfiguration> _ldapImportConfigurationProvider;
    private LDAPUserImporter _ldapUserImporter;
    private SchedulerEngineHelper _schedulerEngineHelper;

    @Activate
    @Modified
    protected void activate() {
        LDAPImportConfiguration ldapImportConfiguration = this._ldapImportConfigurationProvider.getConfiguration(0L);
        int interval = ldapImportConfiguration.importInterval();
        this.schedulerEntryImpl.setTrigger(TriggerFactoryUtil.createTrigger((String)this.getEventListenerClass(), (String)this.getEventListenerClass(), (int)interval, (TimeUnit)TimeUnit.MINUTE));
        this._schedulerEngineHelper.register((MessageListener)this, (SchedulerEntry)this.schedulerEntryImpl, "liferay/scheduled_user_ldap_import");
    }

    @Deactivate
    protected void deactivate() {
        this._schedulerEngineHelper.unregister((MessageListener)this);
    }

    protected void doReceive(Message message) throws Exception {
        long time = System.currentTimeMillis() - this._ldapUserImporter.getLastImportTime();
        time = Math.round((double)time / 60000.0);
        List companies = this._companyLocalService.getCompanies(false);
        for (Company company : companies) {
            long companyId = company.getCompanyId();
            LDAPImportConfiguration ldapImportConfiguration = this._ldapImportConfigurationProvider.getConfiguration(companyId);
            if (!ldapImportConfiguration.importEnabled() || time < (long)ldapImportConfiguration.importInterval()) continue;
            this._ldapUserImporter.importUsers(companyId);
        }
    }

    @Reference(unbind="-")
    protected void setCompanyLocalService(CompanyLocalService companyLocalService) {
        this._companyLocalService = companyLocalService;
    }

    @Reference(target="(destination.name=liferay/scheduled_user_ldap_import)", unbind="-")
    protected void setDestination(Destination destination) {
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration)", unbind="-")
    protected void setLDAPImportConfigurationProvider(ConfigurationProvider<LDAPImportConfiguration> ldapImportConfigurationProvider) {
        this._ldapImportConfigurationProvider = ldapImportConfigurationProvider;
    }

    @Reference(unbind="-")
    protected void setLdapUserImporter(LDAPUserImporter ldapUserImporter) {
        this._ldapUserImporter = ldapUserImporter;
    }

    @Reference(unbind="-")
    protected void setSchedulerEngineHelper(SchedulerEngineHelper schedulerEngineHelper) {
        this._schedulerEngineHelper = schedulerEngineHelper;
    }

    @Reference(unbind="-")
    protected void setTriggerFactory(TriggerFactory triggerFactory) {
    }
}

