/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.exportimport;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.service.ExpandoValueLocalService;
import com.liferay.expando.kernel.util.ExpandoConverterUtil;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPool;
import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.exception.NoSuchUserGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.exportimport.UserGroupImportTransactionThreadLocal;
import com.liferay.portal.kernel.security.ldap.AttributesTransformer;
import com.liferay.portal.kernel.security.ldap.LDAPSettings;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.exportimport.UserImporter;
import com.liferay.portal.security.ldap.PortalLDAP;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration;
import com.liferay.portal.security.ldap.exportimport.LDAPGroup;
import com.liferay.portal.security.ldap.exportimport.LDAPToPortalConverter;
import com.liferay.portal.security.ldap.exportimport.LDAPUser;
import com.liferay.portal.security.ldap.exportimport.LDAPUserImporter;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration;
import com.liferay.portal.security.ldap.internal.UserImportTransactionThreadLocal;
import com.liferay.portal.security.ldap.util.LDAPUtil;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={LDAPUserImporter.class, UserImporter.class})
public class LDAPUserImporterImpl
implements LDAPUserImporter,
UserImporter {
    private static final String[] _CONTACT_PROPERTY_NAMES = new String[]{"birthday", "employeeNumber", "facebookSn", "jabberSn", "male", "prefixId", "skypeSn", "smsSn", "suffixId", "twitterSn"};
    private static final String _IMPORT_BY_GROUP = "group";
    private static final String _IMPORT_BY_USER = "user";
    private static final String _USER_PASSWORD_SCREEN_NAME = "screenName";
    private static final String[] _USER_PROPERTY_NAMES = new String[]{"comments", "emailAddress", "firstName", "greeting", "jobTitle", "languageId", "lastName", "middleName", "openId", "portraitId", "timeZoneId"};
    private static final String _USER_SYNC_STRATEGY_UUID = "uuid";
    private static final Log _log = LogFactoryUtil.getLog(LDAPUserImporterImpl.class);
    private AttributesTransformer _attributesTransformer;
    private CompanyLocalService _companyLocalService;
    private String _companySecurityAuthType;
    private ExpandoValueLocalService _expandoValueLocalService;
    private GroupLocalService _groupLocalService;
    private long _lastImportTime;
    private ConfigurationProvider<LDAPImportConfiguration> _ldapImportConfigurationProvider;
    private ConfigurationProvider<LDAPServerConfiguration> _ldapServerConfigurationProvider;
    private LDAPSettings _ldapSettings;
    private LDAPToPortalConverter _ldapToPortalConverter;
    private LockManager _lockManager;
    private PortalCache<String, Long> _portalCache;
    private PortalLDAP _portalLDAP;
    private RoleLocalService _roleLocalService;
    private UserGroupLocalService _userGroupLocalService;
    private UserLocalService _userLocalService;

    public long getLastImportTime() {
        return this._lastImportTime;
    }

    @Override
    public User importUser(long ldapServerId, long companyId, LdapContext ldapContext, Attributes attributes, String password) throws Exception {
        Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
        Properties userExpandoMappings = this._ldapSettings.getUserExpandoMappings(ldapServerId, companyId);
        Properties contactMappings = this._ldapSettings.getContactMappings(ldapServerId, companyId);
        Properties contactExpandoMappings = this._ldapSettings.getContactExpandoMappings(ldapServerId, companyId);
        LDAPServerConfiguration ldapServerConfiguration = this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        String[] userIgnoreAttributes = ldapServerConfiguration.userIgnoreAttributes();
        HashSet<String> ldapUserIgnoreAttributes = new HashSet<String>(Arrays.asList(userIgnoreAttributes));
        User user = this.importUser(ldapServerId, companyId, attributes, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, password, ldapUserIgnoreAttributes);
        Properties groupMappings = this._ldapSettings.getGroupMappings(ldapServerId, companyId);
        this.importGroups(ldapServerId, companyId, ldapContext, attributes, user, userMappings, groupMappings);
        return user;
    }

    public User importUser(long ldapServerId, long companyId, String emailAddress, String screenName) throws Exception {
        Context ldapContext = null;
        NamingEnumeration<SearchResult> enu = null;
        try {
            LDAPServerConfiguration ldapServerConfiguration = this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
            String baseDN = ldapServerConfiguration.baseDN();
            ldapContext = this._portalLDAP.getContext(ldapServerId, companyId);
            if (ldapContext == null) {
                _log.error((Object)"Unable to bind to the LDAP server");
                User user = null;
                return user;
            }
            String filter = ldapServerConfiguration.authSearchFilter();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Search filter before transformation " + filter));
            }
            filter = StringUtil.replace((String)filter, (String[])new String[]{"@company_id@", "@email_address@", "@screen_name@"}, (String[])new String[]{String.valueOf(companyId), emailAddress, screenName});
            LDAPUtil.validateFilter(filter);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Search filter after transformation " + filter));
            }
            Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
            String userMappingsScreenName = GetterUtil.getString((String)userMappings.getProperty(_USER_PASSWORD_SCREEN_NAME));
            userMappingsScreenName = StringUtil.toLowerCase((String)userMappingsScreenName);
            SearchControls searchControls = new SearchControls(2, 1L, 0, new String[]{userMappingsScreenName}, false, false);
            enu = ldapContext.search(baseDN, filter, searchControls);
            if (enu.hasMoreElements()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Search filter returned at least one result");
                }
                Binding binding = (Binding)enu.nextElement();
                Attributes attributes = this._portalLDAP.getUserAttributes(ldapServerId, companyId, (LdapContext)ldapContext, this._portalLDAP.getNameInNamespace(ldapServerId, companyId, binding));
                User user = this.importUser(ldapServerId, companyId, (LdapContext)ldapContext, attributes, "");
                return user;
            }
            User user = null;
            return user;
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Problem accessing LDAP server " + e.getMessage()));
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            throw new SystemException("Problem accessing LDAP server " + e.getMessage());
        }
        finally {
            if (enu != null) {
                enu.close();
            }
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
    }

    public User importUser(long companyId, String emailAddress, String screenName) throws Exception {
        List<LDAPServerConfiguration> ldapServerConfigurations = this._ldapServerConfigurationProvider.getConfigurations(companyId);
        for (LDAPServerConfiguration ldapServerConfiguration : ldapServerConfigurations) {
            String providerUrl = ldapServerConfiguration.baseProviderURL();
            if (Validator.isNull((String)providerUrl)) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("No provider URL defined in " + ldapServerConfiguration));
                continue;
            }
            User user = this.importUser(ldapServerConfiguration.ldapServerId(), companyId, emailAddress, screenName);
            if (user == null) continue;
            return user;
        }
        if (_log.isDebugEnabled()) {
            if (Validator.isNotNull((String)emailAddress)) {
                _log.debug((Object)("User with the email address " + emailAddress + " was not found in any LDAP servers"));
            } else {
                _log.debug((Object)("User with the screen name " + screenName + " was not found in any LDAP servers"));
            }
        }
        return null;
    }

    public User importUserByScreenName(long companyId, String screenName) throws Exception {
        long ldapServerId = this._portalLDAP.getLdapServerId(companyId, screenName, "");
        SearchResult result = (SearchResult)this._portalLDAP.getUser(ldapServerId, companyId, screenName, "");
        if (result == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No user was found in LDAP with screenName " + screenName));
            }
            return null;
        }
        LdapContext ldapContext = this._portalLDAP.getContext(ldapServerId, companyId);
        String fullUserDN = this._portalLDAP.getNameInNamespace(ldapServerId, companyId, result);
        Attributes attributes = this._portalLDAP.getUserAttributes(ldapServerId, companyId, ldapContext, fullUserDN);
        User user = this.importUser(ldapServerId, companyId, ldapContext, attributes, "");
        ldapContext.close();
        return user;
    }

    public void importUsers() throws Exception {
        List companies = this._companyLocalService.getCompanies(false);
        for (Company company : companies) {
            this.importUsers(company.getCompanyId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importUsers(long companyId) throws Exception {
        if (!this._ldapSettings.isImportEnabled(companyId)) {
            return;
        }
        try {
            long defaultUserId = this._userLocalService.getDefaultUserId(companyId);
            if (this._lockManager.hasLock(defaultUserId, UserImporter.class.getName(), companyId)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Skipping LDAP import for company " + companyId + " because another LDAP import is in process"));
                }
                return;
            }
            LDAPImportConfiguration ldapImportConfiguration = this._ldapImportConfigurationProvider.getConfiguration(companyId);
            this._lockManager.lock(defaultUserId, UserImporter.class.getName(), companyId, LDAPUserImporterImpl.class.getName(), false, ldapImportConfiguration.importLockExpirationTime());
            List<LDAPServerConfiguration> ldapServerConfigurations = this._ldapServerConfigurationProvider.getConfigurations(companyId);
            for (LDAPServerConfiguration ldapServerConfiguration : ldapServerConfigurations) {
                this.importUsers(ldapServerConfiguration.ldapServerId(), companyId);
            }
        }
        finally {
            this._lockManager.unlock(UserImporter.class.getName(), companyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importUsers(long ldapServerId, long companyId) throws Exception {
        if (!this._ldapSettings.isImportEnabled(companyId)) {
            return;
        }
        LdapContext ldapContext = this._portalLDAP.getContext(ldapServerId, companyId);
        if (ldapContext == null) {
            return;
        }
        this._lastImportTime = System.currentTimeMillis();
        LDAPImportConfiguration ldapImportConfiguration = this._ldapImportConfigurationProvider.getConfiguration(companyId);
        LDAPServerConfiguration ldapServerConfiguration = this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        String[] userIgnoreAttributes = ldapServerConfiguration.userIgnoreAttributes();
        HashSet<String> ldapUserIgnoreAttributes = new HashSet<String>(Arrays.asList(userIgnoreAttributes));
        try {
            Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
            Properties userExpandoMappings = this._ldapSettings.getUserExpandoMappings(ldapServerId, companyId);
            Properties contactMappings = this._ldapSettings.getContactMappings(ldapServerId, companyId);
            Properties contactExpandoMappings = this._ldapSettings.getContactExpandoMappings(ldapServerId, companyId);
            Properties groupMappings = this._ldapSettings.getGroupMappings(ldapServerId, companyId);
            String importMethod = ldapImportConfiguration.importMethod();
            if (importMethod.equals(_IMPORT_BY_GROUP)) {
                this.importFromLDAPByGroup(ldapServerId, companyId, ldapContext, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, groupMappings, ldapUserIgnoreAttributes);
            } else if (importMethod.equals(_IMPORT_BY_USER)) {
                this.importFromLDAPByUser(ldapServerId, companyId, ldapContext, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, groupMappings, ldapUserIgnoreAttributes);
            }
        }
        catch (Exception e) {
            _log.error((Object)"Unable to import LDAP users and groups", (Throwable)e);
        }
        finally {
            ldapContext.close();
        }
    }

    @Reference(unbind="-")
    public void setAttributesTransformer(AttributesTransformer attributesTransformer) {
        this._attributesTransformer = attributesTransformer;
    }

    @Reference(unbind="-")
    public void setLDAPToPortalConverter(LDAPToPortalConverter ldapToPortalConverter) {
        this._ldapToPortalConverter = ldapToPortalConverter;
    }

    @Reference(unbind="-")
    public void setSingleVMPool(SingleVMPool singleVMPool) {
        this._portalCache = singleVMPool.getPortalCache(UserImporter.class.getName(), false);
    }

    protected void addRole(long companyId, LDAPGroup ldapGroup, UserGroup userGroup) throws Exception {
        Role role;
        block4: {
            LDAPImportConfiguration ldapImportConfiguration = this._ldapImportConfigurationProvider.getConfiguration(companyId);
            if (!ldapImportConfiguration.importCreateRolePerGroup()) {
                return;
            }
            role = null;
            try {
                role = this._roleLocalService.getRole(companyId, ldapGroup.getGroupName());
            }
            catch (NoSuchRoleException nsre) {
                User defaultUser = this._userLocalService.getDefaultUser(companyId);
                HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
                descriptionMap.put(LocaleUtil.getDefault(), "Autogenerated role from LDAP import");
                role = this._roleLocalService.addRole(defaultUser.getUserId(), null, 0L, ldapGroup.getGroupName(), null, descriptionMap, 1, null, null);
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)("Imported autogenerated role from LDAP import: " + role));
            }
        }
        Group group = userGroup.getGroup();
        if (this._groupLocalService.hasRoleGroup(role.getRoleId(), group.getGroupId())) {
            return;
        }
        this._groupLocalService.addRoleGroups(role.getRoleId(), new long[]{group.getGroupId()});
    }

    protected User addUser(long companyId, LDAPUser ldapUser, String password) throws Exception {
        byte[] portraitBytes;
        StopWatch stopWatch = new StopWatch();
        if (_log.isDebugEnabled()) {
            stopWatch.start();
            _log.debug((Object)("Adding LDAP user " + ldapUser + " to company " + companyId));
        }
        boolean autoPassword = ldapUser.isAutoPassword();
        LDAPImportConfiguration ldapImportConfiguration = this._ldapImportConfigurationProvider.getConfiguration(companyId);
        if (!ldapImportConfiguration.importUserPasswordEnabled() && !(autoPassword = ldapImportConfiguration.importUserPasswordAutogenerated())) {
            String defaultPassword = ldapImportConfiguration.importUserPasswordDefault();
            if (StringUtil.equalsIgnoreCase((String)defaultPassword, (String)_USER_PASSWORD_SCREEN_NAME)) {
                defaultPassword = ldapUser.getScreenName();
            }
            password = defaultPassword;
        }
        Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
        birthdayCal.setTime(ldapUser.getBirthday());
        int birthdayMonth = birthdayCal.get(2);
        int birthdayDay = birthdayCal.get(5);
        int birthdayYear = birthdayCal.get(1);
        User user = this._userLocalService.addUser(ldapUser.getCreatorUserId(), companyId, autoPassword, password, password, ldapUser.isAutoScreenName(), ldapUser.getScreenName(), ldapUser.getEmailAddress(), 0L, "", ldapUser.getLocale(), ldapUser.getFirstName(), ldapUser.getMiddleName(), ldapUser.getLastName(), 0L, 0L, ldapUser.isMale(), birthdayMonth, birthdayDay, birthdayYear, "", ldapUser.getGroupIds(), ldapUser.getOrganizationIds(), ldapUser.getRoleIds(), ldapUser.getUserGroupIds(), ldapUser.isSendEmail(), ldapUser.getServiceContext());
        if (ldapUser.isUpdatePortrait() && ArrayUtil.isNotEmpty((byte[])(portraitBytes = ldapUser.getPortraitBytes()))) {
            user = this._userLocalService.updatePortrait(user.getUserId(), portraitBytes);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Finished adding LDAP user " + ldapUser + " as user " + user + " in " + stopWatch.getTime() + "ms"));
        }
        return user;
    }

    protected void addUserGroupsNotAddedByLDAPImport(long userId, Set<Long> userGroupIds) throws Exception {
        List userGroups = this._userGroupLocalService.getUserUserGroups(userId);
        for (UserGroup userGroup : userGroups) {
            if (userGroup.isAddedByLDAPImport()) continue;
            userGroupIds.add(userGroup.getUserGroupId());
        }
    }

    protected String escapeValue(String value) {
        return StringUtil.replace((String)value, (String)"\\,", (String)"\\\\,");
    }

    protected User getUser(long companyId, LDAPUser ldapUser) throws Exception {
        LDAPImportConfiguration ldapImportConfiguration = this._ldapImportConfigurationProvider.getConfiguration(companyId);
        if (Objects.equals(ldapImportConfiguration.importUserSyncStrategy(), _USER_SYNC_STRATEGY_UUID)) {
            ServiceContext serviceContext = ldapUser.getServiceContext();
            return this._userLocalService.fetchUserByUuidAndCompanyId(serviceContext.getUuidWithoutReset(), companyId);
        }
        String authType = PrefsPropsUtil.getString((long)companyId, (String)"company.security.auth.type", (String)this._companySecurityAuthType);
        if (authType.equals(_USER_PASSWORD_SCREEN_NAME) && !ldapUser.isAutoScreenName()) {
            return this._userLocalService.fetchUserByScreenName(companyId, ldapUser.getScreenName());
        }
        return this._userLocalService.fetchUserByEmailAddress(companyId, ldapUser.getEmailAddress());
    }

    protected Attribute getUsers(long ldapServerId, long companyId, LdapContext ldapContext, Attributes attributes, UserGroup userGroup, Properties groupMappings) throws Exception {
        Attribute attribute = attributes.get(groupMappings.getProperty(_IMPORT_BY_USER));
        if (attribute == null) {
            return null;
        }
        LDAPServerConfiguration ldapServerConfiguration = this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        String baseDN = ldapServerConfiguration.baseDN();
        StringBundler sb = new StringBundler(7);
        sb.append("(&");
        String groupSearchFilter = ldapServerConfiguration.groupSearchFilter();
        LDAPUtil.validateFilter(groupSearchFilter, "LDAPServerConfiguration.groupSearchFilter");
        sb.append(groupSearchFilter);
        sb.append("(");
        sb.append(groupMappings.getProperty("groupName"));
        sb.append("=");
        sb.append(this.escapeValue(userGroup.getName()));
        sb.append("))");
        return this._portalLDAP.getMultivaluedAttribute(companyId, ldapContext, baseDN, sb.toString(), attribute);
    }

    protected void importFromLDAPByGroup(long ldapServerId, long companyId, LdapContext ldapContext, Properties userMappings, Properties userExpandoMappings, Properties contactMappings, Properties contactExpandoMappings, Properties groupMappings, Set<String> ldapUserIgnoreAttributes) throws Exception {
        byte[] cookie = new byte[]{};
        while (cookie != null) {
            ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
            String groupMappingsGroupName = GetterUtil.getString((String)groupMappings.getProperty("groupName"));
            groupMappingsGroupName = StringUtil.toLowerCase((String)groupMappingsGroupName);
            cookie = this._portalLDAP.getGroups(ldapServerId, companyId, ldapContext, cookie, 0, new String[]{groupMappingsGroupName}, searchResults);
            for (SearchResult searchResult : searchResults) {
                try {
                    Attributes attributes = this._portalLDAP.getGroupAttributes(ldapServerId, companyId, ldapContext, this._portalLDAP.getNameInNamespace(ldapServerId, companyId, searchResult), true);
                    UserGroup userGroup = this.importUserGroup(companyId, attributes, groupMappings);
                    Attribute usersAttribute = this.getUsers(ldapServerId, companyId, ldapContext, attributes, userGroup, groupMappings);
                    if (usersAttribute == null) {
                        if (!_log.isInfoEnabled()) continue;
                        _log.info((Object)("No users found in " + userGroup.getName()));
                        continue;
                    }
                    this.importUsers(ldapServerId, companyId, ldapContext, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, userGroup.getUserGroupId(), usersAttribute, ldapUserIgnoreAttributes);
                }
                catch (Exception e) {
                    _log.error((Object)("Unable to import group " + searchResult), (Throwable)e);
                }
            }
        }
    }

    protected void importFromLDAPByUser(long ldapServerId, long companyId, LdapContext ldapContext, Properties userMappings, Properties userExpandoMappings, Properties contactMappings, Properties contactExpandoMappings, Properties groupMappings, Set<String> ldapUserIgnoreAttributes) throws Exception {
        byte[] cookie = new byte[]{};
        while (cookie != null) {
            ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
            String userMappingsScreenName = GetterUtil.getString((String)userMappings.getProperty(_USER_PASSWORD_SCREEN_NAME));
            userMappingsScreenName = StringUtil.toLowerCase((String)userMappingsScreenName);
            cookie = this._portalLDAP.getUsers(ldapServerId, companyId, ldapContext, cookie, 0, new String[]{userMappingsScreenName}, searchResults);
            for (SearchResult searchResult : searchResults) {
                try {
                    Attributes userAttributes = this._portalLDAP.getUserAttributes(ldapServerId, companyId, ldapContext, this._portalLDAP.getNameInNamespace(ldapServerId, companyId, searchResult));
                    User user = this.importUser(ldapServerId, companyId, userAttributes, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, "", ldapUserIgnoreAttributes);
                    this.importGroups(ldapServerId, companyId, ldapContext, userAttributes, user, userMappings, groupMappings);
                }
                catch (Exception e) {
                    _log.error((Object)("Unable to import user " + searchResult), (Throwable)e);
                }
            }
        }
    }

    protected Set<Long> importGroup(long ldapServerId, long companyId, LdapContext ldapContext, String fullGroupDN, User user, Properties groupMappings, Set<Long> newUserGroupIds) throws Exception {
        String userGroupIdKey = null;
        Long userGroupId = null;
        LDAPImportConfiguration ldapImportConfiguration = this._ldapImportConfigurationProvider.getConfiguration(companyId);
        if (ldapImportConfiguration.importGroupCacheEnabled()) {
            StringBundler sb = new StringBundler(5);
            sb.append(ldapServerId);
            sb.append("_");
            sb.append(companyId);
            sb.append("_");
            sb.append(fullGroupDN);
            userGroupIdKey = sb.toString();
            userGroupId = (Long)this._portalCache.get((Serializable)((Object)userGroupIdKey));
        }
        if (userGroupId != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping reimport of full group DN " + fullGroupDN));
            }
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Importing full group DN " + fullGroupDN));
            }
            Attributes groupAttributes = null;
            try {
                groupAttributes = this._portalLDAP.getGroupAttributes(ldapServerId, companyId, ldapContext, fullGroupDN);
            }
            catch (NameNotFoundException nnfe) {
                _log.error((Object)("LDAP group not found with full group DN " + fullGroupDN), (Throwable)nnfe);
            }
            UserGroup userGroup = this.importUserGroup(companyId, groupAttributes, groupMappings);
            if (userGroup == null) {
                return newUserGroupIds;
            }
            userGroupId = userGroup.getUserGroupId();
            if (ldapImportConfiguration.importGroupCacheEnabled()) {
                this._portalCache.put((Serializable)((Object)userGroupIdKey), (Object)userGroupId);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Adding user " + user + " to user group " + userGroupId));
        }
        newUserGroupIds.add(userGroupId);
        return newUserGroupIds;
    }

    protected void importGroups(long ldapServerId, long companyId, LdapContext ldapContext, Attributes attributes, User user, Properties userMappings, Properties groupMappings) throws Exception {
        String groupMappingsUser = groupMappings.getProperty(_IMPORT_BY_USER);
        Set<Long> newUserGroupIds = new LinkedHashSet<Long>();
        LDAPServerConfiguration ldapServerConfiguration = this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        if (Validator.isNotNull((String)groupMappingsUser) && ldapServerConfiguration.groupSearchFilterEnabled()) {
            String baseDN = ldapServerConfiguration.baseDN();
            StringBundler sb = new StringBundler(9);
            sb.append("(");
            sb.append("&");
            String groupSearchFilter = ldapServerConfiguration.groupSearchFilter();
            LDAPUtil.validateFilter(groupSearchFilter, "LDAPServerConfiguration.groupSearchFilter");
            sb.append(groupSearchFilter);
            sb.append("(");
            sb.append(groupMappingsUser);
            sb.append("=");
            Binding binding = this._portalLDAP.getUser(ldapServerId, companyId, user.getScreenName(), user.getEmailAddress());
            String fullUserDN = this._portalLDAP.getNameInNamespace(ldapServerId, companyId, binding);
            sb.append(this.escapeValue(fullUserDN));
            sb.append(")");
            sb.append(")");
            byte[] cookie = new byte[]{};
            while (cookie != null) {
                ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
                String groupMappingsGroupName = GetterUtil.getString((String)groupMappings.getProperty("groupName"));
                groupMappingsGroupName = StringUtil.toLowerCase((String)groupMappingsGroupName);
                cookie = this._portalLDAP.searchLDAP(companyId, ldapContext, cookie, 0, baseDN, sb.toString(), new String[]{groupMappingsGroupName}, searchResults);
                for (SearchResult searchResult : searchResults) {
                    String fullGroupDN = this._portalLDAP.getNameInNamespace(ldapServerId, companyId, searchResult);
                    newUserGroupIds = this.importGroup(ldapServerId, companyId, ldapContext, fullGroupDN, user, groupMappings, newUserGroupIds);
                }
            }
        } else {
            String userMappingsGroup = userMappings.getProperty(_IMPORT_BY_GROUP);
            if (Validator.isNull((String)userMappingsGroup)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Skipping group import because no mappings for LDAP groups were specified in user mappings " + userMappings));
                }
                return;
            }
            Attribute userGroupAttribute = attributes.get(userMappingsGroup);
            if (userGroupAttribute == null) {
                return;
            }
            for (int i = 0; i < userGroupAttribute.size(); ++i) {
                String fullGroupDN = (String)userGroupAttribute.get(i);
                newUserGroupIds = this.importGroup(ldapServerId, companyId, ldapContext, fullGroupDN, user, groupMappings, newUserGroupIds);
            }
        }
        this.addUserGroupsNotAddedByLDAPImport(user.getUserId(), newUserGroupIds);
        LinkedHashSet<Long> oldUserGroupIds = new LinkedHashSet<Long>();
        List oldUserGroups = this._userGroupLocalService.getUserUserGroups(user.getUserId());
        for (UserGroup oldUserGroup : oldUserGroups) {
            oldUserGroupIds.add(oldUserGroup.getUserGroupId());
        }
        if (!oldUserGroupIds.equals(newUserGroupIds)) {
            long[] userGroupIds = ArrayUtil.toLongArray(newUserGroupIds);
            this._userGroupLocalService.setUserUserGroups(user.getUserId(), userGroupIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected User importUser(long ldapServerId, long companyId, Attributes attributes, Properties userMappings, Properties userExpandoMappings, Properties contactMappings, Properties contactExpandoMappings, String password, Set<String> ldapUserIgnoreAttributes) throws Exception {
        UserImportTransactionThreadLocal.setOriginatesFromImport(true);
        try {
            attributes = this._attributesTransformer.transformUser(attributes);
            LDAPUser ldapUser = this._ldapToPortalConverter.importLDAPUser(companyId, attributes, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, password);
            User user = this.getUser(companyId, ldapUser);
            if (user != null && user.isDefaultUser()) {
                User user2 = user;
                return user2;
            }
            ServiceContext serviceContext = ldapUser.getServiceContext();
            serviceContext.setAttribute("ldapServerId", (Serializable)Long.valueOf(ldapServerId));
            boolean isNew = false;
            if (user == null) {
                user = this.addUser(companyId, ldapUser, password);
                isNew = true;
            }
            String modifyTimestamp = LDAPUtil.getAttributeString(attributes, "modifyTimestamp");
            user = this.updateUser(companyId, ldapServerId, ldapUser, user, userMappings, contactMappings, password, modifyTimestamp, isNew);
            this.updateExpandoAttributes(user, ldapUser, userExpandoMappings, contactExpandoMappings, ldapUserIgnoreAttributes);
            User user3 = user;
            return user3;
        }
        finally {
            UserImportTransactionThreadLocal.setOriginatesFromImport(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserGroup importUserGroup(long companyId, Attributes attributes, Properties groupMappings) throws Exception {
        attributes = this._attributesTransformer.transformGroup(attributes);
        LDAPGroup ldapGroup = this._ldapToPortalConverter.importLDAPGroup(companyId, attributes, groupMappings);
        UserGroup userGroup = null;
        try {
            userGroup = this._userGroupLocalService.getUserGroup(companyId, ldapGroup.getGroupName());
            if (!Objects.equals(userGroup.getDescription(), ldapGroup.getDescription())) {
                this._userGroupLocalService.updateUserGroup(companyId, userGroup.getUserGroupId(), ldapGroup.getGroupName(), ldapGroup.getDescription(), null);
            }
        }
        catch (NoSuchUserGroupException nsuge) {
            StopWatch stopWatch = new StopWatch();
            if (_log.isDebugEnabled()) {
                stopWatch.start();
                _log.debug((Object)("Adding LDAP group " + ldapGroup));
            }
            long defaultUserId = this._userLocalService.getDefaultUserId(companyId);
            UserGroupImportTransactionThreadLocal.setOriginatesFromImport((boolean)true);
            try {
                userGroup = this._userGroupLocalService.addUserGroup(defaultUserId, companyId, ldapGroup.getGroupName(), ldapGroup.getDescription(), null);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Finished adding LDAP group " + ldapGroup + " as user group " + userGroup + " in " + stopWatch.getTime() + "ms"));
                }
            }
            catch (Exception e) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to create user group " + ldapGroup.getGroupName()));
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)e, (Throwable)e);
                }
            }
            finally {
                UserGroupImportTransactionThreadLocal.setOriginatesFromImport((boolean)false);
            }
        }
        this.addRole(companyId, ldapGroup, userGroup);
        return userGroup;
    }

    protected void importUsers(long ldapServerId, long companyId, LdapContext ldapContext, Properties userMappings, Properties userExpandoMappings, Properties contactMappings, Properties contactExpandoMappings, long userGroupId, Attribute attribute, Set<String> ldapUserIgnoreAttributes) throws Exception {
        StopWatch stopWatch = new StopWatch();
        if (_log.isDebugEnabled()) {
            stopWatch.start();
            _log.debug((Object)("Importing " + attribute.size() + " users from LDAP server " + ldapServerId + " to company " + companyId));
        }
        LinkedHashSet<Long> newUserIds = new LinkedHashSet<Long>(attribute.size());
        for (int i = 0; i < attribute.size(); ++i) {
            String fullUserDN = (String)attribute.get(i);
            Attributes userAttributes = null;
            try {
                userAttributes = this._portalLDAP.getUserAttributes(ldapServerId, companyId, ldapContext, fullUserDN);
            }
            catch (NameNotFoundException nnfe) {
                _log.error((Object)("LDAP user not found with fullUserDN " + fullUserDN), (Throwable)nnfe);
                continue;
            }
            try {
                User user = this.importUser(ldapServerId, companyId, userAttributes, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, "", ldapUserIgnoreAttributes);
                if (user == null) continue;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Adding user " + user + " to user group " + userGroupId));
                }
                this._userLocalService.addUserGroupUsers(userGroupId, new long[]{user.getUserId()});
                newUserIds.add(user.getUserId());
                continue;
            }
            catch (Exception e) {
                _log.error((Object)("Unable to load user " + userAttributes), (Throwable)e);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Finished importing " + newUserIds.size() + " of " + attribute.size() + " users from LDAP server " + ldapServerId + " in " + stopWatch.getTime() + "ms"));
        }
        List userGroupUsers = this._userLocalService.getUserGroupUsers(userGroupId);
        for (User user : userGroupUsers) {
            if (ldapServerId != user.getLdapServerId() || newUserIds.contains(user.getUserId())) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Removing user " + user + " from user group " + userGroupId));
            }
            this._userLocalService.deleteUserGroupUser(userGroupId, user.getUserId());
        }
    }

    protected void populateExpandoAttributes(ExpandoBridge expandoBridge, Map<String, String[]> expandoAttributes, Properties expandoMappings, Set<String> ldapUserIgnoreAttributes) {
        block5: {
            HashMap<String, Serializable> serializedExpandoAttributes = new HashMap<String, Serializable>();
            for (Map.Entry<String, String[]> expandoAttribute : expandoAttributes.entrySet()) {
                String name = expandoAttribute.getKey();
                if (!expandoBridge.hasAttribute(name) || !expandoMappings.containsKey(name) || ldapUserIgnoreAttributes.contains(name)) continue;
                int type = expandoBridge.getAttributeType(name);
                Serializable value = ExpandoConverterUtil.getAttributeFromStringArray((int)type, (String[])expandoAttribute.getValue());
                serializedExpandoAttributes.put(name, value);
            }
            if (serializedExpandoAttributes.isEmpty()) {
                return;
            }
            try {
                this._expandoValueLocalService.addValues(expandoBridge.getCompanyId(), expandoBridge.getClassName(), "CUSTOM_FIELDS", expandoBridge.getClassPK(), serializedExpandoAttributes);
            }
            catch (Exception e) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to populate expando attributes");
                }
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Object)e, (Throwable)e);
            }
        }
    }

    @Reference(unbind="-")
    protected void setCompanyLocalService(CompanyLocalService companyLocalService) {
        this._companyLocalService = companyLocalService;
    }

    @Reference(unbind="-")
    protected void setExpandoValueLocalService(ExpandoValueLocalService expandoValueLocalService) {
        this._expandoValueLocalService = expandoValueLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration)", unbind="-")
    protected void setLDAPImportConfigurationProvider(ConfigurationProvider<LDAPImportConfiguration> ldapImportConfigurationProvider) {
        this._ldapImportConfigurationProvider = ldapImportConfigurationProvider;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration)", unbind="-")
    protected void setLDAPServerConfigurationProvider(ConfigurationProvider<LDAPServerConfiguration> ldapServerConfigurationProvider) {
        this._ldapServerConfigurationProvider = ldapServerConfigurationProvider;
    }

    @Reference(unbind="-")
    protected void setLdapSettings(LDAPSettings ldapSettings) {
        this._ldapSettings = ldapSettings;
    }

    @Reference(unbind="-")
    protected void setLockManager(LockManager lockManager) {
        this._lockManager = lockManager;
    }

    @Reference(unbind="-")
    protected void setPortalLDAP(PortalLDAP portalLDAP) {
        this._portalLDAP = portalLDAP;
    }

    protected void setProperty(Object bean1, Object bean2, String propertyName) {
        Object value = BeanPropertiesUtil.getObject((Object)bean2, (String)propertyName);
        BeanPropertiesUtil.setProperty((Object)bean1, (String)propertyName, (Object)value);
    }

    @Reference(unbind="-")
    protected void setProps(Props props) {
        this._companySecurityAuthType = GetterUtil.getString((String)props.get("company.security.auth.type"));
    }

    @Reference(unbind="-")
    protected void setRoleLocalService(RoleLocalService roleLocalService) {
        this._roleLocalService = roleLocalService;
    }

    @Reference(unbind="-")
    protected void setUserGroupLocalService(UserGroupLocalService userGroupLocalService) {
        this._userGroupLocalService = userGroupLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    protected void updateExpandoAttributes(User user, LDAPUser ldapUser, Properties userExpandoMappings, Properties contactExpandoMappings, Set<String> ldapUserIgnoreAttributes) throws Exception {
        ExpandoBridge userExpandoBridge = user.getExpandoBridge();
        this.populateExpandoAttributes(userExpandoBridge, ldapUser.getUserExpandoAttributes(), userExpandoMappings, ldapUserIgnoreAttributes);
        Contact contact = user.getContact();
        ExpandoBridge contactExpandoBridge = contact.getExpandoBridge();
        this.populateExpandoAttributes(contactExpandoBridge, ldapUser.getContactExpandoAttributes(), contactExpandoMappings, ldapUserIgnoreAttributes);
    }

    protected void updateLDAPUser(User ldapUser, Contact ldapContact, User user, Properties userMappings, Properties contactMappings, Set<String> ldapUserIgnoreAttributes) throws PortalException {
        String mappingPropertyName;
        String propertyName;
        int n;
        Contact contact = user.getContact();
        String[] stringArray = _CONTACT_PROPERTY_NAMES;
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            mappingPropertyName = propertyName = stringArray[n];
            if (propertyName.equals("male")) {
                mappingPropertyName = "gender";
            } else if (propertyName.equals("prefixId")) {
                mappingPropertyName = "prefix";
            } else if (propertyName.equals("suffixId")) {
                mappingPropertyName = "suffix";
            }
            if (contactMappings.containsKey(mappingPropertyName) && !ldapUserIgnoreAttributes.contains(propertyName)) continue;
            this.setProperty(ldapContact, contact, propertyName);
        }
        stringArray = _USER_PROPERTY_NAMES;
        n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            mappingPropertyName = propertyName = stringArray[n];
            if (propertyName.equals("portraitId")) {
                mappingPropertyName = "portrait";
            }
            if (userMappings.containsKey(mappingPropertyName) && !ldapUserIgnoreAttributes.contains(propertyName)) continue;
            this.setProperty(ldapUser, user, propertyName);
        }
    }

    protected User updateUser(long companyId, long ldapServerId, LDAPUser ldapUser, User user, Properties userMappings, Properties contactMappings, String password, String modifyTimestamp, boolean isNew) throws Exception {
        boolean passwordReset;
        LDAPImportConfiguration ldapImportConfiguration;
        Date modifiedDate;
        StopWatch stopWatch;
        block16: {
            stopWatch = new StopWatch();
            if (_log.isDebugEnabled()) {
                stopWatch.start();
                if (isNew) {
                    _log.debug((Object)("Updating new user " + user + " from LDAP server " + ldapServerId + " to company " + companyId));
                } else {
                    _log.debug((Object)("Updating existing user " + user + " from LDAP server " + ldapServerId + " to company " + companyId));
                }
            }
            modifiedDate = null;
            ldapImportConfiguration = this._ldapImportConfigurationProvider.getConfiguration(companyId);
            passwordReset = ldapUser.isPasswordReset();
            if (this._ldapSettings.isExportEnabled(companyId)) {
                passwordReset = user.isPasswordReset();
            }
            try {
                if (Validator.isNotNull((String)modifyTimestamp)) {
                    modifiedDate = LDAPUtil.parseDate(modifyTimestamp);
                    if (modifiedDate.equals(user.getModifiedDate())) {
                        this.updateUserPassword(ldapImportConfiguration, user.getUserId(), ldapUser.getScreenName(), password, passwordReset);
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)("User " + user.getEmailAddress() + " is already synchronized, but updated password to avoid a blank value"));
                        }
                        return user;
                    }
                } else if (!isNew) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Skipping user " + user.getEmailAddress() + " because the LDAP entry was never modified"));
                    }
                    return user;
                }
            }
            catch (ParseException pe) {
                if (!_log.isDebugEnabled()) break block16;
                _log.debug((Object)("Unable to parse LDAP modify timestamp " + modifyTimestamp), (Throwable)pe);
            }
        }
        LDAPServerConfiguration ldapServerConfiguration = this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        String[] userIgnoreAttributes = ldapServerConfiguration.userIgnoreAttributes();
        HashSet<String> ldapUserIgnoreAttributes = new HashSet<String>(Arrays.asList(userIgnoreAttributes));
        if (Validator.isNull((String)ldapUser.getScreenName()) || ldapUser.isAutoScreenName()) {
            ldapUser.setScreenName(user.getScreenName());
        }
        if (ldapUser.isUpdatePassword()) {
            password = this.updateUserPassword(ldapImportConfiguration, user.getUserId(), ldapUser.getScreenName(), password, passwordReset);
        }
        Contact ldapContact = ldapUser.getContact();
        this.updateLDAPUser(ldapUser.getUser(), ldapContact, user, userMappings, contactMappings, ldapUserIgnoreAttributes);
        Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
        birthdayCal.setTime(ldapContact.getBirthday());
        int birthdayMonth = birthdayCal.get(2);
        int birthdayDay = birthdayCal.get(5);
        int birthdayYear = birthdayCal.get(1);
        user = this._userLocalService.updateUser(user.getUserId(), password, "", "", passwordReset, ldapUser.getReminderQueryQuestion(), ldapUser.getReminderQueryAnswer(), ldapUser.getScreenName(), ldapUser.getEmailAddress(), ldapUser.getFacebookId(), ldapUser.getOpenId(), ldapUser.getPortraitId() > 0L, ldapUser.getPortraitBytes(), ldapUser.getLanguageId(), ldapUser.getTimeZoneId(), ldapUser.getGreeting(), ldapUser.getComments(), ldapUser.getFirstName(), ldapUser.getMiddleName(), ldapUser.getLastName(), ldapUser.getPrefixId(), ldapUser.getSuffixId(), ldapUser.isMale(), birthdayMonth, birthdayDay, birthdayYear, ldapUser.getSmsSn(), ldapUser.getFacebookSn(), ldapUser.getJabberSn(), ldapUser.getSkypeSn(), ldapUser.getTwitterSn(), ldapUser.getJobTitle(), ldapUser.getGroupIds(), ldapUser.getOrganizationIds(), ldapUser.getRoleIds(), ldapUser.getUserGroupRoles(), ldapUser.getUserGroupIds(), ldapUser.getServiceContext());
        ServiceContext serviceContext = new ServiceContext();
        if (modifiedDate != null) {
            serviceContext.setModifiedDate(modifiedDate);
        }
        user = this._userLocalService.updateStatus(user.getUserId(), ldapUser.getStatus(), serviceContext);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Finished update for user " + user + " in " + stopWatch.getTime() + "ms"));
        }
        return user;
    }

    protected String updateUserPassword(LDAPImportConfiguration ldapImportConfiguration, long userId, String screenName, String password, boolean passwordReset) throws PortalException {
        if (!ldapImportConfiguration.importUserPasswordEnabled()) {
            if (ldapImportConfiguration.importUserPasswordAutogenerated()) {
                password = PwdGenerator.getPassword();
            } else {
                password = ldapImportConfiguration.importUserPasswordDefault();
                if (StringUtil.equalsIgnoreCase((String)password, (String)_USER_PASSWORD_SCREEN_NAME)) {
                    password = screenName;
                }
            }
        }
        this._userLocalService.updatePassword(userId, password, password, passwordReset, true);
        return password;
    }
}

