/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.exportimport;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.ldap.LDAPSettings;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.exportimport.UserExporter;
import com.liferay.portal.security.exportimport.UserOperation;
import com.liferay.portal.security.ldap.PortalLDAP;
import com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.exportimport.Modifications;
import com.liferay.portal.security.ldap.exportimport.PortalToLDAPConverter;
import com.liferay.portal.security.ldap.internal.PortalLDAPContext;
import com.liferay.portal.security.ldap.util.LDAPUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SchemaViolationException;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={UserExporter.class})
public class LDAPUserExporterImpl
implements UserExporter {
    private static final Log _log = LogFactoryUtil.getLog(LDAPUserExporterImpl.class);
    private ConfigurationProvider<LDAPAuthConfiguration> _ldapAuthConfigurationProvider;
    private LDAPSettings _ldapSettings;
    private PortalLDAP _portalLDAP;
    private PortalToLDAPConverter _portalToLDAPConverter;
    private UserGroupLocalService _userGroupLocalService;
    private UserLocalService _userLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportUser(Contact contact, Map<String, Serializable> contactExpandoAttributes) throws Exception {
        long companyId = contact.getCompanyId();
        StopWatch stopWatch = new StopWatch();
        if (_log.isDebugEnabled()) {
            stopWatch.start();
            _log.debug((Object)("Exporting contact " + contact));
        }
        if (!this._ldapSettings.isExportEnabled(companyId)) {
            return;
        }
        User user = this._userLocalService.getUserByContactId(contact.getContactId());
        if (user.isDefaultUser() || user.getStatus() != 0) {
            return;
        }
        long ldapServerId = this._portalLDAP.getLdapServerId(companyId, user.getScreenName(), user.getEmailAddress());
        LdapContext ldapContext = this._portalLDAP.getContext(ldapServerId, companyId);
        try {
            if (ldapContext == null) {
                return;
            }
            Properties contactMappings = this._ldapSettings.getContactMappings(ldapServerId, companyId);
            Properties contactExpandoMappings = this._ldapSettings.getContactExpandoMappings(ldapServerId, companyId);
            Binding binding = this._portalLDAP.getUser(ldapServerId, contact.getCompanyId(), user.getScreenName(), user.getEmailAddress());
            if (binding == null) {
                Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
                binding = this.addUser(ldapServerId, ldapContext, user, userMappings);
            }
            CompositeName name = new CompositeName();
            name.add(this._portalLDAP.getNameInNamespace(ldapServerId, companyId, binding));
            Modifications modifications = this._portalToLDAPConverter.getLDAPContactModifications(contact, contactExpandoAttributes, contactMappings, contactExpandoMappings);
            if (modifications == null) {
                return;
            }
            ModificationItem[] modificationItems = modifications.getItems();
            ldapContext.modifyAttributes(name, modificationItems);
        }
        finally {
            if (ldapContext != null) {
                ldapContext.close();
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Finished exporting contact " + contact + " in " + stopWatch.getTime() + "ms"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportUser(long userId, long userGroupId, UserOperation userOperation) throws Exception {
        User user = this._userLocalService.getUser(userId);
        long companyId = user.getCompanyId();
        StopWatch stopWatch = new StopWatch();
        if (_log.isDebugEnabled()) {
            stopWatch.start();
            _log.debug((Object)("Exporting user " + user + " in user group " + userGroupId));
        }
        if (!this._ldapSettings.isExportEnabled(companyId) || !this._ldapSettings.isExportGroupEnabled(companyId)) {
            return;
        }
        long ldapServerId = this._portalLDAP.getLdapServerId(companyId, user.getScreenName(), user.getEmailAddress());
        LdapContext ldapContext = this._portalLDAP.getContext(ldapServerId, companyId);
        if (ldapContext == null) {
            return;
        }
        UserGroup userGroup = this._userGroupLocalService.getUserGroup(userGroupId);
        Properties groupMappings = this._ldapSettings.getGroupMappings(ldapServerId, companyId);
        Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
        Binding binding = this._portalLDAP.getGroup(ldapServerId, companyId, userGroup.getName());
        try {
            if (binding == null) {
                if (userOperation == UserOperation.ADD) {
                    this.addGroup(ldapServerId, ldapContext, userGroup, user, groupMappings, userMappings);
                }
                return;
            }
            CompositeName name = new CompositeName();
            name.add(this._portalLDAP.getNameInNamespace(ldapServerId, companyId, binding));
            Modifications modifications = this._portalToLDAPConverter.getLDAPGroupModifications(ldapServerId, userGroup, user, groupMappings, userMappings, userOperation);
            ModificationItem[] modificationItems = modifications.getItems();
            ldapContext.modifyAttributes(name, modificationItems);
        }
        catch (SchemaViolationException sve) {
            String fullGroupDN = this._portalLDAP.getNameInNamespace(ldapServerId, companyId, binding);
            Attributes attributes = this._portalLDAP.getGroupAttributes(ldapServerId, companyId, ldapContext, fullGroupDN, true);
            Attribute groupMembers = attributes.get(groupMappings.getProperty("user"));
            if (groupMembers != null && groupMembers.size() == 1) {
                ldapContext.unbind(fullGroupDN);
            }
        }
        finally {
            if (ldapContext != null) {
                ldapContext.close();
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Finished exporting user " + user + " in user group " + userGroupId + " in " + stopWatch.getTime() + "ms"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportUser(User user, Map<String, Serializable> userExpandoAttributes) throws Exception {
        if (user.isDefaultUser() || user.getStatus() != 0) {
            return;
        }
        long companyId = user.getCompanyId();
        if (!this._ldapSettings.isExportEnabled(companyId)) {
            return;
        }
        long ldapServerId = this._portalLDAP.getLdapServerId(companyId, user.getScreenName(), user.getEmailAddress());
        try (LdapContext ldapContext = this._portalLDAP.getContext(ldapServerId, companyId);){
            if (ldapContext == null) {
                return;
            }
            Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
            Properties userExpandoMappings = this._ldapSettings.getUserExpandoMappings(ldapServerId, companyId);
            Binding binding = this._portalLDAP.getUser(ldapServerId, user.getCompanyId(), user.getScreenName(), user.getEmailAddress(), true);
            if (binding == null) {
                binding = this.addUser(ldapServerId, ldapContext, user, userMappings);
            } else {
                Date modifiedDate;
                Attributes attributes = this._portalLDAP.getUserAttributes(ldapServerId, companyId, ldapContext, this._portalLDAP.getNameInNamespace(ldapServerId, companyId, binding));
                String modifyTimestamp = LDAPUtil.getAttributeString(attributes, "modifyTimestamp");
                if (Validator.isNotNull((String)modifyTimestamp) && (modifiedDate = LDAPUtil.parseDate(modifyTimestamp)).equals(user.getModifiedDate())) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Skipping user " + user.getEmailAddress() + " because he is already synchronized"));
                    }
                    return;
                }
            }
            CompositeName name = new CompositeName();
            name.add(this._portalLDAP.getNameInNamespace(ldapServerId, companyId, binding));
            Modifications modifications = this._portalToLDAPConverter.getLDAPUserModifications(user, userExpandoAttributes, userMappings, userExpandoMappings);
            if (modifications == null) {
                return;
            }
            ModificationItem[] modificationItems = modifications.getItems();
            ldapContext.modifyAttributes(name, modificationItems);
            if (!this._ldapSettings.isExportGroupEnabled(companyId)) {
                return;
            }
            List userGroups = this._userGroupLocalService.getUserUserGroups(user.getUserId());
            for (UserGroup userGroup : userGroups) {
                this.exportUser(user.getUserId(), userGroup.getUserGroupId(), UserOperation.ADD);
            }
            Modifications groupModifications = this._portalToLDAPConverter.getLDAPUserGroupModifications(ldapServerId, userGroups, user, userMappings);
            ModificationItem[] groupModificationItems = groupModifications.getItems();
            if (groupModificationItems.length > 0) {
                ldapContext.modifyAttributes(name, groupModificationItems);
            }
        }
    }

    @Reference(unbind="-")
    public void setPortalToLDAPConverter(PortalToLDAPConverter portalToLDAPConverter) {
        this._portalToLDAPConverter = portalToLDAPConverter;
    }

    protected Binding addGroup(long ldapServerId, LdapContext ldapContext, UserGroup userGroup, User user, Properties groupMappings, Properties userMappings) throws Exception {
        CompositeName name = new CompositeName();
        name.add(this._portalToLDAPConverter.getGroupDNName(ldapServerId, userGroup, groupMappings));
        Attributes attributes = this._portalToLDAPConverter.getLDAPGroupAttributes(ldapServerId, userGroup, user, groupMappings, userMappings);
        ldapContext.bind(name, (Object)new PortalLDAPContext(attributes));
        Binding binding = this._portalLDAP.getGroup(ldapServerId, userGroup.getCompanyId(), userGroup.getName());
        return binding;
    }

    protected Binding addUser(long ldapServerId, LdapContext ldapContext, User user, Properties userMappings) throws Exception {
        CompositeName name = new CompositeName();
        name.add(this._portalToLDAPConverter.getUserDNName(ldapServerId, user, userMappings));
        Attributes attributes = this._portalToLDAPConverter.getLDAPUserAttributes(ldapServerId, user, userMappings);
        ldapContext.bind(name, (Object)new PortalLDAPContext(attributes));
        Binding binding = this._portalLDAP.getUser(ldapServerId, user.getCompanyId(), user.getScreenName(), user.getEmailAddress());
        return binding;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration)", unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider<LDAPAuthConfiguration> ldapAuthConfigurationProvider) {
        this._ldapAuthConfigurationProvider = ldapAuthConfigurationProvider;
    }

    @Reference(unbind="-")
    protected void setLdapSettings(LDAPSettings ldapSettings) {
        this._ldapSettings = ldapSettings;
    }

    @Reference(unbind="-")
    protected void setPortalLDAP(PortalLDAP portalLDAP) {
        this._portalLDAP = portalLDAP;
    }

    @Reference(unbind="-")
    protected void setUserGroupLocalService(UserGroupLocalService userGroupLocalService) {
        this._userGroupLocalService = userGroupLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

