/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.exportimport;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoConverterUtil;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.auth.PasswordModificationThreadLocal;
import com.liferay.portal.kernel.security.ldap.LDAPSettings;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptor;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.exportimport.UserOperation;
import com.liferay.portal.security.ldap.PortalLDAP;
import com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration;
import com.liferay.portal.security.ldap.exportimport.Modifications;
import com.liferay.portal.security.ldap.exportimport.PortalToLDAPConverter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortalToLDAPConverter.class})
public class DefaultPortalToLDAPConverter
implements PortalToLDAPConverter {
    private static final String _DEFAULT_DN = "cn";
    private static final String _OBJECT_CLASS = "objectclass";
    private static final Log _log = LogFactoryUtil.getLog(DefaultPortalToLDAPConverter.class);
    private ImageLocalService _imageLocalService;
    private ConfigurationProvider<LDAPAuthConfiguration> _ldapAuthConfigurationProvider;
    private ConfigurationProvider<LDAPServerConfiguration> _ldapServerConfigurationProvider;
    private LDAPSettings _ldapSettings;
    private PasswordEncryptor _passwordEncryptor;
    private PortalLDAP _portalLDAP;
    private final Map<String, String> _reservedContactFieldNames = new HashMap<String, String>();
    private final Map<String, String> _reservedUserFieldNames = new HashMap<String, String>();
    private String _userDNFieldName = "screenName";

    public DefaultPortalToLDAPConverter() {
        this._reservedUserFieldNames.put("group", "group");
        this._reservedUserFieldNames.put("password", "password");
        this._reservedUserFieldNames.put("portrait", "portrait");
        this._reservedUserFieldNames.put("screenName", "screenName");
    }

    @Override
    public String getGroupDNName(long ldapServerId, UserGroup userGroup, Properties groupMappings) throws Exception {
        Binding groupBinding = this._portalLDAP.getGroup(ldapServerId, userGroup.getCompanyId(), userGroup.getName());
        if (groupBinding != null) {
            return this._portalLDAP.getNameInNamespace(ldapServerId, userGroup.getCompanyId(), groupBinding);
        }
        StringBundler sb = new StringBundler(5);
        sb.append(GetterUtil.getString((String)groupMappings.getProperty("groupName"), (String)_DEFAULT_DN));
        sb.append("=");
        sb.append(userGroup.getName());
        sb.append(",");
        sb.append(this._portalLDAP.getGroupsDN(ldapServerId, userGroup.getCompanyId()));
        return sb.toString();
    }

    @Override
    public Modifications getLDAPContactModifications(Contact contact, Map<String, Serializable> contactExpandoAttributes, Properties contactMappings, Properties contactExpandoMappings) throws Exception {
        if (contactMappings.isEmpty() && contactExpandoMappings.isEmpty()) {
            return null;
        }
        Modifications modifications = this.getModifications(contact, contactMappings, this._reservedContactFieldNames);
        this.populateCustomAttributeModifications(contact, contact.getExpandoBridge(), contactExpandoAttributes, contactExpandoMappings, modifications);
        return modifications;
    }

    @Override
    public Attributes getLDAPGroupAttributes(long ldapServerId, UserGroup userGroup, User user, Properties groupMappings, Properties userMappings) throws Exception {
        String[] defaultObjectClassNames;
        BasicAttributes attributes = new BasicAttributes(true);
        BasicAttribute objectClassAttribute = new BasicAttribute(_OBJECT_CLASS);
        LDAPServerConfiguration ldapServerConfiguration = this._ldapServerConfigurationProvider.getConfiguration(userGroup.getCompanyId(), ldapServerId);
        for (String defaultObjectClassName : defaultObjectClassNames = ldapServerConfiguration.groupDefaultObjectClasses()) {
            objectClassAttribute.add(defaultObjectClassName);
        }
        attributes.put(objectClassAttribute);
        this.addAttributeMapping(groupMappings.getProperty("groupName"), userGroup.getName(), (Attributes)attributes);
        this.addAttributeMapping(groupMappings.getProperty("description"), userGroup.getDescription(), (Attributes)attributes);
        this.addAttributeMapping(groupMappings.getProperty("user"), this.getUserDNName(ldapServerId, user, userMappings), (Attributes)attributes);
        return attributes;
    }

    @Override
    public Modifications getLDAPGroupModifications(long ldapServerId, UserGroup userGroup, User user, Properties groupMappings, Properties userMappings, UserOperation userOperation) throws Exception {
        Modifications modifications = Modifications.getInstance();
        String groupDN = this.getGroupDNName(ldapServerId, userGroup, groupMappings);
        String userDN = this.getUserDNName(ldapServerId, user, userMappings);
        if (this._portalLDAP.isGroupMember(ldapServerId, user.getCompanyId(), groupDN, userDN)) {
            if (userOperation == UserOperation.REMOVE) {
                modifications.addItem(3, groupMappings.getProperty("user"), userDN);
            }
        } else if (userOperation == UserOperation.ADD) {
            modifications.addItem(1, groupMappings.getProperty("user"), userDN);
        }
        return modifications;
    }

    @Override
    public Attributes getLDAPUserAttributes(long ldapServerId, User user, Properties userMappings) {
        String[] defaultObjectClassNames;
        BasicAttributes attributes = new BasicAttributes(true);
        BasicAttribute objectClassAttribute = new BasicAttribute(_OBJECT_CLASS);
        LDAPServerConfiguration ldapServerConfiguration = this._ldapServerConfigurationProvider.getConfiguration(user.getCompanyId(), ldapServerId);
        for (String defaultObjectClassName : defaultObjectClassNames = ldapServerConfiguration.userDefaultObjectClasses()) {
            objectClassAttribute.add(defaultObjectClassName);
        }
        attributes.put(objectClassAttribute);
        this.addAttributeMapping(userMappings.getProperty("uuid"), user.getUuid(), (Attributes)attributes);
        this.addAttributeMapping(userMappings.getProperty("screenName"), user.getScreenName(), (Attributes)attributes);
        this.addAttributeMapping(userMappings.getProperty("password"), this.getEncryptedPasswordForLDAP(user, userMappings), (Attributes)attributes);
        this.addAttributeMapping(userMappings.getProperty("emailAddress"), user.getEmailAddress(), (Attributes)attributes);
        this.addAttributeMapping(userMappings.getProperty("fullName"), user.getFullName(), (Attributes)attributes);
        this.addAttributeMapping(userMappings.getProperty("firstName"), user.getFirstName(), (Attributes)attributes);
        this.addAttributeMapping(userMappings.getProperty("middleName"), user.getMiddleName(), (Attributes)attributes);
        this.addAttributeMapping(userMappings.getProperty("lastName"), user.getLastName(), (Attributes)attributes);
        this.addAttributeMapping(userMappings.getProperty("jobTitle"), user.getJobTitle(), (Attributes)attributes);
        this.addAttributeMapping(userMappings.getProperty("portrait"), this.getUserPortrait(user), (Attributes)attributes);
        this.addAttributeMapping(userMappings.getProperty("status"), String.valueOf(user.getStatus()), (Attributes)attributes);
        return attributes;
    }

    @Override
    public Modifications getLDAPUserGroupModifications(long ldapServerId, List<UserGroup> userGroups, User user, Properties userMappings) throws Exception {
        Modifications modifications = Modifications.getInstance();
        String groupMappingAttributeName = userMappings.getProperty("group");
        if (Validator.isNull((String)groupMappingAttributeName)) {
            return modifications;
        }
        Properties groupMappings = this._ldapSettings.getGroupMappings(ldapServerId, user.getCompanyId());
        String userDN = this.getUserDNName(ldapServerId, user, userMappings);
        for (UserGroup userGroup : userGroups) {
            String groupDN = this.getGroupDNName(ldapServerId, userGroup, groupMappings);
            if (this._portalLDAP.isUserGroupMember(ldapServerId, user.getCompanyId(), groupDN, userDN)) continue;
            modifications.addItem(1, groupMappingAttributeName, groupDN);
        }
        return modifications;
    }

    @Override
    public Modifications getLDAPUserModifications(User user, Map<String, Serializable> userExpandoAttributes, Properties userMappings, Properties userExpandoMappings) throws Exception {
        String portraitKey;
        Modifications modifications = this.getModifications(user, userMappings, this._reservedUserFieldNames);
        if (PasswordModificationThreadLocal.isPasswordModified() && Validator.isNotNull((String)PasswordModificationThreadLocal.getPasswordUnencrypted())) {
            String newPassword = this.getEncryptedPasswordForLDAP(user, userMappings);
            String passwordKey = userMappings.getProperty("password");
            this.addModificationItem(passwordKey, newPassword, modifications);
        }
        if (Validator.isNotNull((String)(portraitKey = userMappings.getProperty("portrait")))) {
            this.addModificationItem(new BasicAttribute(portraitKey, this.getUserPortrait(user)), modifications);
        }
        this.populateCustomAttributeModifications(user, user.getExpandoBridge(), userExpandoAttributes, userExpandoMappings, modifications);
        return modifications;
    }

    @Override
    public String getUserDNName(long ldapServerId, User user, Properties userMappings) throws Exception {
        Binding userBinding = this._portalLDAP.getUser(ldapServerId, user.getCompanyId(), user.getScreenName(), user.getEmailAddress());
        if (userBinding != null) {
            return this._portalLDAP.getNameInNamespace(ldapServerId, user.getCompanyId(), userBinding);
        }
        StringBundler sb = new StringBundler(5);
        sb.append(GetterUtil.getString((String)userMappings.getProperty(this._userDNFieldName), (String)_DEFAULT_DN));
        sb.append("=");
        sb.append(BeanPropertiesUtil.getStringSilent((Object)user, (String)this._userDNFieldName));
        sb.append(",");
        sb.append(this._portalLDAP.getUsersDN(ldapServerId, user.getCompanyId()));
        return sb.toString();
    }

    public void setContactReservedFieldNames(List<String> reservedContactFieldNames) {
        for (String reservedContactFieldName : reservedContactFieldNames) {
            this._reservedContactFieldNames.put(reservedContactFieldName, reservedContactFieldName);
        }
    }

    public void setUserDNFieldName(String userDNFieldName) {
        this._userDNFieldName = userDNFieldName;
    }

    public void setUserReservedFieldNames(List<String> reservedUserFieldNames) {
        for (String reservedUserFieldName : reservedUserFieldNames) {
            this._reservedUserFieldNames.put(reservedUserFieldName, reservedUserFieldName);
        }
    }

    protected void addAttributeMapping(String attributeName, Object attributeValue, Attributes attributes) {
        if (Validator.isNotNull((String)attributeName) && attributeValue != null) {
            attributes.put(attributeName, attributeValue);
        }
    }

    protected void addAttributeMapping(String attributeName, String attributeValue, Attributes attributes) {
        if (Validator.isNotNull((String)attributeName) && Validator.isNotNull((String)attributeValue)) {
            attributes.put(attributeName, attributeValue);
        }
    }

    protected void addModificationItem(BasicAttribute basicAttribute, Modifications modifications) {
        if (basicAttribute != null) {
            modifications.addItem(basicAttribute);
        }
    }

    protected void addModificationItem(String attributeName, String attributeValue, Modifications modifications) {
        if (Validator.isNotNull((String)attributeName)) {
            modifications.addItem(attributeName, attributeValue);
        }
    }

    protected String getEncryptedPasswordForLDAP(User user, Properties userMappings) {
        String password = PasswordModificationThreadLocal.getPasswordUnencrypted();
        if (Validator.isNull((String)password)) {
            return password;
        }
        LDAPAuthConfiguration ldapAuthConfiguration = this._ldapAuthConfigurationProvider.getConfiguration(user.getCompanyId());
        String algorithm = ldapAuthConfiguration.passwordEncryptionAlgorithm();
        if (Validator.isNull((String)algorithm)) {
            return password;
        }
        try {
            StringBundler sb = new StringBundler(4);
            if (!algorithm.equals("NONE")) {
                sb.append("{");
                sb.append(algorithm);
                sb.append("}");
            }
            sb.append(this._passwordEncryptor.encrypt(algorithm, password, null));
            String passwordKey = userMappings.getProperty("password");
            if (passwordKey.equals("unicodePwd")) {
                String quotedPassword = "\"".concat(sb.toString()).concat("\"");
                byte[] unicodePassword = quotedPassword.getBytes("UTF-16LE");
                return new String(unicodePassword);
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected Modifications getModifications(Object object, Properties objectMappings, Map<String, String> reservedFieldNames) {
        Modifications modifications = Modifications.getInstance();
        for (Map.Entry<Object, Object> entry : objectMappings.entrySet()) {
            String fieldName = (String)entry.getKey();
            if (reservedFieldNames.containsKey(fieldName)) continue;
            String ldapAttributeName = (String)entry.getValue();
            try {
                Object attributeValue = BeanPropertiesUtil.getObjectSilent((Object)object, (String)fieldName);
                if (attributeValue == null) continue;
                this.addModificationItem(ldapAttributeName, attributeValue.toString(), modifications);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to map field " + fieldName + " to class " + object.getClass()), (Throwable)e);
            }
        }
        return modifications;
    }

    protected byte[] getUserPortrait(User user) {
        byte[] bytes;
        block4: {
            bytes = null;
            if (user.getPortraitId() == 0L) {
                return bytes;
            }
            Image image = null;
            try {
                image = this._imageLocalService.getImage(user.getPortraitId());
                if (image != null) {
                    bytes = image.getTextObj();
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to get the portrait for user " + user.getUserId()), (Throwable)e);
            }
        }
        return bytes;
    }

    protected void populateCustomAttributeModifications(Object object, ExpandoBridge expandoBridge, Map<String, Serializable> expandoAttributes, Properties expandoMappings, Modifications modifications) {
        if (expandoAttributes == null || expandoAttributes.isEmpty()) {
            return;
        }
        for (Map.Entry<Object, Object> entry : expandoMappings.entrySet()) {
            String fieldName = (String)entry.getKey();
            String ldapAttributeName = (String)entry.getValue();
            Serializable fieldValue = expandoAttributes.get(fieldName);
            if (fieldValue == null) continue;
            try {
                int type = expandoBridge.getAttributeType(fieldName);
                String value = ExpandoConverterUtil.getStringFromAttribute((int)type, (Serializable)fieldValue);
                this.addModificationItem(ldapAttributeName, value, modifications);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to map field " + fieldName + " to class " + object.getClass()), (Throwable)e);
            }
        }
    }

    @Reference(unbind="-")
    protected void setImageLocalService(ImageLocalService imageLocalService) {
        this._imageLocalService = imageLocalService;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration)", unbind="-")
    protected void setLDAPAuthConfigurationProvider(ConfigurationProvider<LDAPAuthConfiguration> ldapAuthConfigurationProvider) {
        this._ldapAuthConfigurationProvider = ldapAuthConfigurationProvider;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration)", unbind="-")
    protected void setLDAPServerConfigurationProvider(ConfigurationProvider<LDAPServerConfiguration> ldapServerConfigurationProvider) {
        this._ldapServerConfigurationProvider = ldapServerConfigurationProvider;
    }

    @Reference(unbind="-")
    protected void setLdapSettings(LDAPSettings ldapSettings) {
        this._ldapSettings = ldapSettings;
    }

    @Reference(unbind="-")
    protected void setPasswordEncryptor(PasswordEncryptor passwordEncryptor) {
        this._passwordEncryptor = passwordEncryptor;
    }

    @Reference(unbind="-")
    protected void setPortalLDAP(PortalLDAP portalLDAP) {
        this._portalLDAP = portalLDAP;
    }
}

