/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.configuration;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.security.ldap.configuration.BaseConfigurationProvider;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"factoryPid=com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration"}, service={ConfigurationProvider.class})
public class LDAPServerConfigurationProviderImpl
extends BaseConfigurationProvider<LDAPServerConfiguration>
implements ConfigurationProvider<LDAPServerConfiguration> {
    private final Map<Long, Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>>> _configurations = new ConcurrentHashMap<Long, Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>>>();
    private final LDAPServerConfiguration _defaultLDAPServerConfiguration = (LDAPServerConfiguration)ConfigurableUtil.createConfigurable(LDAPServerConfiguration.class, Collections.emptyMap());

    @Override
    public boolean delete(long companyId) {
        Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>> objectValuePairs = this._configurations.remove(companyId);
        if (MapUtil.isEmpty(objectValuePairs)) {
            return false;
        }
        for (ObjectValuePair<Configuration, LDAPServerConfiguration> objectValuePair : objectValuePairs.values()) {
            Configuration configuration = (Configuration)objectValuePair.getKey();
            try {
                configuration.delete();
            }
            catch (IOException ioe) {
                throw new SystemException((Throwable)ioe);
            }
        }
        return true;
    }

    @Override
    public boolean delete(long companyId, long ldapServerId) {
        Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>> objectValuePairs = this._configurations.get(companyId);
        if (MapUtil.isEmpty(objectValuePairs)) {
            return false;
        }
        ObjectValuePair<Configuration, LDAPServerConfiguration> objectValuePair = objectValuePairs.remove(ldapServerId);
        if (objectValuePair == null) {
            return false;
        }
        Configuration configuration = (Configuration)objectValuePair.getKey();
        try {
            configuration.delete();
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        return true;
    }

    @Override
    public LDAPServerConfiguration getConfiguration(long companyId) {
        List<LDAPServerConfiguration> ldapServerConfigurations = this.getConfigurations(companyId);
        LDAPServerConfiguration ldapServerConfiguration = null;
        ldapServerConfiguration = !ldapServerConfigurations.isEmpty() ? ldapServerConfigurations.get(0) : (LDAPServerConfiguration)ConfigurableUtil.createConfigurable(this.getMetatype(), (Dictionary)new HashMapDictionary());
        return ldapServerConfiguration;
    }

    @Override
    public LDAPServerConfiguration getConfiguration(long companyId, long ldapServerId) {
        ObjectValuePair<Configuration, LDAPServerConfiguration> objectValuePair;
        Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>> objectValuePairs = this._configurations.get(companyId);
        Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>> defaultObjectValuePairs = this._configurations.get(0L);
        if (MapUtil.isEmpty(objectValuePairs) && MapUtil.isEmpty(defaultObjectValuePairs)) {
            return this._defaultLDAPServerConfiguration;
        }
        if (MapUtil.isEmpty(objectValuePairs)) {
            objectValuePairs = defaultObjectValuePairs;
        }
        if ((objectValuePair = objectValuePairs.get(ldapServerId)) == null && !MapUtil.isEmpty(defaultObjectValuePairs)) {
            objectValuePair = defaultObjectValuePairs.get(0L);
        }
        if (objectValuePair == null) {
            return this._defaultLDAPServerConfiguration;
        }
        return (LDAPServerConfiguration)objectValuePair.getValue();
    }

    @Override
    public Dictionary<String, Object> getConfigurationProperties(long companyId) {
        List<Dictionary<String, Object>> configurationsProperties = this.getConfigurationsProperties(companyId);
        if (configurationsProperties.isEmpty()) {
            return new HashMapDictionary();
        }
        return configurationsProperties.get(0);
    }

    @Override
    public Dictionary<String, Object> getConfigurationProperties(long companyId, long ldapServerId) {
        ObjectValuePair<Configuration, LDAPServerConfiguration> objectValuePair;
        Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>> objectValuePairs = this._configurations.get(companyId);
        Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>> defaultObjectValuePairs = this._configurations.get(0L);
        if (MapUtil.isEmpty(objectValuePairs) && MapUtil.isEmpty(defaultObjectValuePairs)) {
            return new HashMapDictionary();
        }
        if (MapUtil.isEmpty(objectValuePairs)) {
            objectValuePairs = defaultObjectValuePairs;
        }
        if ((objectValuePair = objectValuePairs.get(ldapServerId)) == null && !MapUtil.isEmpty(defaultObjectValuePairs)) {
            objectValuePair = defaultObjectValuePairs.get(0L);
        }
        if (objectValuePair == null) {
            return new HashMapDictionary();
        }
        Configuration configuration = (Configuration)objectValuePair.getKey();
        return configuration.getProperties();
    }

    @Override
    public List<LDAPServerConfiguration> getConfigurations(long companyId) {
        return this.getConfigurations(companyId, true);
    }

    @Override
    public List<LDAPServerConfiguration> getConfigurations(long companyId, boolean useDefault) {
        Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>> objectValuePairs = this._configurations.get(companyId);
        if (MapUtil.isEmpty(objectValuePairs) && useDefault) {
            objectValuePairs = this._configurations.get(0L);
        }
        ArrayList<LDAPServerConfiguration> ldapServerConfigurations = new ArrayList<LDAPServerConfiguration>();
        if (MapUtil.isEmpty(objectValuePairs) && useDefault) {
            ldapServerConfigurations.add(this._defaultLDAPServerConfiguration);
        } else if (!MapUtil.isEmpty(objectValuePairs)) {
            for (ObjectValuePair<Configuration, LDAPServerConfiguration> objectValuePair : objectValuePairs.values()) {
                ldapServerConfigurations.add((LDAPServerConfiguration)objectValuePair.getValue());
            }
        }
        return ldapServerConfigurations;
    }

    @Override
    public List<Dictionary<String, Object>> getConfigurationsProperties(long companyId) {
        return this.getConfigurationsProperties(companyId, true);
    }

    @Override
    public List<Dictionary<String, Object>> getConfigurationsProperties(long companyId, boolean useDefault) {
        Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>> objectValuePairs = this._configurations.get(companyId);
        if (MapUtil.isEmpty(objectValuePairs) && useDefault) {
            objectValuePairs = this._configurations.get(0L);
        }
        ArrayList<Dictionary<String, Object>> configurationsProperties = new ArrayList<Dictionary<String, Object>>();
        if (MapUtil.isEmpty(objectValuePairs) && useDefault) {
            configurationsProperties.add((Dictionary<String, Object>)new HashMapDictionary());
        } else if (!MapUtil.isEmpty(objectValuePairs)) {
            for (ObjectValuePair<Configuration, LDAPServerConfiguration> objectValuePair : objectValuePairs.values()) {
                Configuration configuration = (Configuration)objectValuePair.getKey();
                Dictionary properties = configuration.getProperties();
                configurationsProperties.add(properties);
            }
        }
        return configurationsProperties;
    }

    @Override
    public Class<LDAPServerConfiguration> getMetatype() {
        return LDAPServerConfiguration.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConfiguration(Configuration configuration) {
        Dictionary properties = configuration.getProperties();
        if (properties == null) {
            properties = new HashMapDictionary();
        }
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)ConfigurableUtil.createConfigurable(this.getMetatype(), (Dictionary)properties);
        Map<Long, Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>>> map = this._configurations;
        synchronized (map) {
            Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>> ldapServerConfigurations = this._configurations.get(ldapServerConfiguration.companyId());
            if (ldapServerConfigurations == null) {
                ldapServerConfigurations = new TreeMap<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>>();
                this._configurations.put(ldapServerConfiguration.companyId(), ldapServerConfigurations);
            }
            ldapServerConfigurations.put(ldapServerConfiguration.ldapServerId(), (ObjectValuePair<Configuration, LDAPServerConfiguration>)new ObjectValuePair((Object)configuration, (Object)ldapServerConfiguration));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConfiguration(Configuration configuration) {
        Dictionary properties = configuration.getProperties();
        if (properties == null) {
            properties = new HashMapDictionary();
        }
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)ConfigurableUtil.createConfigurable(this.getMetatype(), (Dictionary)properties);
        Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>> objectValuePairs = this._configurations.get(ldapServerConfiguration.companyId());
        Map<Long, Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>>> map = this._configurations;
        synchronized (map) {
            if (!MapUtil.isEmpty(objectValuePairs)) {
                objectValuePairs.remove(ldapServerConfiguration.ldapServerId());
                if (objectValuePairs.isEmpty()) {
                    this._configurations.remove(ldapServerConfiguration.companyId());
                }
            }
        }
    }

    @Override
    public void updateProperties(long companyId, Dictionary<String, Object> properties) {
        this.updateProperties(companyId, 0L, properties);
    }

    @Override
    public void updateProperties(long companyId, long ldapServerId, Dictionary<String, Object> properties) {
        if (properties == null) {
            properties = new HashMapDictionary();
        }
        properties.put("companyId", companyId);
        properties.put("ldapServerId", ldapServerId);
        Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>> objectValuePairs = this._configurations.get(companyId);
        if (objectValuePairs == null) {
            objectValuePairs = new HashMap<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>>();
            this._configurations.put(companyId, objectValuePairs);
        }
        try {
            ObjectValuePair<Configuration, LDAPServerConfiguration> objectValuePair = objectValuePairs.get(ldapServerId);
            Configuration configuration = null;
            configuration = objectValuePair == null ? this.configurationAdmin.createFactoryConfiguration(this.getMetatypeId(), "?") : (Configuration)objectValuePair.getKey();
            configuration.update((Dictionary)properties);
        }
        catch (IOException ioe) {
            throw new SystemException("Unable to update configuration", (Throwable)ioe);
        }
    }

    @Override
    @Reference(unbind="-")
    protected void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }
}

