/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.upgrade.v1_0_0;

import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration;
import com.liferay.portal.security.ldap.configuration.SystemLDAPConfiguration;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPExportConfiguration;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration;
import java.util.Dictionary;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class LDAPSystemConfigurationsUpgradeProcess
extends UpgradeProcess {
    private final ConfigurationAdmin _configurationAdmin;
    private final ConfigurationProvider _configurationProvider;

    public LDAPSystemConfigurationsUpgradeProcess(ConfigurationAdmin configurationAdmin, ConfigurationProvider configurationProvider) {
        this._configurationAdmin = configurationAdmin;
        this._configurationProvider = configurationProvider;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeConfiguration(LDAPAuthConfiguration.class.getName());
        this._upgradeConfiguration(LDAPExportConfiguration.class.getName());
        this._upgradeConfiguration(LDAPImportConfiguration.class.getName());
        this._upgradeConfiguration(SystemLDAPConfiguration.class.getName());
    }

    private void _upgradeConfiguration(String className) throws Exception {
        Configuration[] configurations = this._configurationAdmin.listConfigurations("(service.factoryPid=" + className + ")");
        if (configurations == null) {
            return;
        }
        for (Configuration configuration : configurations) {
            Dictionary configurationProperties = configuration.getProperties();
            long companyId = GetterUtil.getLong(configurationProperties.get("companyId"));
            if (companyId != 0L) continue;
            this._configurationProvider.saveSystemConfiguration(Class.forName(className), configurationProperties);
            configuration.delete();
        }
    }
}

