/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.exportimport;

import com.liferay.portal.security.ldap.SafeLdapContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class LDAPImportContext {
    private final long _companyId;
    private final Properties _contactExpandoMappings;
    private final Properties _contactMappings;
    private final Properties _groupMappings;
    private final Map<String, Long> _importedLdapUsers = new HashMap<String, Long>();
    private final long _ldapServerId;
    private final Set<String> _ldapUserIgnoreAttributes;
    private final SafeLdapContext _safeLdapContext;
    private final Properties _userExpandoMappings;
    private final Properties _userMappings;

    public LDAPImportContext(long companyId, Properties contactExpandoMappings, Properties contactMappings, Properties groupMappings, SafeLdapContext safeLdapContext, long ldapServerId, Set<String> ldapUserIgnoreAttributes, Properties userExpandoMappings, Properties userMappings) {
        this._companyId = companyId;
        this._contactExpandoMappings = contactExpandoMappings;
        this._contactMappings = contactMappings;
        this._groupMappings = groupMappings;
        this._safeLdapContext = safeLdapContext;
        this._ldapServerId = ldapServerId;
        this._ldapUserIgnoreAttributes = ldapUserIgnoreAttributes;
        this._userExpandoMappings = userExpandoMappings;
        this._userMappings = userMappings;
    }

    public void addImportedUserId(String fullUserDN, long userId) {
        this._importedLdapUsers.put(fullUserDN, userId);
    }

    public boolean containsImportedUser(String fullUserDN) {
        return this._importedLdapUsers.containsKey(fullUserDN);
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public Properties getContactExpandoMappings() {
        return this._contactExpandoMappings;
    }

    public Properties getContactMappings() {
        return this._contactMappings;
    }

    public Properties getGroupMappings() {
        return this._groupMappings;
    }

    public Long getImportedUserId(String fullUserDN) {
        return this._importedLdapUsers.get(fullUserDN);
    }

    public long getLdapServerId() {
        return this._ldapServerId;
    }

    public Set<String> getLdapUserIgnoreAttributes() {
        return this._ldapUserIgnoreAttributes;
    }

    public SafeLdapContext getSafeLdapContext() {
        return this._safeLdapContext;
    }

    public Properties getUserExpandoMappings() {
        return this._userExpandoMappings;
    }

    public Properties getUserMappings() {
        return this._userMappings;
    }
}

