/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.configuration;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.security.ldap.configuration.BaseConfigurationProvider;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"factoryPid=com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration"}, service={ConfigurationProvider.class})
public class LDAPServerConfigurationProviderImpl
extends BaseConfigurationProvider<LDAPServerConfiguration>
implements ConfigurationProvider<LDAPServerConfiguration> {
    private static final Log _log = LogFactoryUtil.getLog(LDAPServerConfigurationProviderImpl.class);
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    private final Map<Long, Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>>> _configurations = new ConcurrentHashMap<Long, Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>>>();
    private final LDAPServerConfiguration _defaultLDAPServerConfiguration = (LDAPServerConfiguration)ConfigurableUtil.createConfigurable(LDAPServerConfiguration.class, Collections.emptyMap());
    private final Map<String, Long> _pidCompanyConfigurations = new HashMap<String, Long>();
    private final Map<String, Long> _pidServerConfigurations = new HashMap<String, Long>();

    public boolean delete(long companyId) {
        Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>> objectValuePairs = this._configurations.remove(companyId);
        if (MapUtil.isEmpty(objectValuePairs)) {
            return false;
        }
        for (ObjectValuePair<Configuration, LDAPServerConfiguration> objectValuePair : objectValuePairs.values()) {
            Configuration configuration = (Configuration)objectValuePair.getKey();
            this._pidCompanyConfigurations.remove(configuration.getPid());
            this._pidServerConfigurations.remove(configuration.getPid());
            try {
                configuration.delete();
            }
            catch (IOException ioException) {
                throw new SystemException((Throwable)ioException);
            }
        }
        return true;
    }

    public boolean delete(long companyId, long ldapServerId) {
        Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>> objectValuePairs = this._configurations.get(companyId);
        if (MapUtil.isEmpty(objectValuePairs)) {
            return false;
        }
        ObjectValuePair<Configuration, LDAPServerConfiguration> objectValuePair = objectValuePairs.remove(ldapServerId);
        if (objectValuePair == null) {
            return false;
        }
        Configuration configuration = (Configuration)objectValuePair.getKey();
        this._pidCompanyConfigurations.remove(configuration.getPid());
        this._pidServerConfigurations.remove(configuration.getPid());
        try {
            configuration.delete();
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
        return true;
    }

    public LDAPServerConfiguration getConfiguration(long companyId) {
        List<LDAPServerConfiguration> ldapServerConfigurations = this.getConfigurations(companyId);
        LDAPServerConfiguration ldapServerConfiguration = null;
        ldapServerConfiguration = !ldapServerConfigurations.isEmpty() ? ldapServerConfigurations.get(0) : (LDAPServerConfiguration)ConfigurableUtil.createConfigurable(this.getMetatype(), (Dictionary)new HashMapDictionary());
        return ldapServerConfiguration;
    }

    public LDAPServerConfiguration getConfiguration(long companyId, long ldapServerId) {
        ObjectValuePair<Configuration, LDAPServerConfiguration> objectValuePair;
        Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>> objectValuePairs = this._configurations.get(companyId);
        Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>> defaultObjectValuePairs = this._configurations.get(0L);
        if (MapUtil.isEmpty(objectValuePairs) && MapUtil.isEmpty(defaultObjectValuePairs)) {
            return this._defaultLDAPServerConfiguration;
        }
        if (MapUtil.isEmpty(objectValuePairs)) {
            objectValuePairs = defaultObjectValuePairs;
        }
        if ((objectValuePair = objectValuePairs.get(ldapServerId)) == null && MapUtil.isNotEmpty(defaultObjectValuePairs)) {
            objectValuePair = defaultObjectValuePairs.get(0L);
        }
        if (objectValuePair == null) {
            return this._defaultLDAPServerConfiguration;
        }
        return (LDAPServerConfiguration)objectValuePair.getValue();
    }

    public Dictionary<String, Object> getConfigurationProperties(long companyId) {
        List<Dictionary<String, Object>> configurationsProperties = this.getConfigurationsProperties(companyId);
        if (configurationsProperties.isEmpty()) {
            return new HashMapDictionary();
        }
        return configurationsProperties.get(0);
    }

    public Dictionary<String, Object> getConfigurationProperties(long companyId, long ldapServerId) {
        ObjectValuePair<Configuration, LDAPServerConfiguration> objectValuePair;
        Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>> objectValuePairs = this._configurations.get(companyId);
        Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>> defaultObjectValuePairs = this._configurations.get(0L);
        if (MapUtil.isEmpty(objectValuePairs) && MapUtil.isEmpty(defaultObjectValuePairs)) {
            return new HashMapDictionary();
        }
        if (MapUtil.isEmpty(objectValuePairs)) {
            objectValuePairs = defaultObjectValuePairs;
        }
        if ((objectValuePair = objectValuePairs.get(ldapServerId)) == null && MapUtil.isNotEmpty(defaultObjectValuePairs)) {
            objectValuePair = defaultObjectValuePairs.get(0L);
        }
        if (objectValuePair == null) {
            return new HashMapDictionary();
        }
        Configuration configuration = (Configuration)objectValuePair.getKey();
        return configuration.getProperties();
    }

    public List<LDAPServerConfiguration> getConfigurations(long companyId) {
        return this.getConfigurations(companyId, true);
    }

    public List<LDAPServerConfiguration> getConfigurations(long companyId, boolean useDefault) {
        Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>> objectValuePairs = this._configurations.get(companyId);
        if (MapUtil.isEmpty(objectValuePairs) && useDefault) {
            objectValuePairs = this._configurations.get(0L);
        }
        ArrayList<LDAPServerConfiguration> ldapServerConfigurations = new ArrayList<LDAPServerConfiguration>();
        if (MapUtil.isEmpty(objectValuePairs) && useDefault) {
            ldapServerConfigurations.add(this._defaultLDAPServerConfiguration);
        } else if (MapUtil.isNotEmpty(objectValuePairs)) {
            ArrayList<ObjectValuePair<Configuration, LDAPServerConfiguration>> objectValuePairsList = new ArrayList<ObjectValuePair<Configuration, LDAPServerConfiguration>>(objectValuePairs.values());
            objectValuePairsList.sort(Comparator.comparing(o -> {
                Configuration configuration = (Configuration)o.getKey();
                try {
                    Dictionary properties = configuration.getProperties();
                    return GetterUtil.getLong(properties.get("authServerPriority"));
                }
                catch (IllegalStateException illegalStateException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)illegalStateException);
                    }
                    return 0L;
                }
            }));
            objectValuePairsList.forEach(o -> ldapServerConfigurations.add((LDAPServerConfiguration)o.getValue()));
        }
        return ldapServerConfigurations;
    }

    public List<Dictionary<String, Object>> getConfigurationsProperties(long companyId) {
        return this.getConfigurationsProperties(companyId, true);
    }

    public List<Dictionary<String, Object>> getConfigurationsProperties(long companyId, boolean useDefault) {
        Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>> objectValuePairs = this._configurations.get(companyId);
        if (MapUtil.isEmpty(objectValuePairs) && useDefault) {
            objectValuePairs = this._configurations.get(0L);
        }
        ArrayList<Dictionary<String, Object>> configurationsProperties = new ArrayList<Dictionary<String, Object>>();
        if (MapUtil.isEmpty(objectValuePairs) && useDefault) {
            configurationsProperties.add((Dictionary<String, Object>)new HashMapDictionary());
        } else if (MapUtil.isNotEmpty(objectValuePairs)) {
            for (ObjectValuePair<Configuration, LDAPServerConfiguration> objectValuePair : objectValuePairs.values()) {
                Configuration configuration = (Configuration)objectValuePair.getKey();
                configurationsProperties.add(configuration.getProperties());
            }
        }
        return configurationsProperties;
    }

    public Class<LDAPServerConfiguration> getMetatype() {
        return LDAPServerConfiguration.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConfiguration(Configuration configuration) {
        Dictionary properties = configuration.getProperties();
        if (properties == null) {
            properties = new HashMapDictionary();
        }
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)ConfigurableUtil.createConfigurable(this.getMetatype(), (Dictionary)properties);
        Map<Long, Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>>> map = this._configurations;
        synchronized (map) {
            Map ldapServerConfigurations = this._configurations.computeIfAbsent(ldapServerConfiguration.companyId(), k -> new TreeMap());
            ldapServerConfigurations.put(ldapServerConfiguration.ldapServerId(), new ObjectValuePair((Object)configuration, (Object)ldapServerConfiguration));
            this._pidCompanyConfigurations.put(configuration.getPid(), ldapServerConfiguration.companyId());
            this._pidServerConfigurations.put(configuration.getPid(), ldapServerConfiguration.ldapServerId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConfiguration(String pid) {
        Map<Long, Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>>> map = this._configurations;
        synchronized (map) {
            Long companyId = this._pidCompanyConfigurations.remove(pid);
            Long ldapServerId = this._pidServerConfigurations.remove(pid);
            Map<Long, ObjectValuePair<Configuration, LDAPServerConfiguration>> objectValuePairs = null;
            if (companyId != null) {
                objectValuePairs = this._configurations.get(companyId);
            }
            if (ldapServerId != null && MapUtil.isNotEmpty(objectValuePairs)) {
                objectValuePairs.remove(ldapServerId);
            }
        }
    }

    public void updateProperties(long companyId, Dictionary<String, Object> properties) {
        this.updateProperties(companyId, 0L, properties);
    }

    public void updateProperties(long companyId, long ldapServerId, Dictionary<String, Object> properties) {
        if (properties == null) {
            properties = new HashMapDictionary();
        }
        properties.put("companyId", companyId);
        properties.put("ldapServerId", ldapServerId);
        Map objectValuePairs = this._configurations.computeIfAbsent(companyId, k -> new HashMap());
        try {
            ObjectValuePair objectValuePair = (ObjectValuePair)objectValuePairs.get(ldapServerId);
            Configuration configuration = null;
            configuration = objectValuePair == null ? this._configurationAdmin.createFactoryConfiguration(this.getMetatypeId(), "?") : (Configuration)objectValuePair.getKey();
            configuration.update((Dictionary)properties);
        }
        catch (IOException ioException) {
            throw new SystemException("Unable to update configuration", (Throwable)ioException);
        }
    }
}

