/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate.language;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.stringtemplate.AttributeRenderer;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.antlr.stringtemplate.language.ActionEvaluator;
import org.antlr.stringtemplate.language.Expr;
import org.antlr.stringtemplate.language.StringTemplateAST;
import org.antlr.stringtemplate.language.StripIterator;

public class ASTExpr
extends Expr {
    public static final String DEFAULT_ATTRIBUTE_NAME = "it";
    public static final String DEFAULT_ATTRIBUTE_NAME_DEPRECATED = "attr";
    public static final String DEFAULT_INDEX_VARIABLE_NAME = "i";
    public static final String DEFAULT_INDEX0_VARIABLE_NAME = "i0";
    public static final String DEFAULT_MAP_VALUE_NAME = "_default_";
    public static final String DEFAULT_MAP_KEY_NAME = "key";
    public static final StringTemplate MAP_KEY_VALUE = new StringTemplate();
    public static final String EMPTY_OPTION = "empty expr option";
    public static final Map defaultOptionValues = new HashMap(){
        {
            this.put("anchor", new StringTemplateAST(32, "true"));
            this.put("wrap", new StringTemplateAST(32, "\n"));
        }
    };
    public static int totalObjPropRefs = 0;
    public static int totalReflectionLookups = 0;
    AST exprTree = null;
    Map options = null;
    String wrapString = null;
    String nullValue = null;
    String separatorString = null;

    public ASTExpr(StringTemplate stringTemplate, AST aST, Map map) {
        super(stringTemplate);
        this.exprTree = aST;
        this.options = map;
    }

    public AST getAST() {
        return this.exprTree;
    }

    public int write(StringTemplate stringTemplate, StringTemplateWriter stringTemplateWriter) throws IOException {
        if (this.exprTree == null || stringTemplate == null || stringTemplateWriter == null) {
            return 0;
        }
        stringTemplateWriter.pushIndentation(this.getIndentation());
        StringTemplateAST stringTemplateAST = (StringTemplateAST)this.getOption("anchor");
        if (stringTemplateAST != null) {
            stringTemplateWriter.pushAnchorPoint();
        }
        this.handleExprOptions(stringTemplate);
        ActionEvaluator actionEvaluator = new ActionEvaluator(stringTemplate, this, stringTemplateWriter);
        int n = 0;
        try {
            n = actionEvaluator.action(this.exprTree);
        }
        catch (RecognitionException recognitionException) {
            stringTemplate.error("can't evaluate tree: " + this.exprTree.toStringList(), recognitionException);
        }
        stringTemplateWriter.popIndentation();
        if (stringTemplateAST != null) {
            stringTemplateWriter.popAnchorPoint();
        }
        return n;
    }

    private void handleExprOptions(StringTemplate stringTemplate) {
        StringTemplateAST stringTemplateAST;
        StringTemplateAST stringTemplateAST2;
        StringTemplateAST stringTemplateAST3 = (StringTemplateAST)this.getOption("wrap");
        if (stringTemplateAST3 != null) {
            this.wrapString = this.evaluateExpression(stringTemplate, stringTemplateAST3);
        }
        if ((stringTemplateAST2 = (StringTemplateAST)this.getOption("null")) != null) {
            this.nullValue = this.evaluateExpression(stringTemplate, stringTemplateAST2);
        }
        if ((stringTemplateAST = (StringTemplateAST)this.getOption("separator")) != null) {
            this.separatorString = this.evaluateExpression(stringTemplate, stringTemplateAST);
        }
    }

    public Object applyTemplateToListOfAttributes(StringTemplate stringTemplate, List list, StringTemplate stringTemplate2) {
        int n;
        Object object;
        int n2;
        if (list == null || stringTemplate2 == null || list.size() == 0) {
            return null;
        }
        HashMap<String, Object> hashMap = null;
        StringTemplate.STAttributeList sTAttributeList = new StringTemplate.STAttributeList();
        for (n2 = 0; n2 < list.size(); ++n2) {
            object = list.get(n2);
            if (object == null) continue;
            object = ASTExpr.convertAnythingToIterator(object);
            list.set(n2, object);
        }
        n2 = list.size();
        object = stringTemplate2.getFormalArguments();
        if (object == null || object.size() == 0) {
            stringTemplate.error("missing arguments in anonymous template in context " + stringTemplate.getEnclosingInstanceStackString());
            return null;
        }
        Object[] objectArray = object.keySet().toArray();
        if (objectArray.length != n2) {
            stringTemplate.error("number of arguments " + object.keySet() + " mismatch between attribute list and anonymous" + " template in context " + stringTemplate.getEnclosingInstanceStackString());
            n2 = n = Math.min(objectArray.length, n2);
            Object[] objectArray2 = new Object[n];
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            objectArray = objectArray2;
        }
        n = 0;
        while (true) {
            hashMap = new HashMap<String, Object>();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                Iterator iterator = (Iterator)list.get(i);
                if (iterator != null && iterator.hasNext()) {
                    String string = (String)objectArray[i];
                    Object e = iterator.next();
                    hashMap.put(string, e);
                    continue;
                }
                ++n3;
            }
            if (n3 == n2) break;
            hashMap.put(DEFAULT_INDEX_VARIABLE_NAME, new Integer(n + 1));
            hashMap.put(DEFAULT_INDEX0_VARIABLE_NAME, new Integer(n));
            StringTemplate stringTemplate3 = stringTemplate2.getInstanceOf();
            stringTemplate3.setEnclosingInstance(stringTemplate);
            stringTemplate3.setArgumentContext(hashMap);
            sTAttributeList.add(stringTemplate3);
            ++n;
        }
        return sTAttributeList;
    }

    public Object applyListOfAlternatingTemplates(StringTemplate stringTemplate, Object object, List list) {
        boolean bl;
        if (object == null || list == null || list.size() == 0) {
            return null;
        }
        StringTemplate stringTemplate2 = null;
        HashMap<String, Object> hashMap = null;
        object = ASTExpr.convertArrayToList(object);
        if ((object = ASTExpr.convertAnythingIteratableToIterator(object)) instanceof Iterator) {
            StringTemplate.STAttributeList sTAttributeList = new StringTemplate.STAttributeList();
            Iterator iterator = (Iterator)object;
            int n = 0;
            while (iterator.hasNext()) {
                Object object2 = iterator.next();
                if (object2 == null) {
                    if (this.nullValue == null) continue;
                    object2 = this.nullValue;
                }
                int n2 = n % list.size();
                stringTemplate2 = (StringTemplate)list.get(n2);
                StringTemplateAST stringTemplateAST = stringTemplate2.getArgumentsAST();
                stringTemplate2 = stringTemplate2.getInstanceOf();
                stringTemplate2.setEnclosingInstance(stringTemplate);
                stringTemplate2.setArgumentsAST(stringTemplateAST);
                hashMap = new HashMap();
                Map map = stringTemplate2.getFormalArguments();
                boolean bl2 = stringTemplate2.getName() == "anonymous";
                this.setSoleFormalArgumentToIthValue(stringTemplate2, hashMap, object2);
                if (!bl2 || map == null || map.size() <= 0) {
                    hashMap.put(DEFAULT_ATTRIBUTE_NAME, object2);
                    hashMap.put(DEFAULT_ATTRIBUTE_NAME_DEPRECATED, object2);
                }
                hashMap.put(DEFAULT_INDEX_VARIABLE_NAME, new Integer(n + 1));
                hashMap.put(DEFAULT_INDEX0_VARIABLE_NAME, new Integer(n));
                stringTemplate2.setArgumentContext(hashMap);
                this.evaluateArguments(stringTemplate2);
                sTAttributeList.add(stringTemplate2);
                ++n;
            }
            if (sTAttributeList.size() == 0) {
                sTAttributeList = null;
            }
            return sTAttributeList;
        }
        stringTemplate2 = (StringTemplate)list.get(0);
        hashMap = new HashMap<String, Object>();
        Map map = stringTemplate2.getFormalArguments();
        StringTemplateAST stringTemplateAST = stringTemplate2.getArgumentsAST();
        this.setSoleFormalArgumentToIthValue(stringTemplate2, hashMap, object);
        boolean bl3 = bl = stringTemplate2.getName() == "anonymous";
        if (!bl || map == null || map.size() <= 0) {
            hashMap.put(DEFAULT_ATTRIBUTE_NAME, object);
            hashMap.put(DEFAULT_ATTRIBUTE_NAME_DEPRECATED, object);
        }
        hashMap.put(DEFAULT_INDEX_VARIABLE_NAME, new Integer(1));
        stringTemplate2.setArgumentContext(hashMap);
        this.evaluateArguments(stringTemplate2);
        return stringTemplate2;
    }

    protected void setSoleFormalArgumentToIthValue(StringTemplate stringTemplate, Map map, Object object) {
        Map map2 = stringTemplate.getFormalArguments();
        if (map2 != null) {
            boolean bl;
            String string = null;
            boolean bl2 = bl = stringTemplate.getName() == "anonymous";
            if (map2.size() == 1 || bl && map2.size() > 0) {
                if (bl && map2.size() > 1) {
                    stringTemplate.error("too many arguments on {...} template: " + map2);
                }
                Set set = map2.keySet();
                string = (String)set.toArray()[0];
                map.put(string, object);
            }
        }
    }

    public Object getObjectProperty(StringTemplate stringTemplate, Object object, String string) {
        if (object == null || string == null) {
            return null;
        }
        ++totalObjPropRefs;
        Object object2 = this.rawGetObjectProperty(stringTemplate, object, string);
        object2 = ASTExpr.convertArrayToList(object2);
        return object2;
    }

    protected Object rawGetObjectProperty(StringTemplate stringTemplate, Object object, String string) {
        Object object2;
        Class<?> clazz = object.getClass();
        Object object3 = null;
        if (clazz == StringTemplate.Aggregate.class) {
            object3 = ((StringTemplate.Aggregate)object).get(string);
            return object3;
        }
        if (clazz == StringTemplate.class && (object2 = ((StringTemplate)object).getAttributes()) != null) {
            object3 = object2.get(string);
            return object3;
        }
        if (object instanceof Map) {
            object2 = (Map)object;
            if (string.equals("keys")) {
                object3 = object2.keySet();
            } else if (string.equals("values")) {
                object3 = object2.values();
            } else if (object2.containsKey(string)) {
                object3 = object2.get(string);
            } else if (object2.containsKey(DEFAULT_MAP_VALUE_NAME)) {
                object3 = object2.get(DEFAULT_MAP_VALUE_NAME);
            }
            if (object3 == MAP_KEY_VALUE) {
                object3 = string;
            }
            return object3;
        }
        object2 = null;
        String string2 = Character.toUpperCase(string.charAt(0)) + string.substring(1, string.length());
        ++totalReflectionLookups;
        object2 = this.getMethod(clazz, "get" + string2);
        if (object2 == null) {
            ++totalReflectionLookups;
            object2 = this.getMethod(clazz, "is" + string2);
        }
        if (object2 != null) {
            try {
                object3 = this.invokeMethod((Method)object2, object, object3);
            }
            catch (Exception exception) {
                stringTemplate.error("Can't get property " + string + " using method get/is" + string2 + " from " + clazz.getName() + " instance", exception);
            }
        } else {
            try {
                ++totalReflectionLookups;
                Field field = clazz.getField(string);
                try {
                    object3 = this.accessField(field, object, object3);
                }
                catch (IllegalAccessException illegalAccessException) {
                    stringTemplate.error("Can't access property " + string + " using method get/is" + string2 + " or direct field access from " + clazz.getName() + " instance", illegalAccessException);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                stringTemplate.error("Class " + clazz.getName() + " has no such attribute: " + string + " in template context " + stringTemplate.getEnclosingInstanceStackString(), noSuchFieldException);
            }
        }
        return object3;
    }

    protected Object accessField(Field field, Object object, Object object2) throws IllegalAccessException {
        try {
            field.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        object2 = field.get(object);
        return object2;
    }

    protected Object invokeMethod(Method method, Object object, Object object2) throws IllegalAccessException, InvocationTargetException {
        try {
            method.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        object2 = method.invoke(object, (Object[])null);
        return object2;
    }

    protected Method getMethod(Class clazz, String string) {
        Method method;
        try {
            method = clazz.getMethod(string, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        return method;
    }

    public boolean testAttributeTrue(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Collection) {
            return ((Collection)object).size() > 0;
        }
        if (object instanceof Map) {
            return ((Map)object).size() > 0;
        }
        if (object instanceof Iterator) {
            return ((Iterator)object).hasNext();
        }
        return true;
    }

    public Object add(Object object, Object object2) {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        return object.toString() + object2.toString();
    }

    public StringTemplate getTemplateInclude(StringTemplate stringTemplate, String string, StringTemplateAST stringTemplateAST) {
        StringTemplateGroup stringTemplateGroup = stringTemplate.getGroup();
        StringTemplate stringTemplate2 = stringTemplateGroup.getEmbeddedInstanceOf(stringTemplate, string);
        if (stringTemplate2 == null) {
            stringTemplate.error("cannot make embedded instance of " + string + " in template " + stringTemplate.getName());
            return null;
        }
        stringTemplate2.setArgumentsAST(stringTemplateAST);
        this.evaluateArguments(stringTemplate2);
        return stringTemplate2;
    }

    public int writeAttribute(StringTemplate stringTemplate, Object object, StringTemplateWriter stringTemplateWriter) {
        return this.write(stringTemplate, object, stringTemplateWriter);
    }

    protected int write(StringTemplate stringTemplate, Object object, StringTemplateWriter stringTemplateWriter) {
        int n;
        block12: {
            if (object == null) {
                if (this.nullValue == null) {
                    return 0;
                }
                object = this.nullValue;
            }
            n = 0;
            try {
                if (object instanceof StringTemplate) {
                    StringTemplate stringTemplate2 = (StringTemplate)object;
                    stringTemplate2.setEnclosingInstance(stringTemplate);
                    if (StringTemplate.inLintMode() && StringTemplate.isRecursiveEnclosingInstance(stringTemplate2)) {
                        throw new IllegalStateException("infinite recursion to " + stringTemplate2.getTemplateDeclaratorString() + " referenced in " + stringTemplate2.getEnclosingInstance().getTemplateDeclaratorString() + "; stack trace:\n" + stringTemplate2.getEnclosingInstanceStackTrace());
                    }
                    if (this.wrapString != null) {
                        n = stringTemplateWriter.writeWrapSeparator(this.wrapString);
                    }
                    n = stringTemplate2.write(stringTemplateWriter);
                    return n;
                }
                if ((object = ASTExpr.convertAnythingIteratableToIterator(object)) instanceof Iterator) {
                    Iterator iterator = (Iterator)object;
                    Object var6_9 = null;
                    boolean bl = false;
                    while (iterator.hasNext()) {
                        Object object2 = iterator.next();
                        if (object2 == null) {
                            object2 = this.nullValue;
                        }
                        if (object2 != null) {
                            if (bl && this.separatorString != null) {
                                n += stringTemplateWriter.writeSeparator(this.separatorString);
                            }
                            bl = true;
                            int n2 = this.write(stringTemplate, object2, stringTemplateWriter);
                            n += n2;
                        }
                        var6_9 = object2;
                    }
                    break block12;
                }
                AttributeRenderer attributeRenderer = stringTemplate.getAttributeRenderer(object.getClass());
                String string = null;
                string = attributeRenderer != null ? attributeRenderer.toString(object) : object.toString();
                n = this.wrapString != null ? stringTemplateWriter.write(string, this.wrapString) : stringTemplateWriter.write(string);
                return n;
            }
            catch (IOException iOException) {
                stringTemplate.error("problem writing object: " + object, iOException);
            }
        }
        return n;
    }

    protected String evaluateExpression(StringTemplate stringTemplate, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof StringTemplateAST) {
            StringTemplateAST stringTemplateAST = (StringTemplateAST)object;
            StringWriter stringWriter = new StringWriter();
            StringTemplateWriter stringTemplateWriter = stringTemplate.getGroup().getStringTemplateWriter(stringWriter);
            ActionEvaluator actionEvaluator = new ActionEvaluator(stringTemplate, this, stringTemplateWriter);
            int n = 0;
            try {
                n = actionEvaluator.action(stringTemplateAST);
            }
            catch (RecognitionException recognitionException) {
                stringTemplate.error("can't evaluate tree: " + this.exprTree.toStringList(), recognitionException);
            }
            return stringWriter.toString();
        }
        return object.toString();
    }

    protected void evaluateArguments(StringTemplate stringTemplate) {
        StringTemplateAST stringTemplateAST = stringTemplate.getArgumentsAST();
        if (stringTemplateAST == null || stringTemplateAST.getFirstChild() == null) {
            return;
        }
        StringTemplate stringTemplate2 = stringTemplate.getEnclosingInstance();
        StringTemplate stringTemplate3 = new StringTemplate(stringTemplate.getGroup(), "");
        stringTemplate3.setName("<invoke " + stringTemplate.getName() + " arg context>");
        stringTemplate3.setEnclosingInstance(stringTemplate2);
        stringTemplate3.setArgumentContext(stringTemplate.getArgumentContext());
        ActionEvaluator actionEvaluator = new ActionEvaluator(stringTemplate3, this, null);
        try {
            Map map = actionEvaluator.argList(stringTemplateAST, stringTemplate, stringTemplate.getArgumentContext());
            stringTemplate.setArgumentContext(map);
        }
        catch (RecognitionException recognitionException) {
            stringTemplate.error("can't evaluate tree: " + stringTemplateAST.toStringList(), recognitionException);
        }
    }

    public static Object convertArrayToList(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            StringTemplate.STAttributeList sTAttributeList = new StringTemplate.STAttributeList(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                sTAttributeList.add(object2);
            }
            object = sTAttributeList;
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            StringTemplate.STAttributeList sTAttributeList = new StringTemplate.STAttributeList(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                sTAttributeList.add(new Integer(n));
            }
            object = sTAttributeList;
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            StringTemplate.STAttributeList sTAttributeList = new StringTemplate.STAttributeList(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                long l = lArray[i];
                sTAttributeList.add(new Long(l));
            }
            object = sTAttributeList;
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            StringTemplate.STAttributeList sTAttributeList = new StringTemplate.STAttributeList(fArray.length);
            for (int i = 0; i < fArray.length; ++i) {
                float f = fArray[i];
                sTAttributeList.add(new Float(f));
            }
            object = sTAttributeList;
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            StringTemplate.STAttributeList sTAttributeList = new StringTemplate.STAttributeList(dArray.length);
            for (int i = 0; i < dArray.length; ++i) {
                double d = dArray[i];
                sTAttributeList.add(new Double(d));
            }
            object = sTAttributeList;
        }
        return object;
    }

    private static Object convertAnythingIteratableToIterator(Object object) {
        Iterator iterator = null;
        if (object instanceof Collection) {
            iterator = ((Collection)object).iterator();
        } else if (object instanceof Map) {
            iterator = ((Map)object).values().iterator();
        } else if (object instanceof Iterator) {
            iterator = (Iterator)object;
        }
        if (iterator == null) {
            return object;
        }
        return iterator;
    }

    static Iterator convertAnythingToIterator(Object object) {
        Iterator iterator = null;
        if (object instanceof Collection) {
            iterator = ((Collection)object).iterator();
        } else if (object instanceof Map) {
            iterator = ((Map)object).values().iterator();
        } else if (object instanceof Iterator) {
            iterator = (Iterator)object;
        }
        if (iterator == null) {
            StringTemplate.STAttributeList sTAttributeList = new StringTemplate.STAttributeList(1);
            sTAttributeList.add(object);
            return sTAttributeList.iterator();
        }
        return iterator;
    }

    public Object first(Object object) {
        Iterator iterator;
        if (object == null) {
            return null;
        }
        Object object2 = object;
        if ((object = ASTExpr.convertAnythingIteratableToIterator(object)) instanceof Iterator && (iterator = (Iterator)object).hasNext()) {
            object2 = iterator.next();
        }
        return object2;
    }

    public Object rest(Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = object;
        if ((object = ASTExpr.convertAnythingIteratableToIterator(object)) instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            if (!iterator.hasNext()) {
                return null;
            }
            iterator.next();
            if (!iterator.hasNext()) {
                return null;
            }
            object2 = iterator;
        } else {
            object2 = null;
        }
        return object2;
    }

    public Object last(Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = object;
        if ((object = ASTExpr.convertAnythingIteratableToIterator(object)) instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                object2 = iterator.next();
            }
        }
        return object2;
    }

    public Object strip(Object object) {
        if (object == null) {
            return null;
        }
        if ((object = ASTExpr.convertAnythingIteratableToIterator(object)) instanceof Iterator) {
            return new StripIterator((Iterator)object);
        }
        return object;
    }

    public Object trunc(Object object) {
        return null;
    }

    public Object length(Object object) {
        if (object == null) {
            return new Integer(0);
        }
        int n = 1;
        if (object instanceof Map) {
            n = ((Map)object).size();
        } else if (object instanceof List) {
            n = ((List)object).size();
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            n = objectArray.length;
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            n = nArray.length;
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            n = lArray.length;
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            n = fArray.length;
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            n = dArray.length;
        } else if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            n = 0;
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
        }
        return new Integer(n);
    }

    public Object getOption(String string) {
        Object var2_2 = null;
        if (this.options != null && (var2_2 = this.options.get(string)) == EMPTY_OPTION) {
            return defaultOptionValues.get(string);
        }
        return var2_2;
    }

    public String toString() {
        return this.exprTree.toStringList();
    }
}

