/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.validator;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.ldap.internal.validator.parser.LDAPFilterLexer;
import com.liferay.portal.security.ldap.internal.validator.parser.LDAPFilterParser;
import com.liferay.portal.security.ldap.validator.LDAPFilterException;
import com.liferay.portal.security.ldap.validator.LDAPFilterValidator;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.osgi.service.component.annotations.Component;

@Component(service={LDAPFilterValidator.class})
public class LDAPFilterValidatorImpl
implements LDAPFilterValidator {
    private static final Log _log = LogFactoryUtil.getLog(LDAPFilterValidatorImpl.class);

    public boolean isValid(String filter) {
        if (Validator.isNull((String)filter)) {
            return true;
        }
        ANTLRStringStream charStream = new ANTLRStringStream(filter);
        LDAPFilterLexer ldapFilterLexer = new LDAPFilterLexer(charStream);
        CommonTokenStream tokenStream = new CommonTokenStream(ldapFilterLexer);
        LDAPFilterParser ldapFilterParser = new LDAPFilterParser(tokenStream);
        try {
            ldapFilterParser.parse();
        }
        catch (Exception exception) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Unable to parse filter " + filter), (Throwable)exception);
            }
            return false;
        }
        return true;
    }

    public void validate(String filter) throws LDAPFilterException {
        if (!this.isValid(filter)) {
            throw new LDAPFilterException("Invalid filter " + filter);
        }
    }

    public void validate(String filter, String filterPropertyName) throws LDAPFilterException {
        if (!this.isValid(filter)) {
            throw new LDAPFilterException(StringBundler.concat((String[])new String[]{"Invalid filter ", filter, " defined by ", filterPropertyName}));
        }
    }
}

